/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.loot;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.loot.conditions.SkillCondition;
import dynamicswordskills.loot.functions.RandomSkillSword;
import dynamicswordskills.loot.functions.SetSkillMetadata;
import dynamicswordskills.ref.Config;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootHandler {
    private LootEntry skillOrbs;
    private LootPool skillOrbsPool;
    private LootEntry[] skillSwords;
    private LootPool skillSwordsPool;

    public LootHandler() {
        if (Config.getLootWeight() > 0) {
            this.skillOrbs = LootHandler.createLootEntry(DynamicSwordSkills.skillOrb, Config.getLootWeight(), 0, new LootFunction[]{new SetSkillMetadata(new LootCondition[0])});
            RandomValueRange rolls = new RandomValueRange(1.0f, 1.0f);
            RandomValueRange bonus = new RandomValueRange(0.0f, 0.0f);
            RandomChance chance = new RandomChance((float)Config.getLootWeight() * 0.01f);
            this.skillOrbsPool = new LootPool(new LootEntry[]{this.skillOrbs}, new LootCondition[]{chance}, rolls, bonus, "skill_orbs");
        }
        if (Config.areRandomSwordsEnabled()) {
            LootFunction[] functions = new LootFunction[]{new RandomSkillSword()};
            SkillCondition enabled = new SkillCondition();
            this.skillSwords = new LootEntry[]{LootHandler.createLootEntry(DynamicSwordSkills.skillWood, Config.getLootWeight(), 0, functions, new LootCondition[]{enabled}), LootHandler.createLootEntry(DynamicSwordSkills.skillStone, Config.getLootWeight(), 1, functions, new LootCondition[]{enabled}), LootHandler.createLootEntry(DynamicSwordSkills.skillIron, Config.getLootWeight(), 3, functions, new LootCondition[]{enabled}), LootHandler.createLootEntry(DynamicSwordSkills.skillGold, Config.getLootWeight(), 2, functions, new LootCondition[]{enabled}), LootHandler.createLootEntry(DynamicSwordSkills.skillDiamond, Config.getLootWeight(), 4, functions, new LootCondition[]{enabled})};
            RandomValueRange rolls = new RandomValueRange(1.0f, 2.0f);
            RandomValueRange bonus = new RandomValueRange(0.0f, 0.5f);
            RandomChance chance = new RandomChance((float)Config.getLootWeight() * 0.02f);
            this.skillSwordsPool = new LootPool(this.skillSwords, new LootCondition[]{enabled, chance}, rolls, bonus, "skill_swords");
        }
    }

    @SubscribeEvent
    public void addLoot(LootTableLoadEvent event) {
        if (!event.getName().func_110624_b().equalsIgnoreCase("minecraft") || !event.getName().func_110623_a().toLowerCase().contains("chest")) {
            return;
        }
        if (this.skillOrbs != null) {
            if (event.getName().equals((Object)LootTableList.field_186420_b)) {
                event.getTable().addPool(this.skillOrbsPool);
            } else {
                event.getTable().getPool("main").addEntry(this.skillOrbs);
            }
        }
        if (Config.areRandomSwordsEnabled()) {
            if (event.getName().equals((Object)LootTableList.field_186420_b)) {
                event.getTable().addPool(this.skillSwordsPool);
            } else {
                for (LootEntry entry : this.skillSwords) {
                    event.getTable().getPool("main").addEntry(entry);
                }
            }
        }
    }

    public static LootEntry createLootEntry(Item item, int weight, int quality, LootFunction[] functions) {
        return LootHandler.createLootEntry(item, weight, quality, functions, new LootCondition[0]);
    }

    public static LootEntry createLootEntry(Item item, int weight, int quality, LootFunction[] functions, LootCondition[] conditions) {
        return new LootEntryItem(item, weight, quality, functions, conditions, item.getRegistryName().toString());
    }

    static {
        LootConditionManager.func_186639_a((LootCondition.Serializer)new SkillCondition.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new RandomSkillSword.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetSkillMetadata.Serializer());
    }
}

