/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.ItemRandomSkill;
import dynamicswordskills.loot.functions.SkillFunction;
import dynamicswordskills.skills.SkillBase;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class RandomSkillSword
extends SkillFunction {
    protected NBTTagCompound skill_tag;

    public RandomSkillSword() {
    }

    public RandomSkillSword(LootCondition[] conditions) {
        super(conditions);
    }

    public RandomSkillSword(LootCondition[] conditions, String skill_name) {
        super(conditions, skill_name);
    }

    public RandomSkillSword(LootCondition[] conditions, NBTTagCompound tag) {
        super(conditions);
        this.skill_tag = tag;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int i = this.getSkillId(rand);
        if (!(stack.func_77973_b() instanceof ItemRandomSkill)) {
            DynamicSwordSkills.logger.warn("Invalid item for RandomSkillSword function: " + stack.toString());
        } else if (this.skill_tag != null) {
            stack.func_77982_d(this.skill_tag);
        } else if (SkillBase.doesSkillExist(i)) {
            ((ItemRandomSkill)stack.func_77973_b()).generateSkillTag(stack, SkillBase.getSkill(i), rand);
        } else {
            DynamicSwordSkills.logger.warn("Skill with ID " + i + " does not exist");
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomSkillSword> {
        public Serializer() {
            super(new ResourceLocation("dynamicswordskills", "get_random_skill_sword"), RandomSkillSword.class);
        }

        public void serialize(JsonObject json, RandomSkillSword instance, JsonSerializationContext context) {
            if (instance.skill_tag != null) {
                json.addProperty("skill_tag", instance.skill_tag.toString());
            } else if (instance.skill_name != null) {
                SkillBase skill = SkillBase.getSkillByName(instance.skill_name);
                if (skill == null) {
                    throw new JsonSyntaxException("Unknown skill '" + instance.skill_name + "'");
                }
                json.addProperty("skill_name", instance.skill_name);
            }
        }

        public RandomSkillSword deserialize(JsonObject json, JsonDeserializationContext context, LootCondition[] conditions) {
            if (json.has("skill_tag")) {
                try {
                    NBTTagCompound tag = JsonToNBT.func_180713_a((String)JsonUtils.func_151200_h((JsonObject)json, (String)"skill_tag"));
                    if (!tag.func_74764_b("ItemSkillName") || !tag.func_74764_b("ItemSkillLevel")) {
                        throw new JsonSyntaxException("Invalid skill tag; correct format is: {ItemSkillName:\"skill_name\",ItemSkillLevel:xb,grantsBasicSword:yb}");
                    }
                    if (SkillBase.getSkillByName(tag.func_74779_i("ItemSkillName")) == null) {
                        throw new JsonSyntaxException("Unknown skill '" + tag.func_74779_i("ItemSkillName") + "'");
                    }
                    return new RandomSkillSword(conditions, tag);
                }
                catch (NBTException e) {
                    throw new JsonSyntaxException((Throwable)e);
                }
            }
            if (json.has("skill_name")) {
                String name = JsonUtils.func_151200_h((JsonObject)json, (String)"skill_name");
                SkillBase skill = SkillBase.getSkillByName(name);
                if (skill == null) {
                    throw new JsonSyntaxException("Unknown skill '" + name + "'");
                }
                return new RandomSkillSword(conditions, name);
            }
            return new RandomSkillSword(conditions);
        }
    }
}

