/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.loot.functions.SkillFunction;
import dynamicswordskills.skills.SkillBase;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class SetSkillMetadata
extends SkillFunction {
    public SetSkillMetadata() {
    }

    public SetSkillMetadata(LootCondition[] conditions) {
        super(conditions);
    }

    public SetSkillMetadata(LootCondition[] conditions, String skill_name) {
        super(conditions, skill_name);
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int i = this.getSkillId(rand);
        if (SkillBase.doesSkillExist(i)) {
            stack.func_77964_b(i);
        } else {
            DynamicSwordSkills.logger.warn("Skill with ID " + i + " does not exist");
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetSkillMetadata> {
        public Serializer() {
            super(new ResourceLocation("dynamicswordskills", "gen_random_skill_meta"), SetSkillMetadata.class);
        }

        public void serialize(JsonObject json, SetSkillMetadata instance, JsonSerializationContext context) {
            if (instance.skill_name != null) {
                SkillBase skill = SkillBase.getSkillByName(instance.skill_name);
                if (skill == null) {
                    throw new JsonSyntaxException("Unknown skill '" + instance.skill_name + "'");
                }
                json.addProperty("skill_name", instance.skill_name);
            }
        }

        public SetSkillMetadata deserialize(JsonObject json, JsonDeserializationContext context, LootCondition[] conditions) {
            if (json.has("skill_name")) {
                String name = JsonUtils.func_151200_h((JsonObject)json, (String)"skill_name");
                SkillBase skill = SkillBase.getSkillByName(name);
                if (skill == null) {
                    throw new JsonSyntaxException("Unknown skill '" + name + "'");
                }
                return new SetSkillMetadata(conditions, name);
            }
            return new SetSkillMetadata(conditions);
        }
    }
}

