/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.loot.functions;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.loot.conditions.SkillCondition;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public abstract class SkillFunction
extends LootFunction {
    public static final List<Integer> SKILL_IDS;
    protected String skill_name;

    public SkillFunction() {
        this(new LootCondition[]{new SkillCondition()});
    }

    public SkillFunction(LootCondition[] conditions) {
        super(conditions);
    }

    public SkillFunction(LootCondition[] conditions, String skill_name) {
        super(conditions);
        this.skill_name = skill_name;
    }

    protected int getSkillId(Random rand) {
        if (this.skill_name != null) {
            SkillBase skill = SkillBase.getSkillByName(this.skill_name);
            if (skill == null) {
                throw new RuntimeException("Unknown skill '" + this.skill_name + "'");
            }
            if (!Config.isSkillEnabled(skill.getId())) {
                DynamicSwordSkills.logger.warn(skill.getDisplayName() + " has been disabled in the Config settings; a random skill will be used instead.");
            } else {
                return skill.getId();
            }
        }
        return SKILL_IDS.get(MathHelper.func_76136_a((Random)rand, (int)0, (int)(SKILL_IDS.size() - 1)));
    }

    static {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SkillBase skill : SkillBase.getSkills()) {
            if (!Config.isSkillEnabled(skill.getId())) continue;
            ids.add(Integer.valueOf(skill.getId()));
        }
        SKILL_IDS = Collections.unmodifiableList(ids);
    }
}

