/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network;

import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.bidirectional.AttackTimePacket;
import dynamicswordskills.network.bidirectional.DeactivateSkillPacket;
import dynamicswordskills.network.bidirectional.PlaySoundPacket;
import dynamicswordskills.network.client.MortalDrawPacket;
import dynamicswordskills.network.client.SyncConfigPacket;
import dynamicswordskills.network.client.SyncPlayerInfoPacket;
import dynamicswordskills.network.client.SyncSkillPacket;
import dynamicswordskills.network.client.UpdateComboPacket;
import dynamicswordskills.network.server.AddExhaustionPacket;
import dynamicswordskills.network.server.DashImpactPacket;
import dynamicswordskills.network.server.EndComboPacket;
import dynamicswordskills.network.server.OpenGuiPacket;
import dynamicswordskills.network.server.RefreshSpinPacket;
import dynamicswordskills.network.server.TargetIdPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("dsschannel");

    public static final void initialize() {
        PacketDispatcher.registerMessage(PlaySoundPacket.class);
        PacketDispatcher.registerMessage(ActivateSkillPacket.class);
        PacketDispatcher.registerMessage(AttackTimePacket.class);
        PacketDispatcher.registerMessage(DeactivateSkillPacket.class);
        PacketDispatcher.registerMessage(MortalDrawPacket.class);
        PacketDispatcher.registerMessage(SyncConfigPacket.class);
        PacketDispatcher.registerMessage(SyncPlayerInfoPacket.class);
        PacketDispatcher.registerMessage(SyncSkillPacket.class);
        PacketDispatcher.registerMessage(UpdateComboPacket.class);
        PacketDispatcher.registerMessage(AddExhaustionPacket.class);
        PacketDispatcher.registerMessage(DashImpactPacket.class);
        PacketDispatcher.registerMessage(EndComboPacket.class);
        PacketDispatcher.registerMessage(OpenGuiPacket.class);
        PacketDispatcher.registerMessage(RefreshSpinPacket.class);
        PacketDispatcher.registerMessage(TargetIdPacket.class);
    }

    private static final <T extends AbstractMessage<T>> void registerMessage(Class<T> clazz) {
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.CLIENT);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        } else {
            dispatcher.registerMessage(clazz, clazz, (int)packetId, Side.CLIENT);
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        }
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.func_130014_f_().field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

