/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.bidirectional;

import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class ActivateSkillPacket
extends AbstractMessage<ActivateSkillPacket> {
    private boolean wasTriggered = false;
    private byte skillId;

    public ActivateSkillPacket() {
    }

    public ActivateSkillPacket(SkillBase skill) {
        this(skill, false);
    }

    public ActivateSkillPacket(SkillBase skill, boolean wasTriggered) {
        this.wasTriggered = wasTriggered;
        this.skillId = skill.getId();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.wasTriggered = buffer.readBoolean();
        this.skillId = buffer.readByte();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeBoolean(this.wasTriggered);
        buffer.writeByte((int)this.skillId);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (this.wasTriggered) {
            DSSPlayerInfo.get(player).triggerSkill(player.func_130014_f_(), this.skillId);
        } else {
            DSSPlayerInfo.get(player).activateSkill(player.func_130014_f_(), this.skillId);
        }
    }
}

