/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.bidirectional;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class DeactivateSkillPacket
extends AbstractMessage<DeactivateSkillPacket> {
    private byte skillId;

    public DeactivateSkillPacket() {
    }

    public DeactivateSkillPacket(SkillActive skill) {
        this.skillId = skill.getId();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.skillId = buffer.readByte();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte((int)this.skillId);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        SkillBase skill = DSSPlayerInfo.get(player).getPlayerSkill(this.skillId);
        if (skill instanceof SkillActive) {
            ((SkillActive)skill).deactivate(player);
        } else {
            DynamicSwordSkills.logger.warn(String.format("Skill with ID %d was not valid for %s while processing DeactivateSkillPacket", this.skillId, player));
        }
    }
}

