/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.server;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;

public class DashImpactPacket
extends AbstractMessage.AbstractServerMessage<DashImpactPacket> {
    private byte hitType;
    private int entityId;

    public DashImpactPacket() {
    }

    public DashImpactPacket(EntityPlayer player, RayTraceResult result) {
        byte by = this.hitType = result != null ? (byte)result.field_72313_a.ordinal() : (byte)0;
        if (this.hitType == RayTraceResult.Type.ENTITY.ordinal()) {
            this.entityId = result.field_72308_g.func_145782_y();
        }
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.hitType = buffer.readByte();
        if (this.hitType == RayTraceResult.Type.ENTITY.ordinal()) {
            this.entityId = buffer.readInt();
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte((int)this.hitType);
        if (this.hitType == RayTraceResult.Type.ENTITY.ordinal()) {
            buffer.writeInt(this.entityId);
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        Dash dash = (Dash)DSSPlayerInfo.get(player).getActiveSkill(SkillBase.dash);
        if (dash != null && dash.isActive()) {
            RayTraceResult result = null;
            if (this.hitType == RayTraceResult.Type.ENTITY.ordinal()) {
                Entity entityHit = player.func_130014_f_().func_73045_a(this.entityId);
                if (entityHit != null) {
                    result = new RayTraceResult(entityHit);
                } else {
                    DynamicSwordSkills.logger.warn("Could not retrieve valid entity for MovingObjectPosition while handling Dash Packet!");
                }
            }
            dash.onImpact(player.func_130014_f_(), player, result);
        }
    }
}

