/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.entity.DirtyEntityAccessor;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorBreak
extends SkillActive {
    private int activeTimer = 0;
    private int charge = 0;
    private boolean requiresReset;

    public ArmorBreak(String name) {
        super(name);
    }

    private ArmorBreak(ArmorBreak skill) {
        super(skill);
    }

    @Override
    public ArmorBreak newInstance() {
        return new ArmorBreak(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getChargeDisplay(this.getChargeTime(player)));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    protected boolean allowUserActivation() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private int getChargeTime(EntityPlayer player) {
        return 20 - this.level;
    }

    public boolean isCharging(EntityPlayer player) {
        ILockOnTarget target = DSSPlayerInfo.get(player).getTargetingSkill();
        return this.charge > 0 && target != null && target.isLockedOn();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_184614_ca());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        boolean bl = this.requiresReset = key == mc.field_71474_y.field_74312_F;
        if (this.requiresReset || key == DSSKeyHandler.keys[2]) {
            this.charge = this.getChargeTime(player);
            if (this.requiresReset) {
                KeyBinding.func_74510_a((int)mc.field_71474_y.field_74312_F.func_151463_i(), (boolean)true);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isKeyPressed() {
        return DSSKeyHandler.keys[2].func_151470_d() || Config.allowVanillaControls() && Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
    }

    @Override
    protected boolean sendClientUpdate() {
        return true;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 1;
        if (world.field_72995_K) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        } else {
            ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
            if (skill != null && skill.isLockedOn() && TargetUtils.canReachTarget(player, skill.getCurrentTarget())) {
                player.func_71059_n(skill.getCurrentTarget());
            }
        }
        return false;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.charge = 0;
        DSSPlayerInfo.get((EntityPlayer)player).armSwing = 0.0f;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging(player)) {
            if (this.isKeyPressed() && PlayerUtils.isWeapon(player.func_184614_ca())) {
                if (!player.field_82175_bq) {
                    int maxCharge = this.getChargeTime(player);
                    if (this.charge < maxCharge - 1) {
                        DSSPlayerInfo.get((EntityPlayer)player).armSwing = 0.25f + 0.75f * ((float)(maxCharge - this.charge) / (float)maxCharge);
                    }
                    --this.charge;
                }
                if (this.charge == 0) {
                    SwordBasic skill;
                    DSSPlayerInfo.get(player).setAttackTime(4);
                    if (this.requiresReset) {
                        KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151463_i(), (boolean)false);
                    }
                    if ((skill = (SwordBasic)DSSPlayerInfo.get(player).getPlayerSkill(swordBasic)) != null && skill.onAttack(player)) {
                        PacketDispatcher.sendToServer(new ActivateSkillPacket(this, true));
                    } else {
                        player.func_184609_a(EnumHand.MAIN_HAND);
                    }
                }
            } else {
                DSSPlayerInfo.get((EntityPlayer)player).armSwing = 0.0f;
                this.charge = 0;
            }
        } else {
            DSSPlayerInfo.get((EntityPlayer)player).armSwing = 0.0f;
        }
        if (this.isActive()) {
            this.activeTimer = 0;
        }
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        this.activeTimer = 0;
        PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.ARMOR_BREAK, SoundCategory.PLAYERS, 0.4f, 0.5f);
        DirtyEntityAccessor.damageEntity(event.getEntityLiving(), DamageUtils.causeArmorBreakDamage((Entity)player), event.getAmount());
        event.setAmount(0.0f);
    }
}

