/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.server.EndComboPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BackSlice
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int dodgeTimer = 0;
    private SkillActive targetingSkill;

    public BackSlice(String name) {
        super(name);
    }

    private BackSlice(BackSlice skill) {
        super(skill);
    }

    @Override
    public BackSlice newInstance() {
        return new BackSlice(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(new TextComponentTranslation(this.getInfoString("info", 1), new Object[]{360 - 2 * this.getAttackAngle()}).func_150260_c());
        String chance = String.format("%.2f", Float.valueOf(BackSlice.getDisarmorChance(ItemStack.field_190927_a, player.func_184614_ca(), this.level)));
        desc.add(new TextComponentTranslation(this.getInfoString("info", 2), new Object[]{chance}).func_150260_c());
        desc.add(this.getDamageDisplay(this.level * 10, true) + "%");
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    private int getActiveTime() {
        return 15 + this.level;
    }

    private int getAttackAngle() {
        return 160 - this.level * 10;
    }

    private int getDodgeTime() {
        return 10 - this.level;
    }

    public static float getDisarmorChance(ItemStack armorStack, ItemStack weapon, int level) {
        float chance = (float)level * 0.05f;
        if (armorStack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)armorStack.func_77973_b();
            int i = armor.func_82812_d().func_78044_b(armor.field_77881_a);
            chance += (float)(5 - i) * 0.05f;
            i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)armorStack);
            if (i > 0) {
                chance -= (float)i * 0.05f;
            }
        }
        if (!weapon.func_190926_b()) {
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)weapon);
            if (i > 0) {
                chance += (float)i * 0.05f;
            }
        } else {
            chance -= 1.0f;
        }
        return chance;
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.1f * (float)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isSwordOrProvider(player.func_184614_ca(), this) && DSSPlayerInfo.get(player).isSkillActive(swordBasic);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        if (this.isActive()) {
            return key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74312_F;
        }
        return key == mc.field_71474_y.field_74351_w || key == DSSKeyHandler.keys[3] || key == DSSKeyHandler.keys[4] || Config.allowVanillaControls() && (key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (this.keyPressed != null && this.keyPressed.func_151470_d() && key == mc.field_71474_y.field_74351_w) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.field_71474_y.field_74351_w) {
                this.keyPressed = key;
            }
        } else if (this.isActive() && (key == mc.field_71474_y.field_74312_F || key == DSSKeyHandler.keys[2])) {
            Entity target = DSSPlayerInfo.get(player).getTargetingSkill().getCurrentTarget();
            if (target != null && TargetUtils.canReachTarget(player, target)) {
                mc.field_71442_b.func_78764_a((EntityPlayer)mc.field_71439_g, target);
            } else {
                player.func_184821_cY();
                PlayerUtils.playRandomizedSound(player, ModSounds.SWORD_MISS, SoundCategory.PLAYERS, 0.4f, 0.5f);
                ICombo combo = DSSPlayerInfo.get(player).getComboSkill();
                if (combo.isComboInProgress()) {
                    PacketDispatcher.sendToServer(new EndComboPacket((SkillBase)((Object)combo)));
                }
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            DSSCombatEvents.setPlayerAttackTime((EntityPlayer)mc.field_71439_g);
        }
        return false;
    }

    @Override
    public boolean onActivated(World world, EntityPlayer player) {
        this.dodgeTimer = this.getActiveTime();
        this.targetingSkill = DSSPlayerInfo.get(player).getActiveSkill(swordBasic);
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.dodgeTimer = 0;
        this.targetingSkill = null;
        if (world.field_72995_K) {
            this.keyPressed = null;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
        } else if (player.func_130014_f_().field_72995_K && this.ticksTilFail > 0 && --this.ticksTilFail == 0) {
            this.keyPressed = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.dodgeTimer > this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (player.field_70122_E) {
            double speed;
            if (this.targetingSkill != null && this.targetingSkill.isActive()) {
                this.targetingSkill.onRenderTick(player, partialTickTime);
            }
            if ((speed = 1.0 + 10.0 * (player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e() - (double)0.1f)) > 1.0) {
                speed = 1.0;
            }
            double d = 0.15 * speed * speed;
            if (player.func_70090_H() || player.func_180799_ab()) {
                d *= 0.15;
            }
            Vec3d vec3 = player.func_70040_Z();
            if (this.keyPressed == DSSKeyHandler.keys[4] || this.keyPressed == Minecraft.func_71410_x().field_71474_y.field_74366_z) {
                player.func_70024_g(-vec3.field_72449_c * d, 0.0, vec3.field_72450_a * d);
            } else {
                player.func_70024_g(vec3.field_72449_c * d, 0.0, -vec3.field_72450_a * d);
            }
            player.func_70024_g(vec3.field_72450_a * d * 1.15, 0.0, vec3.field_72449_c * d * 1.15);
        }
        return false;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        ILockOnTarget targeting = DSSPlayerInfo.get(player).getTargetingSkill();
        return this.dodgeTimer > this.getDodgeTime() && targeting != null && targeting.getCurrentTarget() == source.func_76346_g();
    }

    @Override
    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        ILockOnTarget targeting;
        if (this.isActive() && this.dodgeTimer <= this.getActiveTime() - 5 && (targeting = DSSPlayerInfo.get(player).getTargetingSkill()) != null && targeting.getCurrentTarget() == entity && !TargetUtils.isTargetInFrontOf((Entity)entity, (Entity)player, this.getAttackAngle())) {
            ItemStack armor;
            amount *= 1.0f + (float)this.level * 0.1f;
            PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.MORTAL_DRAW, SoundCategory.PLAYERS, 0.4f, 0.5f);
            if ((Config.canDisarmorPlayers() || !(entity instanceof EntityPlayer)) && !(armor = entity.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && player.func_130014_f_().field_73012_v.nextFloat() < BackSlice.getDisarmorChance(armor, player.func_184614_ca(), this.level)) {
                PlayerUtils.spawnItemWithRandom(entity.func_130014_f_(), armor, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                entity.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
            }
        }
        this.deactivate(player);
        return amount;
    }
}

