/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.entity.DirtyEntityAccessor;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.bidirectional.AttackTimePacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EndingBlow
extends SkillActive {
    private int activeTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    @SideOnly(value=Side.CLIENT)
    private int keyPressed;
    @SideOnly(value=Side.CLIENT)
    private long lastActivationTime;
    private int lastNumHits;
    private EntityLivingBase entityHit;
    private int xp;

    public EndingBlow(String name) {
        super(name);
    }

    private EndingBlow(EndingBlow skill) {
        super(skill);
    }

    @Override
    public EndingBlow newInstance() {
        return new EndingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.level * 20, true) + "%");
        desc.add(this.getDurationDisplay(this.getDuration(), true));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - (float)this.level * 0.1f;
    }

    public int getDuration() {
        return 45 - this.level * 5;
    }

    @SideOnly(value=Side.CLIENT)
    public long getLastActivationTime() {
        return this.lastActivationTime;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        if (!this.isActive() && super.canUse(player) && PlayerUtils.isWeapon(player.func_184614_ca())) {
            ICombo combo = DSSPlayerInfo.get(player).getComboSkill();
            ILockOnTarget lock = DSSPlayerInfo.get(player).getTargetingSkill();
            if (combo != null && combo.isComboInProgress() && lock != null && lock.getCurrentTarget() == combo.getCombo().getLastEntityHit()) {
                if (this.lastNumHits > 0) {
                    return combo.getCombo().getConsecutiveHits() > 1 && combo.getCombo().getNumHits() > this.lastNumHits + 2;
                }
                return combo.getCombo().getConsecutiveHits() > 1;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && this.keyPressed > 1 && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == mc.field_71474_y.field_74351_w || key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.field_71474_y.field_74351_w) {
            if (this.ticksTilFail == 0) {
                this.ticksTilFail = 6;
            }
            ++this.keyPressed;
        } else if (this.canExecute(player)) {
            this.ticksTilFail = 0;
            this.keyPressed = 0;
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 3;
        ICombo skill = DSSPlayerInfo.get(player).getComboSkill();
        if (skill.getCombo() != null) {
            this.lastNumHits = skill.getCombo().getNumHits();
        }
        if (world.field_72995_K) {
            DSSClientEvents.performComboAttack(Minecraft.func_71410_x(), DSSPlayerInfo.get(player).getTargetingSkill());
            this.lastActivationTime = Minecraft.func_71386_F();
            this.ticksTilFail = 0;
            this.keyPressed = 0;
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.entityHit = null;
        this.xp = 0;
        if (world.field_72995_K) {
            this.keyPressed = 0;
            this.ticksTilFail = 0;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
            if (this.ticksTilFail == 0) {
                this.keyPressed = 0;
            }
        }
        if (this.lastNumHits > 0) {
            ICombo skill;
            if (this.entityHit != null && this.xp > 0) {
                this.updateEntityState(player);
            }
            if ((skill = DSSPlayerInfo.get(player).getComboSkill()) == null || !skill.isComboInProgress()) {
                this.lastNumHits = 0;
            }
        }
        if (this.isActive()) {
            --this.activeTimer;
            if (this.activeTimer == 0 && !player.func_130014_f_().field_72995_K && !player.field_71075_bZ.field_75098_d) {
                DSSPlayerInfo skills = DSSPlayerInfo.get(player);
                skills.setAttackTime(this.getDuration() * 2);
                PacketDispatcher.sendTo(new AttackTimePacket(skills.getAttackTime()), (EntityPlayerMP)player);
            }
        }
    }

    private void updateEntityState(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            if (this.entityHit.func_110143_aJ() <= 0.0f) {
                if (this.entityHit instanceof EntityLiving) {
                    DirtyEntityAccessor.setLivingXp((EntityLiving)this.entityHit, this.xp, true);
                } else {
                    PlayerUtils.spawnXPOrbsWithRandom(player.func_130014_f_(), player.func_130014_f_().field_73012_v, this.entityHit.func_180425_c(), this.xp);
                }
            } else {
                PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.HURT_FLESH, SoundCategory.PLAYERS, 0.3f, 0.8f);
                if (!player.func_130014_f_().field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    DSSPlayerInfo skills = DSSPlayerInfo.get(player);
                    skills.setAttackTime(this.getDuration());
                    PacketDispatcher.sendTo(new AttackTimePacket(skills.getAttackTime()), (EntityPlayerMP)player);
                }
            }
        }
        this.entityHit = null;
        this.xp = 0;
    }

    @Override
    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        this.activeTimer = 0;
        ICombo combo = DSSPlayerInfo.get(player).getComboSkill();
        ILockOnTarget lock = DSSPlayerInfo.get(player).getTargetingSkill();
        if (combo != null && combo.isComboInProgress() && lock != null && lock.getCurrentTarget() == combo.getCombo().getLastEntityHit()) {
            amount *= 1.0f + (float)this.level * 0.2f;
            PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.MORTAL_DRAW, SoundCategory.PLAYERS, 0.4f, 0.5f);
            this.entityHit = entity;
            this.xp = this.level + 1 + player.func_130014_f_().field_73012_v.nextInt(Math.max(2, MathHelper.func_76123_f((float)entity.func_110143_aJ())));
        }
        return amount;
    }
}

