/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.entity.EntityLeapingBlow;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LeapingBlow
extends SkillActive {
    private boolean isActive = false;

    public LeapingBlow(String name) {
        super(name);
    }

    private LeapingBlow(LeapingBlow skill) {
        super(skill);
    }

    @Override
    public LeapingBlow newInstance() {
        return new LeapingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.level, true));
        desc.add(this.getRangeDisplay(3.0f + 0.5f * (float)this.level));
        desc.add(this.getAreaDisplay(0.5f + 0.25f * (float)this.level));
        desc.add(this.getDurationDisplay(this.getPotionDuration(player), false));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    @Override
    protected boolean autoAddExhaustion() {
        return false;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)this.level + player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    private int getPotionDuration(EntityPlayer player) {
        return 50 + this.level * 10;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isSwordOrProvider(player.func_184614_ca(), this) && !TargetUtils.isInLiquid((Entity)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return !this.isActive() && player.field_70122_E && this.isKeyPressed() && !TargetUtils.isInLiquid((Entity)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == mc.field_71474_y.field_74314_A;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
            KeyBinding.func_74510_a((int)DSSKeyHandler.keys[6].func_151463_i(), (boolean)false);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isKeyPressed() {
        return Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() || DSSKeyHandler.keys[6].func_151470_d();
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.isActive = true;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.isActive = false;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K && this.isActive() && (player.field_70122_E || TargetUtils.isInLiquid((Entity)player))) {
            this.deactivate(player);
        }
    }

    public void onImpact(EntityPlayer player, float distance) {
        SwordBasic swordSkill = (SwordBasic)DSSPlayerInfo.get(player).getPlayerSkill(swordBasic);
        if (this.isActive() && swordSkill != null && swordSkill.isActive() && PlayerUtils.isSwordOrProvider(player.func_184614_ca(), this)) {
            if (player.func_130014_f_().field_72995_K) {
                if (distance < 1.0f) {
                    DSSClientEvents.performComboAttack(Minecraft.func_71410_x(), swordSkill);
                } else {
                    player.func_184609_a(EnumHand.MAIN_HAND);
                }
            } else if (distance >= 1.0f) {
                player.func_71020_j(this.getExhaustion());
                EntityLeapingBlow entity = new EntityLeapingBlow(player.func_130014_f_(), (EntityLivingBase)player).setDamage(this.getDamage(player)).setLevel(this.level);
                entity.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, entity.getVelocity(), 1.0f);
                player.func_130014_f_().func_72838_d((Entity)entity);
                PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.LEAPING_BLOW, SoundCategory.PLAYERS, 0.4f, 0.5f);
            }
        }
        this.onDeactivated(player.func_130014_f_(), player);
    }
}

