/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.entity.DirtyEntityAccessor;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.client.MortalDrawPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MortalDraw
extends SkillActive {
    private static final int DELAY = 30;
    private int attackTimer;
    private int swordSlot;
    private Entity target;

    public MortalDraw(String name) {
        super(name);
    }

    private MortalDraw(MortalDraw skill) {
        super(skill);
    }

    @Override
    public MortalDraw newInstance() {
        return new MortalDraw(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(100, true) + "%");
        desc.add(this.getTimeLimitDisplay(this.getAttackTime() - 30));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.attackTimer > 28;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.attackTimer > 25;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    private int getAttackTime() {
        return this.level + 30 + 2;
    }

    private int getDamageMultiplier() {
        return 100 + 10 * this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        this.swordSlot = -1;
        if (super.canUse(player) && player.func_184614_ca().func_190926_b() && this.attackTimer == 0) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!PlayerUtils.isSwordOrProvider(stack, this)) continue;
                this.swordSlot = i;
                break;
            }
        }
        return this.swordSlot > -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.func_184614_ca().func_190926_b() && (Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() || DSSKeyHandler.keys[6].func_151470_d());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.attackTimer = this.getAttackTime();
        this.target = null;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.attackTimer = 0;
        this.swordSlot = -1;
        this.target = null;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.attackTimer > 0) {
            --this.attackTimer;
            if (this.attackTimer == 30 && !player.func_130014_f_().field_72995_K) {
                this.drawSword(player, null);
                if (!player.func_184614_ca().func_190926_b()) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                }
            }
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (!player.func_130014_f_().field_72995_K && source.func_76346_g() != null) {
            if (this.target == source.func_76346_g()) {
                return true;
            }
            if (this.attackTimer > 30) {
                if (this.drawSword(player, source.func_76346_g())) {
                    PacketDispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                    this.target = source.func_76346_g();
                    return true;
                }
                this.attackTimer = 30;
                this.target = null;
            }
        }
        return false;
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        if (this.attackTimer > 30) {
            this.attackTimer = 30;
            event.setAmount(event.getAmount() * (1.0f + (float)this.getDamageMultiplier() / 100.0f));
            PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.MORTAL_DRAW, SoundCategory.PLAYERS, 0.4f, 0.5f);
        } else {
            this.target = null;
        }
    }

    public boolean drawSword(EntityPlayer player, Entity attacker) {
        boolean flag = false;
        if (this.swordSlot > -1 && this.swordSlot != player.field_71071_by.field_70461_c && player.func_184614_ca().func_190926_b()) {
            ItemStack sword = player.field_71071_by.func_70301_a(this.swordSlot);
            if (!player.func_130014_f_().field_72995_K) {
                player.field_71071_by.func_70299_a(this.swordSlot, ItemStack.field_190927_a);
            }
            player.func_184611_a(EnumHand.MAIN_HAND, sword);
            DirtyEntityAccessor.setItemStackMainHand(player, sword);
            player.func_110140_aT().func_111147_b(sword.func_111283_C(EntityEquipmentSlot.MAINHAND));
            ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
            flag = skill != null && skill.getCurrentTarget() == attacker;
        }
        this.swordSlot = -1;
        return flag;
    }
}

