/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RisingCut
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int activeTimer;
    private Entity entityHit;

    public RisingCut(String name) {
        super(name);
    }

    private RisingCut(RisingCut skill) {
        super(skill);
    }

    @Override
    public RisingCut newInstance() {
        return new RisingCut(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getRangeDisplay(2 + this.level));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - (float)this.level * 0.2f;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && !player.func_184587_cr() && PlayerUtils.isSwordOrProvider(player.func_184614_ca(), this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && player.field_70181_x > 0.0 && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == mc.field_71474_y.field_74314_A || key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.field_71474_y.field_74314_A) {
            if (!this.isActive() && !player.func_184587_cr() && player.func_70093_af()) {
                this.ticksTilFail = 3;
                return true;
            }
        } else if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            DSSClientEvents.performComboAttack(mc, DSSPlayerInfo.get(player).getTargetingSkill());
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 5 + this.level;
        this.entityHit = null;
        player.field_70181_x += 0.3 + 0.115 * (double)this.level;
        DSSPlayerInfo.get((EntityPlayer)player).reduceFallAmount += (float)this.level;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
        if (this.isActive()) {
            --this.activeTimer;
            if (this.entityHit != null) {
                if (!this.entityHit.field_70128_L) {
                    double addY = 0.3 + 0.125 * (double)this.level;
                    double resist = 1.0;
                    if (this.entityHit instanceof EntityLivingBase) {
                        resist = 1.0 - ((EntityLivingBase)this.entityHit).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                    }
                    this.entityHit.func_70024_g(0.0, addY * resist, 0.0);
                }
                this.entityHit = null;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        player.field_70733_aJ = 0.5f;
        return false;
    }

    @Override
    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        boolean flag = !(entity instanceof EntityPlayer) || !PlayerUtils.isBlocking((EntityPlayer)entity);
        this.entityHit = flag ? entity : null;
        return amount;
    }
}

