/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncSkillPacket;
import dynamicswordskills.skills.ArmorBreak;
import dynamicswordskills.skills.BackSlice;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.Dodge;
import dynamicswordskills.skills.EndingBlow;
import dynamicswordskills.skills.LeapingBlow;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.Parry;
import dynamicswordskills.skills.RisingCut;
import dynamicswordskills.skills.SpinAttack;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.skills.SwordBeam;
import dynamicswordskills.skills.SwordBreak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SkillBase {
    public static final byte MAX_LEVEL = 5;
    private static byte skillIndex = 0;
    private static final Map<Byte, SkillBase> skillsMap = new HashMap<Byte, SkillBase>();
    private static final List<String> skillNames = new ArrayList<String>();
    public static final SkillBase swordBasic = new SwordBasic("swordbasic").addDescriptions(1);
    public static final SkillBase armorBreak = new ArmorBreak("armorbreak").addDescriptions(1);
    public static final SkillBase dodge = new Dodge("dodge").addDescriptions(1);
    public static final SkillBase leapingBlow = new LeapingBlow("leapingblow").addDescriptions(1);
    public static final SkillBase parry = new Parry("parry").addDescriptions(1);
    public static final SkillBase dash = new Dash("dash").addDescriptions(1);
    public static final SkillBase spinAttack = new SpinAttack("spinattack").addDescriptions(1);
    public static final SkillBase superSpinAttack = new SpinAttack("superspinattack").addDescriptions(1);
    public static final SkillBase mortalDraw = new MortalDraw("mortaldraw").addDescriptions(1);
    public static final SkillBase swordBreak = new SwordBreak("swordbreak").addDescriptions(1);
    public static final SkillBase risingCut = new RisingCut("risingcut").addDescriptions(1);
    public static final SkillBase endingBlow = new EndingBlow("endingblow").addDescriptions(1);
    public static final SkillBase backSlice = new BackSlice("backslice").addDescriptions(1);
    public static final SkillBase swordBeam = new SwordBeam("swordbeam").addDescriptions(1);
    private final String unlocalizedName;
    private final byte id;
    protected byte level = 0;
    private final List<String> tooltip = new ArrayList<String>();

    protected SkillBase(String name, boolean register) {
        this.unlocalizedName = name;
        byte by = skillIndex;
        skillIndex = (byte)(by + 1);
        this.id = by;
        if (register) {
            if (skillsMap.containsKey(this.id)) {
                DynamicSwordSkills.logger.warn("CONFLICT @ skill " + this.id + " id already occupied by " + SkillBase.skillsMap.get((Object)Byte.valueOf((byte)this.id)).unlocalizedName + " while adding " + name);
            }
            skillsMap.put(this.id, this);
            skillNames.add(this.unlocalizedName);
        }
    }

    protected SkillBase(SkillBase skill) {
        this.unlocalizedName = skill.unlocalizedName;
        this.id = skill.id;
        this.tooltip.addAll(skill.tooltip);
    }

    public static final boolean doesSkillExist(int id) {
        return id >= 0 && id <= 127 && skillsMap.containsKey((byte)id);
    }

    public static final SkillBase getNewSkillInstance(byte id) {
        return skillsMap.containsKey(id) ? skillsMap.get(id).newInstance() : null;
    }

    public static final SkillBase getSkill(int id) {
        return SkillBase.doesSkillExist(id) ? skillsMap.get((byte)id) : null;
    }

    public static final Collection<SkillBase> getSkills() {
        return Collections.unmodifiableCollection(skillsMap.values());
    }

    public static final int getNumSkills() {
        return skillsMap.size();
    }

    public static final String[] getSkillNames() {
        return skillNames.toArray(new String[skillNames.size()]);
    }

    public static final SkillBase getSkillByName(String name) {
        for (SkillBase skill : SkillBase.getSkills()) {
            if (!name.equals(skill.getUnlocalizedName())) continue;
            return skill;
        }
        return null;
    }

    public static final SkillBase getSkillFromItem(ItemStack stack, ISkillProvider item) {
        return SkillBase.createLeveledSkill(item.getSkillId(stack), item.getSkillLevel(stack));
    }

    public static final SkillBase createLeveledSkill(int id, byte level) {
        if (SkillBase.doesSkillExist(id) && level > 0) {
            SkillBase skill = SkillBase.getNewSkillInstance((byte)id);
            byte by = level > skill.getMaxLevel() ? skill.getMaxLevel() : level;
            skill.level = by;
            return skill;
        }
        return null;
    }

    public int hashCode() {
        return 31 * (31 + this.id) + this.level;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SkillBase skill = (SkillBase)obj;
        return skill.id == this.id && skill.level == this.level;
    }

    public abstract SkillBase newInstance();

    public final String getDisplayName() {
        return new TextComponentTranslation(this.getFullUnlocalizedName() + ".name", new Object[0]).func_150260_c();
    }

    public final String getTranslationString() {
        return this.getFullUnlocalizedName() + ".name";
    }

    public final String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public final String getFullUnlocalizedName() {
        return "skill.dss." + this.unlocalizedName;
    }

    public String getIconTexture() {
        return "dynamicswordskills:skillorb_" + this.unlocalizedName;
    }

    public final byte getId() {
        return this.id;
    }

    public final byte getLevel() {
        return this.level;
    }

    public byte getMaxLevel() {
        return 5;
    }

    protected final String getInfoString(String label, int n) {
        return this.getFullUnlocalizedName() + ".desc." + label + (n < 0 ? "" : "." + n);
    }

    protected final SkillBase addDescription(String string) {
        this.tooltip.add(string);
        return this;
    }

    protected final SkillBase addDescription(List<String> list) {
        for (String s : list) {
            this.tooltip.add(s);
        }
        return this;
    }

    protected final SkillBase addDescriptions(int n) {
        for (int i = 1; i <= n; ++i) {
            this.tooltip.add(this.getInfoString("tooltip", i));
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getTranslatedTooltip(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip.size());
        for (String s : this.tooltip) {
            desc.add(new TextComponentTranslation(s, new Object[0]).func_150260_c());
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            this.addInformation(desc, player);
        }
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getDescription() {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip.size());
        for (String s : this.tooltip) {
            desc.add(new TextComponentTranslation(s, new Object[0]).func_150260_c());
        }
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getDescription(EntityPlayer player) {
        List<String> desc = this.getDescription();
        this.addInformation(desc, player);
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
    }

    public String getActivationDisplay() {
        return new TextComponentTranslation(this.getFullUnlocalizedName() + ".desc.activate", new Object[0]).func_150260_c();
    }

    public String getAreaDisplay(double area) {
        return new TextComponentTranslation("skill.dss.desc.area", new Object[]{String.format("%.1f", area)}).func_150260_c();
    }

    public String getChargeDisplay(int chargeTime) {
        return new TextComponentTranslation("skill.dss.desc.charge", new Object[]{chargeTime}).func_150260_c();
    }

    public String getDamageDisplay(float damage, boolean displayPlus) {
        return new TextComponentTranslation("skill.dss.desc.damage", new Object[]{displayPlus ? "+" : "", String.format("%.1f", Float.valueOf(damage))}).func_150260_c();
    }

    public String getDamageDisplay(int damage, boolean displayPlus) {
        return new TextComponentTranslation("skill.dss.desc.damage", new Object[]{displayPlus ? "+" : "", damage}).func_150260_c();
    }

    public String getDurationDisplay(int duration, boolean inTicks) {
        String time = inTicks ? new TextComponentTranslation("skill.dss.ticks", new Object[0]).func_150260_c() : new TextComponentTranslation("skill.dss.seconds", new Object[0]).func_150260_c();
        return new TextComponentTranslation("skill.dss.desc.duration", new Object[]{inTicks ? duration : duration / 20, time}).func_150260_c();
    }

    public String getExhaustionDisplay(float exhaustion) {
        return new TextComponentTranslation("skill.dss.desc.exhaustion", new Object[]{String.format("%.2f", Float.valueOf(exhaustion))}).func_150260_c();
    }

    public String getFullDescription() {
        return new TextComponentTranslation(this.getFullUnlocalizedName() + ".desc.full", new Object[0]).func_150260_c();
    }

    public String getLevelDisplay(boolean simpleMax) {
        if (simpleMax && this.level == this.getMaxLevel()) {
            return new TextComponentTranslation("skill.dss.level.max", new Object[0]).func_150260_c();
        }
        return new TextComponentTranslation("skill.dss.desc.level", new Object[]{this.level, this.getMaxLevel()}).func_150260_c();
    }

    public String getRangeDisplay(double range) {
        return new TextComponentTranslation("skill.dss.desc.range", new Object[]{String.format("%.1f", range)}).func_150260_c();
    }

    public String getTimeLimitDisplay(int time) {
        return new TextComponentTranslation("skill.dss.desc.time", new Object[]{time}).func_150260_c();
    }

    protected boolean canIncreaseLevel(EntityPlayer player, int targetLevel) {
        return this.level + 1 == targetLevel && targetLevel <= this.getMaxLevel();
    }

    protected abstract void levelUp(EntityPlayer var1);

    public void validateSkill(EntityPlayer player) {
        this.levelUp(player);
    }

    public final boolean grantSkill(EntityPlayer player) {
        return this.grantSkill(player, this.level + 1);
    }

    public final boolean grantSkill(EntityPlayer player, int targetLevel) {
        if (targetLevel <= this.level || targetLevel > this.getMaxLevel()) {
            return false;
        }
        byte oldLevel = this.level;
        while (this.level < targetLevel && this.canIncreaseLevel(player, this.level + 1)) {
            this.level = (byte)(this.level + 1);
            this.levelUp(player);
        }
        if (!player.func_130014_f_().field_72995_K && oldLevel < this.level) {
            PacketDispatcher.sendTo(new SyncSkillPacket(this), (EntityPlayerMP)player);
        }
        return oldLevel < this.level;
    }

    public void onUpdate(EntityPlayer player) {
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract SkillBase loadFromNBT(NBTTagCompound var1);
}

