/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.network.server.RefreshSpinPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpinAttack
extends SkillActive {
    private int charge;
    private float currentSpin;
    private float arc;
    private int refreshed;
    @SideOnly(value=Side.CLIENT)
    private boolean clockwise;
    @SideOnly(value=Side.CLIENT)
    private boolean wasKeyPressed;
    @SideOnly(value=Side.CLIENT)
    private List<EntityLivingBase> targets;
    private boolean isFlaming;
    private int superLevel;

    public SpinAttack(String name) {
        super(name);
    }

    private SpinAttack(SpinAttack skill) {
        super(skill);
    }

    @Override
    public SpinAttack newInstance() {
        return new SpinAttack(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        byte temp = this.level;
        if (!this.isActive()) {
            this.superLevel = this.checkHealth(player) ? (int)DSSPlayerInfo.get(player).getSkillLevel(superSpinAttack) : 0;
            this.level = DSSPlayerInfo.get(player).getSkillLevel(spinAttack);
        }
        desc.add(this.getChargeDisplay(this.getChargeTime()));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(new TextComponentTranslation(this.getInfoString("info", 1).replace("super", ""), new Object[]{this.superLevel + 1}).func_150260_c());
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
        this.level = temp;
    }

    @Override
    public boolean isActive() {
        return this.arc > 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive() && !this.isCharging();
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    private int getChargeTime() {
        return 20 - this.level * 2;
    }

    private boolean isCharging() {
        return this.charge > 0;
    }

    private boolean canRefresh() {
        return this.refreshed < this.superLevel + 1 && this.arc == 360.0f * (float)this.refreshed;
    }

    private float getRange() {
        return 3.0f + (float)(this.superLevel + this.level) * 0.5f;
    }

    private float getSpinSpeed() {
        return 70 + 3 * (this.superLevel + this.level);
    }

    private boolean checkHealth(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || PlayerUtils.getHealthMissing(player) <= Config.getHealthAllowance(this.level);
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_184614_ca());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return super.canUse(player) && this.checkActiveHand(player) && PlayerUtils.isWeapon(player.func_184614_ca());
    }

    private boolean checkActiveHand(EntityPlayer player) {
        return !player.func_184587_cr() || player.func_184585_cz();
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return DSSKeyHandler.keys[3].func_151470_d() || DSSKeyHandler.keys[4].func_151470_d() || Config.allowVanillaControls() && Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d() && Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return Config.allowVanillaControls() && (key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z) || key == DSSKeyHandler.keys[3] || key == DSSKeyHandler.keys[4];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.field_71474_y.field_74312_F || key == DSSKeyHandler.keys[2]) {
            if (this.isActive() && this.canRefresh() && this.canExecute(player)) {
                PacketDispatcher.sendToServer(new RefreshSpinPacket());
                this.arc += 360.0f;
                return true;
            }
        } else if (!this.isCharging()) {
            if (this.wasKeyPressed) {
                this.wasKeyPressed = false;
            } else {
                this.clockwise = key == DSSKeyHandler.keys[4] || key == mc.field_71474_y.field_74366_z;
                this.wasKeyPressed = true;
            }
            if (this.isKeyPressed()) {
                this.wasKeyPressed = false;
                this.charge = this.getChargeTime();
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.currentSpin = 0.0f;
        this.arc = 360.0f;
        this.refreshed = 0;
        this.superLevel = this.checkHealth(player) ? (int)DSSPlayerInfo.get(player).getSkillLevel(superSpinAttack) : 0;
        boolean bl = this.isFlaming = EnchantmentHelper.func_90036_a((EntityLivingBase)player) > 0;
        if (player.func_184587_cr()) {
            player.func_184597_cx();
            if (world.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
                KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
            }
        }
        this.startSpin(world, player);
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.charge = 0;
        this.currentSpin = 0.0f;
        this.arc = 0.0f;
        DSSPlayerInfo.get((EntityPlayer)player).armSwing = 0.0f;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging()) {
            if (PlayerUtils.isWeapon(player.func_184614_ca()) && player.func_130014_f_().field_72995_K && this.isKeyPressed()) {
                --this.charge;
                int maxCharge = this.getChargeTime();
                if (this.charge < maxCharge) {
                    DSSPlayerInfo.get((EntityPlayer)player).armSwing = 1.0f - 0.5f * ((float)(maxCharge - this.charge) / (float)maxCharge);
                }
                if (this.charge == 0 && this.canExecute(player)) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                }
            } else {
                this.charge = 0;
                DSSPlayerInfo.get((EntityPlayer)player).armSwing = 0.0f;
            }
        } else if (this.isActive()) {
            this.incrementSpin(player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (PlayerUtils.isWeapon(player.func_184614_ca())) {
            List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, (int)(this.getRange() + 0.5f), 1.0);
            for (EntityLivingBase target : list) {
                if (this.targets == null || !this.targets.contains(target)) continue;
                Minecraft.func_71410_x().field_71442_b.func_78764_a(player, (Entity)target);
                this.targets.remove(target);
            }
            this.spawnParticles(player);
            DSSPlayerInfo.get((EntityPlayer)player).armSwing = 0.5f;
            player.func_70082_c(this.clockwise ? this.getSpinSpeed() : -this.getSpinSpeed(), 0.0f);
        }
        return true;
    }

    private void startSpin(World world, EntityPlayer player) {
        ++this.refreshed;
        if (world.field_72995_K) {
            this.targets = world.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_72321_a((double)this.getRange(), 0.0, (double)this.getRange()));
            if (this.targets.contains(player)) {
                this.targets.remove(player);
            }
        } else {
            PlayerUtils.playRandomizedSound(player, ModSounds.SPIN_ATTACK, SoundCategory.PLAYERS, 0.4f, 0.5f);
            if (this.refreshed > 1) {
                player.func_71020_j(this.getExhaustion());
            }
        }
    }

    private void incrementSpin(EntityPlayer player) {
        this.currentSpin = (float)((double)this.currentSpin + (double)this.getSpinSpeed() * 0.24);
        if (this.currentSpin >= this.arc) {
            this.deactivate(player);
        } else if (this.currentSpin > 360.0f * (float)this.refreshed) {
            this.startSpin(player.func_130014_f_(), player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EntityPlayer player) {
        EnumParticleTypes particle = this.isFlaming ? EnumParticleTypes.FLAME : (this.superLevel > 0 ? EnumParticleTypes.CRIT_MAGIC : EnumParticleTypes.CRIT);
        Vec3d vec3 = player.func_70040_Z();
        double posX = player.field_70165_t + vec3.field_72450_a * (double)this.getRange();
        double posY = player.field_70163_u + (double)player.func_70047_e() - 0.1;
        double posZ = player.field_70161_v + vec3.field_72449_c * (double)this.getRange();
        for (int i = 0; i < 2; ++i) {
            player.func_130014_f_().func_175688_a(particle, posX, posY, posZ, vec3.field_72450_a * 0.15, 0.01, vec3.field_72449_c * 0.15, new int[0]);
        }
    }

    public void refreshServerSpin(EntityPlayer player) {
        if (this.canRefresh() && super.canUse(player) && PlayerUtils.isWeapon(player.func_184614_ca())) {
            this.arc += 360.0f;
        }
    }
}

