/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.entity.EntitySwordBeam;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SwordBeam
extends SkillActive {
    private int missTimer;

    public SwordBeam(String name) {
        super(name);
    }

    private SwordBeam(SwordBeam skill) {
        super(skill);
    }

    @Override
    public SwordBeam newInstance() {
        return new SwordBeam(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamageFactor(player), false) + "%");
        desc.add(this.getRangeDisplay(12 + this.level));
        desc.add(new TextComponentTranslation(this.getInfoString("info", 1), new Object[]{String.format("%.1f", Float.valueOf(Config.getHealthAllowance(this.level) / 2.0f))}).func_150260_c());
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean hasAnimation() {
        return false;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private boolean checkHealth(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || PlayerUtils.getHealthMissing(player) <= Config.getHealthAllowance(this.level);
    }

    private int getDamageFactor(EntityPlayer player) {
        return 30 + this.level * 10;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)this.getDamageFactor(player) * 0.01 * player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && this.checkHealth(player) && DSSPlayerInfo.get(player).canAttack() && PlayerUtils.isSwordOrProvider(player.func_184614_ca(), this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && player.func_70093_af() && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == DSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.missTimer = 12 + this.level;
            PlayerUtils.playSoundAtEntity(world, (Entity)player, ModSounds.WHOOSH, SoundCategory.PLAYERS, 0.4f, 0.5f);
            EntitySwordBeam beam = new EntitySwordBeam(world, (EntityLivingBase)player).setLevel(this.level).setDamage(this.getDamage(player));
            beam.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, beam.getVelocity(), 1.0f);
            world.func_72838_d((Entity)beam);
        } else {
            player.func_184609_a(EnumHand.MAIN_HAND);
            DSSPlayerInfo.get(player).setAttackTime(20 - this.level);
        }
        return true;
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.missTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.missTimer > 0) {
            ICombo combo;
            --this.missTimer;
            if (this.missTimer == 0 && !player.func_130014_f_().field_72995_K && (combo = DSSPlayerInfo.get(player).getComboSkill()) != null && combo.isComboInProgress()) {
                combo.getCombo().endCombo(player);
            }
        }
    }

    public void onImpact(EntityPlayer player, boolean hitBlock) {
        this.missTimer = hitBlock && this.missTimer > 0 ? 1 : 0;
    }
}

