/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActivateSkillPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.ref.ModSounds;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SwordBreak
extends SkillActive {
    private int breakTimer;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public SwordBreak(String name) {
        super(name);
    }

    private SwordBreak(SwordBreak skill) {
        super(skill);
    }

    @Override
    public SwordBreak newInstance() {
        return new SwordBreak(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(new TextComponentTranslation(this.getInfoString("info", 1), new Object[]{this.getMaxDamage()}).func_150260_c());
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getUseDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.breakTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private int getActiveTime() {
        return 6 + this.level;
    }

    private int getUseDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxDamage() {
        return (this.level + 1) * 15;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isWeapon(player.func_184614_ca());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canUse(player) && PlayerUtils.isBlocking(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == DSSKeyHandler.keys[5] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74368_y;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (Config.requiresDoubleTap()) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.field_71474_y.field_74368_y) {
                PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.breakTimer = this.getActiveTime();
        this.playMissSound = true;
        if (world.field_72995_K) {
            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
            KeyBinding.func_74510_a((int)DSSKeyHandler.keys[6].func_151463_i(), (boolean)false);
            player.func_184609_a(EnumHand.MAIN_HAND);
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.breakTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.breakTimer <= this.getUseDelay() && this.playMissSound) {
                this.playMissSound = false;
                PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.SWORD_MISS, SoundCategory.PLAYERS, 0.4f, 0.5f);
            }
        } else if (player.func_130014_f_().field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76364_f();
            ItemStack stackToDamage = attacker.func_184614_ca();
            if (this.breakTimer > this.getUseDelay() && !stackToDamage.func_190926_b() && PlayerUtils.isWeapon(player.func_184614_ca())) {
                this.breakTimer = this.getUseDelay();
                PlayerUtils.playSoundAtEntity(player.func_130014_f_(), (Entity)player, ModSounds.SWORD_STRIKE, SoundCategory.PLAYERS, 0.4f, 0.5f);
                this.playMissSound = false;
                if (!player.func_130014_f_().field_72995_K) {
                    int dmg = Math.max(this.getMaxDamage() / 3, player.func_130014_f_().field_73012_v.nextInt(this.getMaxDamage()));
                    stackToDamage.func_77972_a(dmg, attacker);
                    if (stackToDamage.func_190916_E() <= 0) {
                        PlayerUtils.playSoundAtEntity(attacker.func_130014_f_(), (Entity)attacker, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.8f, 0.8f + player.func_130014_f_().field_73012_v.nextFloat() * 0.4f);
                        attacker.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                }
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }
}

