/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.PlaySoundPacket;
import dynamicswordskills.skills.SkillBase;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import swordskillsapi.api.item.IWeapon;
import swordskillsapi.api.item.WeaponRegistry;

public class PlayerUtils {
    public static boolean isBlocking(EntityPlayer player) {
        return player.func_184585_cz();
    }

    public static boolean isSword(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IWeapon) {
            return ((IWeapon)stack.func_77973_b()).isSword(stack);
        }
        return WeaponRegistry.INSTANCE.isSword(stack.func_77973_b());
    }

    public static boolean isWeapon(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IWeapon) {
            return ((IWeapon)stack.func_77973_b()).isWeapon(stack);
        }
        return PlayerUtils.isSword(stack) || WeaponRegistry.INSTANCE.isWeapon(stack.func_77973_b());
    }

    public static boolean isSwordOrProvider(ItemStack stack, SkillBase skill) {
        Item item = stack.func_77973_b();
        return PlayerUtils.isSword(stack) || item instanceof ISkillProvider && ((ISkillProvider)item).getSkillId(stack) == skill.getId();
    }

    public static float getHealthMissing(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 0.0f : player.func_110138_aP() - player.func_110143_aJ();
    }

    public static void sendTranslatedChat(EntityPlayer player, String message, Object ... args) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation(message, args));
    }

    public static void playSound(EntityPlayer player, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (player.func_130014_f_().field_72995_K) {
            PacketDispatcher.sendToServer(new PlaySoundPacket(sound, category, volume, pitch, (Entity)player));
        } else {
            PacketDispatcher.sendTo(new PlaySoundPacket(sound, category, volume, pitch), (EntityPlayerMP)player);
        }
    }

    public static void playRandomizedSound(EntityPlayer player, SoundEvent sound, SoundCategory category, float f, float add) {
        float volume = player.func_130014_f_().field_73012_v.nextFloat() * f + add;
        float pitch = 1.0f / (player.func_130014_f_().field_73012_v.nextFloat() * f + add);
        PlayerUtils.playSound(player, sound, category, volume, pitch);
    }

    public static void playSoundAtEntity(World world, Entity entity, SoundEvent sound, SoundCategory category, float f, float add) {
        float volume = world.field_73012_v.nextFloat() * f + add;
        float pitch = 1.0f / (world.field_73012_v.nextFloat() * f + add);
        world.func_184133_a(null, entity.func_180425_c(), sound, category, volume, pitch);
    }

    public static void spawnItemWithRandom(World world, ItemStack stack, double x, double y, double z) {
        if (!world.field_72995_K && !stack.func_190926_b()) {
            double spawnX = x + (double)world.field_73012_v.nextFloat();
            double spawnY = y + (double)world.field_73012_v.nextFloat();
            double spawnZ = z + (double)world.field_73012_v.nextFloat();
            float f3 = 0.05f;
            EntityItem entityitem = new EntityItem(world, spawnX, spawnY, spawnZ, stack);
            entityitem.field_70159_w = (-0.5 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_70181_x = (4.0 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_70179_y = (-0.5 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void spawnXPOrbsWithRandom(World world, Random rand, BlockPos pos, int xpAmount) {
        if (!world.field_72995_K) {
            while (xpAmount > 0) {
                int xp = xpAmount > 50 ? 50 : EntityXPOrb.func_70527_a((int)xpAmount);
                xpAmount -= xp;
                float spawnX = (float)pos.func_177958_n() + rand.nextFloat();
                float spawnY = (float)pos.func_177956_o() + rand.nextFloat();
                float spawnZ = (float)pos.func_177952_p() + rand.nextFloat();
                EntityXPOrb xpOrb = new EntityXPOrb(world, (double)spawnX, (double)spawnY, (double)spawnZ, xp);
                xpOrb.field_70181_x += (4.0 + rand.nextGaussian()) * (double)0.05f;
                world.func_72838_d((Entity)xpOrb);
            }
        }
    }

    public static void dropHeldItem(EntityLivingBase entity) {
        if (!entity.func_130014_f_().field_72995_K && !entity.func_184614_ca().func_190926_b()) {
            EntityItem drop = new EntityItem(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u - (double)0.3f + (double)entity.func_70047_e(), entity.field_70161_v, entity.func_184614_ca().func_77946_l());
            float f = 0.3f;
            float f1 = entity.func_130014_f_().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            drop.field_70159_w = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70179_y = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70181_x = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f * entity.func_130014_f_().field_73012_v.nextFloat();
            drop.field_70159_w += Math.cos(f1) * (double)f;
            drop.field_70181_x += (double)((entity.func_130014_f_().field_73012_v.nextFloat() - entity.func_130014_f_().field_73012_v.nextFloat()) * 0.1f);
            drop.field_70179_y += Math.sin(f1) * (double)f;
            drop.func_174867_a(40);
            entity.func_130014_f_().func_72838_d((Entity)drop);
            entity.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
    }
}

