/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TargetUtils {
    private static final int MAX_DISTANCE = 256;
    private static final double MAX_DISTANCE_SQ = 65536.0;

    public static double getReachDistanceSq(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 36.0 : 12.0;
    }

    public static boolean canReachTarget(EntityPlayer player, Entity target) {
        return player.func_70685_l(target) && player.func_70068_e(target) < TargetUtils.getReachDistanceSq(player);
    }

    public static RayTraceResult checkForImpact(World world, Entity entity, Entity shooter, double hitBox, boolean flag) {
        double posY = entity.field_70163_u + (double)entity.field_70131_O / 2.0;
        Vec3d vec3 = new Vec3d(entity.field_70165_t, posY, entity.field_70161_v);
        Vec3d vec31 = new Vec3d(entity.field_70165_t + entity.field_70159_w, posY + entity.field_70181_x, entity.field_70161_v + entity.field_70179_y);
        RayTraceResult result = world.func_147447_a(vec3, vec31, false, true, false);
        vec3 = new Vec3d(entity.field_70165_t, posY, entity.field_70161_v);
        vec31 = new Vec3d(entity.field_70165_t + entity.field_70159_w, posY + entity.field_70181_x, entity.field_70161_v + entity.field_70179_y);
        if (result != null) {
            vec31 = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
        }
        Entity target = null;
        List list = world.func_72839_b(entity, entity.func_174813_aQ().func_72321_a(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult result1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == shooter && !flag || (result1 = (axisalignedbb = entity1.func_174813_aQ().func_72321_a(hitBox, hitBox, hitBox)).func_72327_a(vec3, vec31)) == null || !((d1 = vec3.func_72438_d(result1.field_72307_f)) < d0) && d0 != 0.0) continue;
            target = entity1;
            d0 = d1;
        }
        if (target != null) {
            result = new RayTraceResult(target);
        }
        if (result != null && result.field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)result.field_72308_g;
            if (player.field_71075_bZ.field_75102_a || shooter instanceof EntityPlayer && !((EntityPlayer)shooter).func_96122_a(player)) {
                result = null;
            }
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMouseOverEntity(Entity entity) {
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        return result != null && result.field_72308_g == entity;
    }

    @SideOnly(value=Side.CLIENT)
    public static Entity getMouseOverEntity() {
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        return result == null ? null : result.field_72308_g;
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius) {
        return TargetUtils.acquireLookTarget(seeker, distance, radius, false);
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius, boolean closestToSeeker) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        EntityLivingBase currentTarget = null;
        double currentDistance = 65536.0;
        Vec3d vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            AxisAlignedBB bb = new AxisAlignedBB((targetX += vec3.field_72450_a) - radius, (targetY += vec3.field_72448_b) - radius, (targetZ += vec3.field_72449_c) - radius, targetX + radius, targetY + radius, targetZ + radius);
            List list = seeker.func_130014_f_().func_72872_a(EntityLivingBase.class, bb);
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.func_70067_L() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target)) continue;
                double d = closestToSeeker ? target.func_70068_e((Entity)seeker) : target.func_70092_e(targetX, targetY, targetZ);
                double newDistance = d;
                if (!(newDistance < currentDistance)) continue;
                currentTarget = target;
                currentDistance = newDistance;
            }
        }
        return currentTarget;
    }

    public static final List<EntityLivingBase> acquireAllLookTargets(EntityLivingBase seeker, int distance, double radius) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        Vec3d vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            AxisAlignedBB bb = new AxisAlignedBB((targetX += vec3.field_72450_a) - radius, (targetY += vec3.field_72448_b) - radius, (targetZ += vec3.field_72449_c) - radius, targetX + radius, targetY + radius, targetZ + radius);
            List list = seeker.func_130014_f_().func_72872_a(EntityLivingBase.class, bb);
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.func_70067_L() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target) || targets.contains(target)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public static final boolean isTargetInFrontOf(Entity seeker, Entity target, float fov) {
        double dx = target.field_70165_t - seeker.field_70165_t;
        double dz = target.field_70161_v - seeker.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - seeker.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }

    public static final boolean isTargetInSight(EntityLivingBase seeker, Entity target) {
        return TargetUtils.isTargetInSight(seeker.func_70040_Z(), seeker, target);
    }

    private static final boolean isTargetInSight(Vec3d vec3, EntityLivingBase seeker, Entity target) {
        return seeker.func_70685_l(target) && TargetUtils.isTargetInFrontOf((Entity)seeker, target, 60.0f);
    }

    public static boolean isInLiquid(Entity entity) {
        return entity.func_130014_f_().func_180495_p(new BlockPos(entity)).func_185904_a().func_76224_d();
    }

    public static final void knockTargetBack(EntityLivingBase pushedEntity, EntityLivingBase pushingEntity) {
        if (pushedEntity.func_70104_M()) {
            double dx = pushedEntity.field_70165_t - pushingEntity.field_70165_t;
            double dz = pushedEntity.field_70161_v - pushingEntity.field_70161_v;
            while (dx * dx + dz * dz < 1.0E-4) {
                dx = (Math.random() - Math.random()) * 0.01;
                dz = (Math.random() - Math.random()) * 0.01;
            }
            pushedEntity.func_70653_a((Entity)pushingEntity, 0.0f, -dx, -dz);
        }
    }
}

