/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiTabPanel<T extends GuiScreen>
extends Gui {
    private final int tabId;
    protected final T parent;
    protected final FontRenderer fontRenderer;
    protected final Minecraft mc;
    protected ArrayList<GuiButton> buttonList;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private final boolean fullscreen;
    private GuiButton selectedButton;

    public GuiTabPanel(int tabId, T parent, boolean fullscreen) {
        this.tabId = tabId;
        this.parent = parent;
        this.mc = Minecraft.func_71410_x();
        this.fontRenderer = this.mc.field_71466_p;
        this.fullscreen = fullscreen;
        this.buttonList = new ArrayList();
    }

    public GuiTabPanel(int tabId, T parent) {
        this(tabId, parent, false);
    }

    public void initGui(int xPos, int yPos, int width, int height) {
        this.buttonList.clear();
        if (this.isFullscreen()) {
            this.x = 0;
            this.y = 0;
            this.width = ((GuiScreen)this.parent).field_146294_l;
            this.height = ((GuiScreen)this.parent).field_146295_m;
        } else {
            this.x = xPos;
            this.y = yPos;
            this.width = width;
            this.height = height;
        }
    }

    protected boolean isFullscreen() {
        return this.fullscreen;
    }

    public int getTabId() {
        return this.tabId;
    }

    public void tabChanged(int tabIndex) {
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            for (int i = 0; i < this.buttonList.size(); ++i) {
                GuiButton guiButton = this.buttonList.get(i);
                if (!guiButton.func_146116_c(this.mc, mouseX - this.x, mouseY - this.y)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre(this.parent, guiButton, this.buttonList);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.selectedButton = event.getButton();
                event.getButton().func_146113_a(this.mc.func_147118_V());
                this.actionPerformed(event.getButton());
                if (this.parent.equals(this.mc.field_71462_r)) {
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post(this.parent, event.getButton(), this.buttonList));
                }
                return true;
            }
        }
        return false;
    }

    protected void actionPerformed(GuiButton button) {
    }

    public boolean mouseMovedOrUp(int mouseX, int mouseY, int button) {
        if (this.selectedButton != null && button == 0) {
            this.selectedButton.func_146118_a(mouseX - this.x, mouseY - this.y);
            this.selectedButton = null;
        }
        return false;
    }

    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            this.buttonList.get(i).func_191745_a(this.mc, mouseX - this.x, mouseY - this.y, partialTickTime);
        }
    }

    public boolean keyTyped(char c, int keycode) {
        return false;
    }

    public abstract void drawBackgroundLayer(float var1, int var2, int var3);

    public void update() {
    }
}

