/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.inventory;

import javax.annotation.Nonnull;
import moe.plushie.armourers_workshop.utils.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class ModInventory
implements IInventory {
    private static final String TAG_ITEMS = "items";
    private final String name;
    protected final NonNullList<ItemStack> slots;
    private final IInventoryCallback callback;
    private final TileEntity parent;

    public ModInventory(String name, int slotCount) {
        this(name, slotCount, null, null);
    }

    public ModInventory(String name, int slotCount, TileEntity parent) {
        this(name, slotCount, parent, null);
    }

    public ModInventory(String name, int slotCount, IInventoryCallback callback) {
        this(name, slotCount, null, callback);
    }

    public ModInventory(String name, int slotCount, TileEntity parent, IInventoryCallback callback) {
        this.name = name;
        this.slots = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
        this.parent = parent;
        this.callback = callback;
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    public ItemStack func_70301_a(int slotId) {
        return (ItemStack)this.slots.get(slotId);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.slots, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = ItemStackHelper.func_188383_a(this.slots, (int)index);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.slots.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
        if (this.callback != null) {
            this.callback.setInventorySlotContents(this, index, stack);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        if (this.callback != null) {
            this.callback.dirty();
        }
        if (this.parent != null) {
            this.parent.func_70296_d();
        }
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return true;
    }

    public NBTTagCompound saveItemsToNBT(NBTTagCompound compound) {
        NBTHelper.writeStackArrayToNBT(compound, TAG_ITEMS, this.slots);
        return compound;
    }

    public void loadItemsFromNBT(NBTTagCompound compound) {
        this.func_174888_l();
        NBTHelper.readStackArrayFromNBT(compound, TAG_ITEMS, this.slots);
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !player.field_70128_L;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.slots.clear();
    }

    public static interface IInventoryCallback {
        public void setInventorySlotContents(IInventory var1, int var2, @Nonnull ItemStack var3);

        public void dirty();
    }
}

