/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.HashMap;
import java.util.HashSet;
import moe.plushie.armourers_workshop.common.library.global.PlushieUser;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskUserInfo;
import moe.plushie.armourers_workshop.utils.ModLogger;
import org.apache.logging.log4j.Level;

public final class GlobalSkinLibraryUtils {
    private static final HashMap<Integer, PlushieUser> USERS = new HashMap();
    private static final HashSet<Integer> DOWNLOADED_USERS = new HashSet();

    private GlobalSkinLibraryUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlushieUser getUserInfo(final int userId) {
        HashMap<Integer, PlushieUser> hashMap = USERS;
        synchronized (hashMap) {
            if (USERS.containsKey(userId)) {
                return USERS.get(userId);
            }
        }
        if (!DOWNLOADED_USERS.contains(userId)) {
            DOWNLOADED_USERS.add(userId);
            GlobalTaskUserInfo taskUserInfo = new GlobalTaskUserInfo(userId);
            ListenableFutureTask task = taskUserInfo.createTask();
            Futures.addCallback(task, (FutureCallback)new FutureCallback<PlushieUser>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(PlushieUser result) {
                    if (result != null) {
                        HashMap hashMap = USERS;
                        synchronized (hashMap) {
                            USERS.put(userId, result);
                        }
                    } else {
                        ModLogger.log(Level.ERROR, "Failed downloading info for user id: " + userId);
                    }
                }

                public void onFailure(Throwable t) {
                    t.printStackTrace();
                }
            });
            taskUserInfo.runTask(task);
        }
        return null;
    }

    public static int[] getJavaVersion() {
        int[] version = new int[]{6, 0};
        try {
            int javaVersion;
            String java = System.getProperty("java.version");
            String[] javaSplit = java.split("_");
            version[1] = javaVersion = Integer.valueOf(javaSplit[1]).intValue();
            javaSplit = javaSplit[0].split("\\.");
            version[0] = Integer.valueOf(javaSplit[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public static boolean isValidJavaVersion(int[] javaVersion) {
        if (javaVersion[0] < 8) {
            return false;
        }
        return javaVersion[1] >= 101;
    }

    public static boolean isValidJavaVersion() {
        int[] javaVersion = GlobalSkinLibraryUtils.getJavaVersion();
        return !(javaVersion[0] < 8 & javaVersion[1] < 101);
    }
}

