/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.SignatureState;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeCapeBuffer;
import customskinloader.fake.FakeMinecraftProfileTexture;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.fake.itf.IFakeSkinManagerCacheKey;
import customskinloader.loader.MojangAPILoader;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpTextureUtil;
import customskinloader.utils.TextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.SkinManager;

public class FakeSkinManager {
    private static CacheLoader<Object, ?> cacheLoader;
    private static final String KEY = "CustomSkinLoaderInfo";
    private static final String SKULL_KEY = "CSL$IsSkull";

    public static void setSkinCacheDir(File skinCacheDirectory) {
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public static void setSkinCacheDir(Path skinCacheDirectory) {
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory.toFile();
    }

    public static CacheLoader<Object, ?> setCacheLoader(CacheLoader<Object, ?> loader) {
        cacheLoader = loader;
        return cacheLoader;
    }

    public static Property createProperty(Property property) {
        return property == null ? new Property(null, null) : new Property((String)TextureUtil.AuthlibField.PROPERTY_NAME.get(property), (String)TextureUtil.AuthlibField.PROPERTY_VALUE.get(property), (String)TextureUtil.AuthlibField.PROPERTY_SIGNATURE.get(property));
    }

    public static Object loadCache(LoadingCache<?, ?> loadingCache, Object cacheKey, GameProfile profile) throws Exception {
        return cacheLoader.load(FakeCacheKey.wrapCacheKey(cacheKey, profile));
    }

    public static Object[] createThreadDownloadImageData(ImmutableList<Object> list, MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType) {
        Object[] params = list.toArray();
        if (profileTexture instanceof FakeMinecraftProfileTexture && params.length > 1) {
            FakeMinecraftProfileTexture fakeProfileTexture = (FakeMinecraftProfileTexture)profileTexture;
            params[0] = fakeProfileTexture.getCacheFile();
            if (params[params.length - 2] instanceof Boolean) {
                params[params.length - 2] = true;
            }
            params[params.length - 1] = new BaseBuffer((Runnable)params[params.length - 1], textureType, fakeProfileTexture);
        }
        return params;
    }

    public static void loadProfileTextures(Runnable runnable, GameProfile profile) {
        CustomSkinLoader.loadProfileTextures(() -> CustomSkinLoader.loadProfileLazily(profile, p -> {
            profile.getProperties().putAll((Object)KEY, p.toProperties());
            runnable.run();
            return null;
        }));
    }

    public static Object[] loadProfileTextures(ImmutableList<Object> list, Object cacheKey) {
        Object[] params = list.toArray();
        GameProfile profile = FakeCacheKey.unwrapCacheKey(cacheKey);
        if (!profile.getProperties().containsKey((Object)SKULL_KEY)) {
            Supplier supplier = (Supplier)params[0];
            params[0] = () -> FakeSkinManager.lambda$loadProfileTextures$3(profile, cacheKey, (Supplier)supplier);
            params[1] = CustomSkinLoader.THREAD_POOL;
        } else {
            params[1] = Minecraft.func_71410_x();
        }
        return params;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getUserProfile(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        return ModelManager0.fromUserProfile(UserProfile.fromProperties(profile.getProperties().values()));
    }

    public static void loadElytraTexture(SkinManager skinManager, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map, SkinManager.SkinAvailableCallback skinAvailableCallback) {
        for (int i = 2; i < MinecraftProfileTexture.Type.values().length; ++i) {
            MinecraftProfileTexture.Type type = MinecraftProfileTexture.Type.values()[i];
            if (!map.containsKey(type)) continue;
            skinManager.func_152789_a(map.get(type), type, skinAvailableCallback);
        }
    }

    public static void setSkullType(GameProfile profile) {
        profile.getProperties().removeAll((Object)SKULL_KEY);
        profile.getProperties().put((Object)SKULL_KEY, (Object)new Property(SKULL_KEY, "true"));
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        return CustomSkinLoader.loadProfileFromCache(profile);
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(MinecraftSessionService sessionService, GameProfile profile, boolean requireSecure) {
        if (profile.getProperties().containsKey((Object)SKULL_KEY)) {
            profile.getProperties().removeAll((Object)SKULL_KEY);
            return CustomSkinLoader.loadProfileFromCache(profile);
        }
        return FakeSkinManager.getUserProfile(sessionService, profile, requireSecure);
    }

    public static Object loadSkinFromCache(MinecraftSessionService sessionService, Property property) {
        return FakeCacheKey.createMinecraftProfileTextures(FakeSkinManager.loadSkinFromCache(sessionService, FakeCacheKey.unwrapProperty(property), false));
    }

    private static boolean shouldJudgeType(MinecraftProfileTexture texture) {
        return texture != null && "auto".equals(texture.getMetadata("model"));
    }

    private static /* synthetic */ Object lambda$loadProfileTextures$3(GameProfile profile, Object cacheKey, Supplier supplier) {
        return CustomSkinLoader.loadProfileLazily(profile, arg_0 -> FakeSkinManager.lambda$null$2(profile, cacheKey, (Supplier)supplier, arg_0));
    }

    private static /* synthetic */ Object lambda$null$2(GameProfile profile, Object cacheKey, Supplier supplier, UserProfile p) {
        profile.getProperties().putAll((Object)KEY, p.toProperties());
        FakeCacheKey.wrapCacheKey(cacheKey, profile);
        return supplier.get();
    }

    public static class FakeCacheKey {
        public static Object wrapCacheKey(Object cacheKey, GameProfile profile) {
            IFakeSkinManagerCacheKey fakeCacheKey = (IFakeSkinManagerCacheKey)cacheKey;
            if (fakeCacheKey.profile() != null) {
                return cacheKey;
            }
            TextureUtil.AuthlibField.PROPERTY_SIGNATURE.set(fakeCacheKey.packedTextures(), MojangAPILoader.GSON.toJson((Object)profile, GameProfile.class));
            return fakeCacheKey;
        }

        public static GameProfile unwrapCacheKey(Object cacheKey) {
            IFakeSkinManagerCacheKey fakeCacheKey = (IFakeSkinManagerCacheKey)cacheKey;
            if (fakeCacheKey.profile() != null) {
                return fakeCacheKey.profile();
            }
            return FakeCacheKey.unwrapProperty(fakeCacheKey.packedTextures());
        }

        public static GameProfile unwrapProperty(Property property) {
            return (GameProfile)MojangAPILoader.GSON.fromJson((String)TextureUtil.AuthlibField.PROPERTY_SIGNATURE.get(property), GameProfile.class);
        }

        public static Object createMinecraftProfileTextures(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures) {
            return new MinecraftProfileTextures(textures.get(MinecraftProfileTexture.Type.SKIN), textures.get(MinecraftProfileTexture.Type.CAPE), textures.get(MinecraftProfileTexture.Type.ELYTRA), SignatureState.SIGNED);
        }
    }

    private static class BaseBuffer
    implements IImageBuffer {
        private IImageBuffer buffer;
        private final Runnable callback;
        private final FakeMinecraftProfileTexture texture;

        public BaseBuffer(Runnable callback, MinecraftProfileTexture.Type type, FakeMinecraftProfileTexture texture) {
            this.callback = callback;
            this.texture = texture;
            switch (type) {
                case SKIN: {
                    this.buffer = new FakeSkinBuffer();
                    break;
                }
                case CAPE: {
                    this.buffer = new FakeCapeBuffer();
                }
            }
        }

        @Override
        public NativeImage func_195786_a(NativeImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_195786_a(image) : image;
        }

        @Override
        public BufferedImage func_78432_a(BufferedImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_78432_a(image) : image;
        }

        @Override
        public void func_152634_a() {
            if (this.buffer != null) {
                this.buffer.func_152634_a();
                if (FakeSkinManager.shouldJudgeType(this.texture) && this.buffer instanceof FakeSkinBuffer) {
                    String type = ((FakeSkinBuffer)this.buffer).judgeType();
                    this.texture.setModel(type);
                }
            }
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }
}

