/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps;

import java.util.Arrays;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.footsteps.Association;
import org.orecruncher.dsurround.client.footsteps.PendingSound;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.sound.SoundBuilder;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.IOptions;
import org.orecruncher.dsurround.registry.acoustics.ISoundPlayer;
import org.orecruncher.dsurround.registry.sound.SoundRegistry;
import org.orecruncher.lib.TimeUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class SoundPlayer
implements ISoundPlayer {
    protected final Random random = XorShiftRandom.current();
    protected final ObjectArray<PendingSound> pending = new ObjectArray();
    protected final float scale;

    public SoundPlayer() {
        this(1.0f);
    }

    public SoundPlayer(float volumeScale) {
        this.scale = volumeScale;
    }

    public void playAcoustic(@Nonnull Association assoc, @Nonnull EventType event) {
        this.playAcoustic(assoc.getStrikeLocation().getStrikePosition(), assoc.getData(), event, null);
    }

    private void logAcousticPlay(@Nonnull IAcoustic[] acoustics, @Nonnull EventType event) {
        if (ModBase.log().isDebugging()) {
            String txt = Arrays.stream(acoustics).map(IAcoustic::getName).collect(Collectors.joining(","));
            ModBase.log().debug(2, "Playing acoustic %s for event %s", new Object[]{txt, event.toString().toUpperCase()});
        }
    }

    public void playAcoustic(@Nonnull Vec3d location, @Nonnull IAcoustic[] acoustics, @Nonnull EventType event, @Nullable IOptions inputOptions) {
        if (acoustics != null && acoustics.length > 0) {
            this.logAcousticPlay(acoustics, event);
            for (int i = 0; i < acoustics.length; ++i) {
                acoustics[i].playSound(this, location, event, inputOptions);
            }
        }
    }

    @Override
    public void playSound(@Nonnull Vec3d location, @Nonnull SoundEvent sound2, float volume, float pitch, @Nullable IOptions options) {
        if (options != null && options.isDelayedSound()) {
            long delay = TimeUtils.currentTimeMillis() + this.randAB(this.random, options.getDelayMin(), options.getDelayMax());
            this.pending.add((Object)new PendingSound(location, sound2, volume, pitch, delay, options.getDelayMax()));
        } else {
            this.actuallyPlaySound(location, sound2, volume, pitch);
        }
    }

    protected void actuallyPlaySound(@Nonnull Vec3d entity, @Nonnull SoundEvent sound2, float volume, float pitch) {
        try {
            SoundInstance s = SoundBuilder.builder(sound2, SoundRegistry.FOOTSTEPS).setPosition(entity).setVolume(volume * this.scale).setPitch(pitch).build();
            SoundEffectHandler.INSTANCE.playSound(s);
        }
        catch (Throwable t) {
            ModBase.log().error("Unable to play sound", t);
        }
    }

    @Override
    public Random getRNG() {
        return this.random;
    }

    public void think() {
        long time = TimeUtils.currentTimeMillis();
        this.pending.removeIf(sound2 -> {
            if (sound2.getTimeToPlay() <= time) {
                if (!sound2.isLate(time)) {
                    sound2.playSound(this);
                }
                return true;
            }
            return false;
        });
    }

    private long randAB(@Nonnull Random rng, long a, long b) {
        return a >= b ? a : a + (long)rng.nextInt((int)(b + 1L));
    }
}

