/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;

public class EmptySet<T>
implements Set<T> {
    private static final EmptySet<?> EMPTY = new EmptySet();

    public static <T> EmptySet<T> empty() {
        return EMPTY;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new IllegalStateException("Set is EMPTY");
            }
        };
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return new Object[0];
    }

    @Override
    public boolean add(@Nonnull T e) {
        throw new IllegalStateException("Set is EMPTY");
    }

    @Override
    public boolean remove(@Nonnull Object o) {
        throw new IllegalStateException("Set is EMPTY");
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> c) {
        throw new IllegalStateException("Set is EMPTY");
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        throw new IllegalStateException("Set is EMPTY");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new IllegalStateException("Set is EMPTY");
    }

    @Override
    public void clear() {
    }
}

