/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import java.util.EnumSet;
import journeymap.client.api.display.Context;
import journeymap.client.model.MapType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

public enum Feature {
    RadarPlayers,
    RadarAnimals,
    RadarMobs,
    RadarVillagers,
    MapTopo,
    MapSurface,
    MapCaves,
    MapBiome;


    public static EnumSet<Feature> radar() {
        return EnumSet.of(RadarPlayers, RadarAnimals, RadarMobs, RadarVillagers);
    }

    public static EnumSet<Feature> all() {
        return EnumSet.allOf(Feature.class);
    }

    public static Feature fromMapType(MapType mapType) {
        MapType.Name name = mapType.name;
        switch (name) {
            case topo: {
                return MapTopo;
            }
            case underground: {
                return MapCaves;
            }
            case biome: {
                return MapBiome;
            }
        }
        return MapSurface;
    }

    public static Feature fromApiMapType(Context.MapType mapType, RegistryKey<World> dimension) {
        return Feature.fromMapType(MapType.fromApiContextMapType(mapType, 0, dimension == null ? Minecraft.func_71410_x().field_71439_g.field_213837_d.func_234923_W_() : dimension));
    }
}

