/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc;

import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.vc.CommonProxy;
import noppes.vc.ServerEventsHandler;
import noppes.vc.client.ClientProxy;
import noppes.vc.client.VCSounds;
import noppes.vc.config.ConfigLoader;
import noppes.vc.config.ConfigProp;
import noppes.vc.packets.Packets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="variedcommodities")
public class VariedCommodities {
    public static final String MODID = "variedcommodities";
    public static final String VERSION = "1.16.5";
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    @ConfigProp(info="Disables all Varied Commodities enchantments")
    public static boolean DisableEnchantments = false;
    public static VariedCommodities Instance;
    public static Logger Log;
    public static ConfigLoader Config;

    public VariedCommodities() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    public void setup(FMLCommonSetupEvent event) {
        Instance = this;
        Config = new ConfigLoader(this.getClass(), FMLPaths.CONFIGDIR.get().toFile(), "VariedCommodities");
        Config.loadConfig();
        Packets.register();
        MinecraftForge.EVENT_BUS.register((Object)new VCSounds());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
    }

    @SubscribeEvent
    public void onMissingMapping(RegistryEvent.MissingMappings<Item> event) {
        Map<String, ResourceLocation> maps = this.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String resourcePath = mapping.key.toString().toLowerCase();
            if (!maps.containsKey(resourcePath)) continue;
            Item item = (Item)GameData.getWrapper((RegistryKey)ForgeRegistries.Keys.ITEMS, (Lifecycle)Lifecycle.stable()).func_82594_a(maps.get(resourcePath));
            if (item == null) {
                System.out.println(maps.get(resourcePath));
            }
            mapping.remap((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public void onMissingBlockMapping(RegistryEvent.MissingMappings<Block> event) {
        Map<String, ResourceLocation> maps = this.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String resourcePath = mapping.key.toString().toLowerCase();
            if (!maps.containsKey(resourcePath)) continue;
            Block b = (Block)GameData.getWrapper((RegistryKey)ForgeRegistries.Keys.BLOCKS, (Lifecycle)Lifecycle.stable()).func_82594_a(maps.get(resourcePath));
            if (b == null) {
                System.out.println(maps.get(resourcePath));
            }
            mapping.remap((IForgeRegistryEntry)b);
        }
    }

    @SubscribeEvent
    public void onMissingTileMapping(RegistryEvent.MissingMappings<TileEntityType<?>> event) {
        Map<String, ResourceLocation> maps = this.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String resourcePath = mapping.key.toString().toLowerCase();
            if (!maps.containsKey(resourcePath)) continue;
            TileEntityType t = (TileEntityType)GameData.getWrapper((RegistryKey)ForgeRegistries.Keys.TILE_ENTITY_TYPES, (Lifecycle)Lifecycle.stable()).func_82594_a(maps.get(resourcePath));
            if (t == null) {
                System.out.println(maps.get(resourcePath));
            }
            mapping.remap((IForgeRegistryEntry)t);
        }
    }

    private Map<String, ResourceLocation> getMappings() {
        HashMap<String, ResourceLocation> maps = new HashMap<String, ResourceLocation>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(MinecraftServer.class.getResourceAsStream("/assets/variedcommodities/mappingfix.cfg")));
            while ((line = br.readLine()) != null) {
                String[] split = line.toLowerCase().split("=");
                if (split.length != 2) continue;
                maps.put(split[0], new ResourceLocation(split[1]));
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maps;
    }

    static {
        Log = LogManager.getLogger();
    }
}

