/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.CharacterManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.vc.packets.Packets;
import noppes.vc.packets.server.SPacketBookSave;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class GuiBook
extends Screen {
    private static final ITextComponent EDIT_TITLE_LABEL = new TranslationTextComponent("book.editTitle");
    private static final ITextComponent FINALIZE_WARNING_LABEL = new TranslationTextComponent("book.finalizeWarning");
    private static final IReorderingProcessor BLACK_CURSOR = IReorderingProcessor.func_242239_a((String)"_", (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.BLACK));
    private static final IReorderingProcessor GRAY_CURSOR = IReorderingProcessor.func_242239_a((String)"_", (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
    private final PlayerEntity owner;
    private final ItemStack book;
    private boolean isModified;
    private boolean isSigning;
    private int frameTick;
    private int currentPage;
    private final List<String> pages = Lists.newArrayList();
    private String title = "";
    private final TextInputUtil pageEdit = new TextInputUtil(this::getCurrentPageText, this::setCurrentPageText, this::getClipboard, this::setClipboard, p_238774_1_ -> p_238774_1_.length() < 1024 && this.field_230712_o_.func_78267_b(p_238774_1_, 114) <= 128);
    private final TextInputUtil titleEdit = new TextInputUtil(() -> this.title, p_238772_1_ -> {
        this.title = p_238772_1_;
    }, this::getClipboard, this::setClipboard, p_238771_0_ -> p_238771_0_.length() < 16);
    private long lastClickTime;
    private int lastIndex = -1;
    private ChangePageButton forwardButton;
    private ChangePageButton backButton;
    private Button doneButton;
    private Button signButton;
    private Button finalizeButton;
    private Button cancelButton;
    @Nullable
    private BookPage displayCache = BookPage.access$000();
    private ITextComponent pageMsg = StringTextComponent.field_240750_d_;
    private final ITextComponent ownerText;
    private BlockPos pos;

    public GuiBook(PlayerEntity p_i51100_1_, ItemStack p_i51100_2_, BlockPos pos) {
        super(NarratorChatListener.field_216868_a);
        this.owner = p_i51100_1_;
        this.book = p_i51100_2_;
        this.pos = pos;
        CompoundNBT compoundnbt = p_i51100_2_.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("pages", 8).func_74737_b();
            for (int i = 0; i < listnbt.size(); ++i) {
                this.pages.add(listnbt.func_150307_f(i));
            }
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
        this.ownerText = new TranslationTextComponent("book.byAuthor", new Object[]{p_i51100_1_.func_200200_C_()}).func_240699_a_(TextFormatting.DARK_GRAY);
    }

    private void setClipboard(String p_238760_1_) {
        if (this.field_230706_i_ != null) {
            TextInputUtil.func_238571_a_((Minecraft)this.field_230706_i_, (String)p_238760_1_);
        }
    }

    private String getClipboard() {
        return this.field_230706_i_ != null ? TextInputUtil.func_238576_b_((Minecraft)this.field_230706_i_) : "";
    }

    private int getNumPages() {
        return this.pages.size();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.frameTick;
    }

    protected void func_231160_c_() {
        this.clearDisplayCache();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.signButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, 196, 98, 20, (ITextComponent)new TranslationTextComponent("book.signButton"), p_214201_1_ -> {
            this.isSigning = true;
            this.updateButtonVisibility();
        }));
        this.doneButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 2, 196, 98, 20, DialogTexts.field_240632_c_, p_214204_1_ -> {
            this.field_230706_i_.func_147108_a((Screen)null);
            this.saveChanges(false);
        }));
        this.finalizeButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, 196, 98, 20, (ITextComponent)new TranslationTextComponent("book.finalizeButton"), p_214195_1_ -> {
            if (this.isSigning) {
                this.saveChanges(true);
                this.field_230706_i_.func_147108_a((Screen)null);
            }
        }));
        this.cancelButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 2, 196, 98, 20, DialogTexts.field_240633_d_, p_214212_1_ -> {
            if (this.isSigning) {
                this.isSigning = false;
            }
            this.updateButtonVisibility();
        }));
        int i = (this.field_230708_k_ - 192) / 2;
        int j = 2;
        this.forwardButton = (ChangePageButton)this.func_230480_a_((Widget)new ChangePageButton(i + 116, 159, true, p_214208_1_ -> this.pageForward(), true));
        this.backButton = (ChangePageButton)this.func_230480_a_((Widget)new ChangePageButton(i + 43, 159, false, p_214205_1_ -> this.pageBack(), true));
        this.updateButtonVisibility();
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
        this.clearDisplayCacheAfterPageChange();
    }

    private void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        } else {
            this.appendPageToBook();
            if (this.currentPage < this.getNumPages() - 1) {
                ++this.currentPage;
            }
        }
        this.updateButtonVisibility();
        this.clearDisplayCacheAfterPageChange();
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void updateButtonVisibility() {
        this.backButton.field_230694_p_ = !this.isSigning && this.currentPage > 0;
        this.forwardButton.field_230694_p_ = !this.isSigning;
        this.doneButton.field_230694_p_ = !this.isSigning;
        this.signButton.field_230694_p_ = !this.isSigning;
        this.cancelButton.field_230694_p_ = this.isSigning;
        this.finalizeButton.field_230694_p_ = this.isSigning;
        this.finalizeButton.field_230693_o_ = !this.title.trim().isEmpty();
    }

    private void eraseEmptyTrailingPages() {
        ListIterator<String> listiterator = this.pages.listIterator(this.pages.size());
        while (listiterator.hasPrevious() && listiterator.previous().isEmpty()) {
            listiterator.remove();
        }
    }

    private void saveChanges(boolean p_214198_1_) {
        if (this.isModified) {
            this.eraseEmptyTrailingPages();
            ListNBT listnbt = new ListNBT();
            this.pages.stream().map(StringNBT::func_229705_a_).forEach(arg_0 -> listnbt.add(arg_0));
            if (!this.pages.isEmpty()) {
                this.book.func_77983_a("pages", (INBT)listnbt);
            }
            if (p_214198_1_) {
                this.book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)this.owner.func_146103_bH().getName()));
                this.book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)this.title.trim()));
            }
            Packets.sendServer(new SPacketBookSave(this.pos, p_214198_1_, this.book));
        }
    }

    private void appendPageToBook() {
        if (this.getNumPages() < 100) {
            this.pages.add("");
            this.isModified = true;
        }
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        if (this.isSigning) {
            return this.titleKeyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
        }
        boolean flag = this.bookKeyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
        if (flag) {
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        if (super.func_231042_a_(p_231042_1_, p_231042_2_)) {
            return true;
        }
        if (this.isSigning) {
            boolean flag = this.titleEdit.func_216894_a(p_231042_1_);
            if (flag) {
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
            return false;
        }
        if (SharedConstants.func_71566_a((char)p_231042_1_)) {
            this.pageEdit.func_216892_a(Character.toString(p_231042_1_));
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    private boolean bookKeyPressed(int p_214230_1_, int p_214230_2_, int p_214230_3_) {
        if (Screen.func_231170_j_((int)p_214230_1_)) {
            this.pageEdit.func_238585_d_();
            return true;
        }
        if (Screen.func_231169_i_((int)p_214230_1_)) {
            this.pageEdit.func_238580_c_();
            return true;
        }
        if (Screen.func_231168_h_((int)p_214230_1_)) {
            this.pageEdit.func_238574_b_();
            return true;
        }
        if (Screen.func_231166_g_((int)p_214230_1_)) {
            this.pageEdit.func_238567_a_();
            return true;
        }
        switch (p_214230_1_) {
            case 257: 
            case 335: {
                this.pageEdit.func_216892_a("\n");
                return true;
            }
            case 259: {
                this.pageEdit.func_238586_d_(-1);
                return true;
            }
            case 261: {
                this.pageEdit.func_238586_d_(1);
                return true;
            }
            case 262: {
                this.pageEdit.func_238569_a_(1, Screen.func_231173_s_());
                return true;
            }
            case 263: {
                this.pageEdit.func_238569_a_(-1, Screen.func_231173_s_());
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 266: {
                this.backButton.func_230930_b_();
                return true;
            }
            case 267: {
                this.forwardButton.func_230930_b_();
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.keyEnd();
                return true;
            }
        }
        return false;
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int p_238755_1_) {
        int i = this.pageEdit.func_216896_c();
        int j = this.getDisplayCache().changeLine(i, p_238755_1_);
        this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
    }

    private void keyHome() {
        int i = this.pageEdit.func_216896_c();
        int j = this.getDisplayCache().findLineStart(i);
        this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
    }

    private void keyEnd() {
        BookPage editbookscreen$bookpage = this.getDisplayCache();
        int i = this.pageEdit.func_216896_c();
        int j = editbookscreen$bookpage.findLineEnd(i);
        this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
    }

    private boolean titleKeyPressed(int p_214196_1_, int p_214196_2_, int p_214196_3_) {
        switch (p_214196_1_) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.saveChanges(true);
                    this.field_230706_i_.func_147108_a((Screen)null);
                }
                return true;
            }
            case 259: {
                this.titleEdit.func_238586_d_(-1);
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
        }
        return false;
    }

    private String getCurrentPageText() {
        return this.currentPage >= 0 && this.currentPage < this.pages.size() ? this.pages.get(this.currentPage) : "";
    }

    private void setCurrentPageText(String p_214217_1_) {
        if (this.currentPage >= 0 && this.currentPage < this.pages.size()) {
            this.pages.set(this.currentPage, p_214217_1_);
            this.isModified = true;
            this.clearDisplayCache();
        }
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        this.func_231035_a_(null);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(ReadBookScreen.field_214167_b);
        int i = (this.field_230708_k_ - 192) / 2;
        int j = 2;
        this.func_238474_b_(p_230430_1_, i, 2, 0, 0, 192, 192);
        if (this.isSigning) {
            boolean flag = this.frameTick / 6 % 2 == 0;
            IReorderingProcessor ireorderingprocessor = IReorderingProcessor.func_242234_a((IReorderingProcessor)IReorderingProcessor.func_242239_a((String)this.title, (Style)Style.field_240709_b_), (IReorderingProcessor)(flag ? BLACK_CURSOR : GRAY_CURSOR));
            int k = this.field_230712_o_.func_238414_a_((ITextProperties)EDIT_TITLE_LABEL);
            this.field_230712_o_.func_243248_b(p_230430_1_, EDIT_TITLE_LABEL, (float)(i + 36 + (114 - k) / 2), 34.0f, 0);
            int l = this.field_230712_o_.func_243245_a(ireorderingprocessor);
            this.field_230712_o_.func_238422_b_(p_230430_1_, ireorderingprocessor, (float)(i + 36 + (114 - l) / 2), 50.0f, 0);
            int i1 = this.field_230712_o_.func_238414_a_((ITextProperties)this.ownerText);
            this.field_230712_o_.func_243248_b(p_230430_1_, this.ownerText, (float)(i + 36 + (114 - i1) / 2), 60.0f, 0);
            this.field_230712_o_.func_238418_a_((ITextProperties)FINALIZE_WARNING_LABEL, i + 36, 82, 114, 0);
        } else {
            int j1 = this.field_230712_o_.func_238414_a_((ITextProperties)this.pageMsg);
            this.field_230712_o_.func_243248_b(p_230430_1_, this.pageMsg, (float)(i - j1 + 192 - 44), 18.0f, 0);
            BookPage editbookscreen$bookpage = this.getDisplayCache();
            for (BookLine editbookscreen$bookline : editbookscreen$bookpage.lines) {
                this.field_230712_o_.func_243248_b(p_230430_1_, editbookscreen$bookline.asComponent, (float)editbookscreen$bookline.x, (float)editbookscreen$bookline.y, -16777216);
            }
            this.renderHighlight(editbookscreen$bookpage.selection);
            this.renderCursor(p_230430_1_, editbookscreen$bookpage.cursor, editbookscreen$bookpage.cursorAtEnd);
        }
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    private void renderCursor(MatrixStack p_238756_1_, Point p_238756_2_, boolean p_238756_3_) {
        if (this.frameTick / 6 % 2 == 0) {
            p_238756_2_ = this.convertLocalToScreen(p_238756_2_);
            if (!p_238756_3_) {
                AbstractGui.func_238467_a_((MatrixStack)p_238756_1_, (int)p_238756_2_.x, (int)(p_238756_2_.y - 1), (int)(p_238756_2_.x + 1), (int)(p_238756_2_.y + 9), (int)-16777216);
            } else {
                this.field_230712_o_.func_238421_b_(p_238756_1_, "_", (float)p_238756_2_.x, (float)p_238756_2_.y, 0);
            }
        }
    }

    private void renderHighlight(Rectangle2d[] p_238764_1_) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Rectangle2d rectangle2d : p_238764_1_) {
            int i = rectangle2d.func_199318_a();
            int j = rectangle2d.func_199319_b();
            int k = i + rectangle2d.func_199316_c();
            int l = j + rectangle2d.func_199317_d();
            bufferbuilder.func_225582_a_((double)i, (double)l, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)k, (double)l, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)k, (double)j, 0.0).func_181675_d();
            bufferbuilder.func_225582_a_((double)i, (double)j, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    private Point convertScreenToLocal(Point p_238758_1_) {
        return new Point(p_238758_1_.x - (this.field_230708_k_ - 192) / 2 - 36, p_238758_1_.y - 32);
    }

    private Point convertLocalToScreen(Point p_238767_1_) {
        return new Point(p_238767_1_.x + (this.field_230708_k_ - 192) / 2 + 36, p_238767_1_.y + 32);
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_)) {
            return true;
        }
        if (p_231044_5_ == 0) {
            long i = Util.func_211177_b();
            BookPage editbookscreen$bookpage = this.getDisplayCache();
            int j = editbookscreen$bookpage.getIndexAtPosition(this.field_230712_o_, this.convertScreenToLocal(new Point((int)p_231044_1_, (int)p_231044_3_)));
            if (j >= 0) {
                if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                    if (!this.pageEdit.func_238590_i_()) {
                        this.selectWord(j);
                    } else {
                        this.pageEdit.func_238585_d_();
                    }
                } else {
                    this.pageEdit.func_238581_c_(j, Screen.func_231173_s_());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j;
            this.lastClickTime = i;
        }
        return true;
    }

    private void selectWord(int p_238765_1_) {
        String s = this.getCurrentPageText();
        this.pageEdit.func_238568_a_(CharacterManager.func_238351_a_((String)s, (int)-1, (int)p_238765_1_, (boolean)false), CharacterManager.func_238351_a_((String)s, (int)1, (int)p_238765_1_, (boolean)false));
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (super.func_231045_a_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_)) {
            return true;
        }
        if (p_231045_5_ == 0) {
            BookPage editbookscreen$bookpage = this.getDisplayCache();
            int i = editbookscreen$bookpage.getIndexAtPosition(this.field_230712_o_, this.convertScreenToLocal(new Point((int)p_231045_1_, (int)p_231045_3_)));
            this.pageEdit.func_238581_c_(i, true);
            this.clearDisplayCache();
        }
        return true;
    }

    private BookPage getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
            this.pageMsg = new TranslationTextComponent("book.pageIndicator", new Object[]{this.currentPage + 1, this.getNumPages()});
        }
        return this.displayCache;
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    private void clearDisplayCacheAfterPageChange() {
        this.pageEdit.func_238588_f_();
        this.clearDisplayCache();
    }

    private BookPage rebuildDisplayCache() {
        Point editbookscreen$point;
        boolean flag;
        String s = this.getCurrentPageText();
        if (s.isEmpty()) {
            return BookPage.EMPTY;
        }
        int i = this.pageEdit.func_216896_c();
        int j = this.pageEdit.func_216898_d();
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        CharacterManager charactermanager = this.field_230712_o_.func_238420_b_();
        charactermanager.func_238353_a_(s, 114, Style.field_240709_b_, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$10(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] aint = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            editbookscreen$point = new Point(0, list.size() * 9);
        } else {
            int k = GuiBook.findLineFromPos(aint, i);
            int l = this.field_230712_o_.func_78256_a(s.substring(aint[k], i));
            editbookscreen$point = new Point(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = GuiBook.findLineFromPos(aint, l2);
            if (j1 == (k1 = GuiBook.findLineFromPos(aint, i1))) {
                int l1 = j1 * 9;
                int i2 = aint[j1];
                list1.add(this.createPartialLineSelection(s, charactermanager, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > aint.length ? s.length() : aint[j1 + 1];
                list1.add(this.createPartialLineSelection(s, charactermanager, l2, i3, j1 * 9, aint[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(aint[j3], aint[j3 + 1]);
                    int k2 = (int)charactermanager.func_238350_a_(s1);
                    list1.add(this.createSelection(new Point(0, j2), new Point(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, charactermanager, aint[k1], i1, k1 * 9, aint[k1]));
            }
        }
        return new BookPage(s, editbookscreen$point, flag, aint, list.toArray(new BookLine[0]), list1.toArray(new Rectangle2d[0]));
    }

    private static int findLineFromPos(int[] p_238768_0_, int p_238768_1_) {
        int i = Arrays.binarySearch(p_238768_0_, p_238768_1_);
        return i < 0 ? -(i + 2) : i;
    }

    private Rectangle2d createPartialLineSelection(String p_238761_1_, CharacterManager p_238761_2_, int p_238761_3_, int p_238761_4_, int p_238761_5_, int p_238761_6_) {
        String s = p_238761_1_.substring(p_238761_6_, p_238761_3_);
        String s1 = p_238761_1_.substring(p_238761_6_, p_238761_4_);
        Point editbookscreen$point = new Point((int)p_238761_2_.func_238350_a_(s), p_238761_5_);
        Point editbookscreen$point1 = new Point((int)p_238761_2_.func_238350_a_(s1), p_238761_5_ + 9);
        return this.createSelection(editbookscreen$point, editbookscreen$point1);
    }

    private Rectangle2d createSelection(Point p_238759_1_, Point p_238759_2_) {
        Point editbookscreen$point = this.convertLocalToScreen(p_238759_1_);
        Point editbookscreen$point1 = this.convertLocalToScreen(p_238759_2_);
        int i = Math.min(editbookscreen$point.x, editbookscreen$point1.x);
        int j = Math.max(editbookscreen$point.x, editbookscreen$point1.x);
        int k = Math.min(editbookscreen$point.y, editbookscreen$point1.y);
        int l = Math.max(editbookscreen$point.y, editbookscreen$point1.y);
        return new Rectangle2d(i, k, j - i, l - k);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$10(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, Style p_238762_6_, int p_238762_7_, int p_238762_8_) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(p_238762_7_, p_238762_8_);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Point editbookscreen$point1 = this.convertLocalToScreen(new Point(0, l3));
        intlist.add(p_238762_7_);
        list.add(new BookLine(p_238762_6_, s3, editbookscreen$point1.x, editbookscreen$point1.y));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Point {
        public final int x;
        public final int y;

        Point(int p_i232290_1_, int p_i232290_2_) {
            this.x = p_i232290_1_;
            this.y = p_i232290_2_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BookPage {
        private static final BookPage EMPTY = new BookPage("", new Point(0, 0), true, new int[]{0}, new BookLine[]{new BookLine(Style.field_240709_b_, "", 0, 0)}, new Rectangle2d[0]);
        private final String fullText;
        private final Point cursor;
        private final boolean cursorAtEnd;
        private final int[] lineStarts;
        private final BookLine[] lines;
        private final Rectangle2d[] selection;

        public BookPage(String p_i232288_1_, Point p_i232288_2_, boolean p_i232288_3_, int[] p_i232288_4_, BookLine[] p_i232288_5_, Rectangle2d[] p_i232288_6_) {
            this.fullText = p_i232288_1_;
            this.cursor = p_i232288_2_;
            this.cursorAtEnd = p_i232288_3_;
            this.lineStarts = p_i232288_4_;
            this.lines = p_i232288_5_;
            this.selection = p_i232288_6_;
        }

        public int getIndexAtPosition(FontRenderer p_238789_1_, Point p_238789_2_) {
            int i = p_238789_2_.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            BookLine editbookscreen$bookline = this.lines[i];
            return this.lineStarts[i] + p_238789_1_.func_238420_b_().func_238352_a_(editbookscreen$bookline.contents, p_238789_2_.x, editbookscreen$bookline.style);
        }

        public int changeLine(int p_238788_1_, int p_238788_2_) {
            int k;
            int i = GuiBook.findLineFromPos(this.lineStarts, p_238788_1_);
            int j = i + p_238788_2_;
            if (0 <= j && j < this.lineStarts.length) {
                int l = p_238788_1_ - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = p_238788_1_;
            }
            return k;
        }

        public int findLineStart(int p_238787_1_) {
            int i = GuiBook.findLineFromPos(this.lineStarts, p_238787_1_);
            return this.lineStarts[i];
        }

        public int findLineEnd(int p_238791_1_) {
            int i = GuiBook.findLineFromPos(this.lineStarts, p_238791_1_);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BookLine {
        private final Style style;
        private final String contents;
        private final ITextComponent asComponent;
        private final int x;
        private final int y;

        public BookLine(Style p_i232289_1_, String p_i232289_2_, int p_i232289_3_, int p_i232289_4_) {
            this.style = p_i232289_1_;
            this.contents = p_i232289_2_;
            this.x = p_i232289_3_;
            this.y = p_i232289_4_;
            this.asComponent = new StringTextComponent(p_i232289_2_).func_230530_a_(p_i232289_1_);
        }
    }
}

