/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.vc.EntityMagicProjectile;
import noppes.vc.EntityProjectile;
import noppes.vc.VCItems;
import noppes.vc.VCTabs;
import noppes.vc.VCWeapons;
import noppes.vc.VariedCommodities;
import noppes.vc.client.VCSounds;
import noppes.vc.enchants.VCEnchant;
import noppes.vc.items.ItemBasic;

public class ItemStaff
extends ItemBasic {
    private IItemTier material;
    private Item orb;

    public ItemStaff(IItemTier material) {
        super(new Item.Properties().func_200915_b(material.func_200926_a()).func_200916_a(VCTabs.WEAPONS));
        this.material = material;
        this.orb = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("variedcommodities", "orb_white"));
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public void func_77615_a(final ItemStack stack, World worldObj, LivingEntity entity, int par4) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (stack.func_77978_p() == null) {
            return;
        }
        Entity proj = ((ServerWorld)worldObj).func_73045_a(stack.func_77978_p().func_74762_e("MagicProjectile"));
        if (proj == null || !(proj instanceof EntityProjectile)) {
            return;
        }
        EntityProjectile item = (EntityProjectile)proj;
        item.callback = new EntityProjectile.IProjectileCallback(){

            @Override
            public boolean onImpact(EntityProjectile entityProjectile, BlockPos pos, Entity entity) {
                int poison;
                if (entity == null || !(entity instanceof LivingEntity)) {
                    return false;
                }
                LivingEntity living = (LivingEntity)entity;
                int confusion = VCEnchant.getLevel(VCEnchant.Confusion, stack);
                if (confusion > 0 && living.func_70681_au().nextInt(4) < confusion) {
                    living.func_195064_c(new EffectInstance(Effects.field_76431_k, 100));
                }
                if ((poison = VCEnchant.getLevel(VCEnchant.Poison, stack)) > 0 && living.func_70681_au().nextInt(4) < poison) {
                    living.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
                }
                return false;
            }
        };
        item.explosiveDamage = false;
        item.explosiveRadius = 1;
        item.field_70126_B = item.field_70177_z = entity.field_70177_z;
        item.field_70127_C = item.field_70125_A = entity.field_70125_A;
        item.shoot(2.0f);
        ItemStaff.playSound(entity, VCSounds.MAGIC_SHOT, 1.0f, 1.0f);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        double dz;
        double dx;
        int tick = this.func_77626_a(stack) - count;
        if (entity.field_70170_p.field_72995_K) {
            this.addParticle(stack, entity);
            return;
        }
        int chargeTime = 20 + this.material.func_200925_d() * 8;
        if (tick == chargeTime) {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                if (!player.field_71075_bZ.field_75098_d && !this.hasInfinite(stack)) {
                    if (!this.hasItem(player, VCWeapons.mana)) {
                        return;
                    }
                    this.consumeItem(player, VCWeapons.mana);
                }
            }
            ItemStaff.playSound(entity, VCSounds.MAGIC_CHARGE, 1.0f, 1.0f);
            float damage = 6.0f + this.material.func_200929_c() + (float)entity.field_70170_p.field_73012_v.nextInt(4);
            damage += damage * (float)VCEnchant.getLevel(VCEnchant.Damage, stack) * 0.5f;
            EntityMagicProjectile projectile = new EntityMagicProjectile(entity.field_70170_p, entity, this.getProjectile(stack));
            projectile.damage = damage;
            projectile.setSpeed(25);
            dx = -MathHelper.func_76126_a((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            dz = MathHelper.func_76134_b((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            projectile.func_70107_b(entity.func_226277_ct_() + dx * 0.8, entity.func_226278_cu_() + 1.5 - (double)(entity.field_70125_A / 80.0f), entity.func_226281_cx_() + dz * 0.8);
            entity.field_70170_p.func_217376_c((Entity)projectile);
            stack.func_77983_a("MagicProjectile", (INBT)IntNBT.func_229692_a_((int)projectile.func_145782_y()));
        }
        if (tick > chargeTime && stack.func_77978_p() != null) {
            Entity proj = ((ServerWorld)entity.field_70170_p).func_73045_a(stack.func_77978_p().func_74762_e("MagicProjectile"));
            if (proj == null || !(proj instanceof EntityProjectile)) {
                return;
            }
            EntityProjectile item = (EntityProjectile)proj;
            item.ticksInAir = 0;
            dx = -MathHelper.func_76126_a((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            dz = MathHelper.func_76134_b((float)((float)((double)(entity.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(entity.field_70125_A / 180.0f) * Math.PI)));
            item.func_70107_b(entity.func_226277_ct_() + dx * 0.8, entity.func_226278_cu_() + 1.5 - (double)(entity.field_70125_A / 80.0f), entity.func_226281_cx_() + dz * 0.8);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ItemStack getProjectile(ItemStack stack) {
        if (stack.func_77973_b() == VCWeapons.wooden_staff) {
            return new ItemStack((IItemProvider)VCItems.spell_nature);
        }
        if (stack.func_77973_b() == VCWeapons.stone_staff || stack.func_77973_b() == VCWeapons.demonic_staff) {
            return new ItemStack((IItemProvider)VCItems.spell_dark);
        }
        if (stack.func_77973_b() == VCWeapons.iron_staff || stack.func_77973_b() == VCWeapons.mithril_staff) {
            return new ItemStack((IItemProvider)VCItems.spell_holy);
        }
        if (stack.func_77973_b() == VCWeapons.bronze_staff) {
            return new ItemStack((IItemProvider)VCItems.spell_lightning);
        }
        if (stack.func_77973_b() == VCWeapons.golden_staff) {
            return new ItemStack((IItemProvider)VCItems.spell_fire);
        }
        if (stack.func_77973_b() == VCWeapons.diamond_staff || stack.func_77973_b() == VCWeapons.frost_staff) {
            return new ItemStack((IItemProvider)VCItems.spell_ice);
        }
        if (stack.func_77973_b() == VCWeapons.emerald_staff) {
            return new ItemStack((IItemProvider)VCItems.spell_arcane);
        }
        return new ItemStack((IItemProvider)this.orb, 1);
    }

    public void addParticle(ItemStack stack, LivingEntity entity) {
        if (stack.func_77973_b() == VCWeapons.wooden_staff) {
            VariedCommodities.proxy.addParticle(entity, "Spell", 5, 2);
            VariedCommodities.proxy.addParticle(entity, "Spell", 12, 2);
        } else if (stack.func_77973_b() == VCWeapons.stone_staff || stack.func_77973_b() == VCWeapons.demonic_staff) {
            VariedCommodities.proxy.addParticle(entity, "Spell", 5649239, 2);
            VariedCommodities.proxy.addParticle(entity, "Spell", 4400964, 2);
        } else if (stack.func_77973_b() == VCWeapons.bronze_staff) {
            VariedCommodities.proxy.addParticle(entity, "Spell", 8648694, 2);
            VariedCommodities.proxy.addParticle(entity, "Spell", 6091007, 2);
        } else if (stack.func_77973_b() == VCWeapons.iron_staff || stack.func_77973_b() == VCWeapons.mithril_staff) {
            VariedCommodities.proxy.addParticle(entity, "Spell", 0xFCFFC9, 2);
            VariedCommodities.proxy.addParticle(entity, "Spell", 15728535, 2);
        } else if (stack.func_77973_b() == VCWeapons.golden_staff) {
            VariedCommodities.proxy.addParticle(entity, "Spell", 1, 2);
            VariedCommodities.proxy.addParticle(entity, "Spell", 14, 2);
        } else if (stack.func_77973_b() == VCWeapons.diamond_staff || stack.func_77973_b() == VCWeapons.frost_staff) {
            VariedCommodities.proxy.addParticle(entity, "Spell", 9756653, 2);
            VariedCommodities.proxy.addParticle(entity, "Spell", 4503295, 2);
        } else if (stack.func_77973_b() == VCWeapons.emerald_staff) {
            VariedCommodities.proxy.addParticle(entity, "Spell", 16761831, 2);
            VariedCommodities.proxy.addParticle(entity, "Spell", 16487167, 2);
        }
    }

    public int getItemEnchantability(ItemStack item) {
        return this.material.func_200927_e();
    }

    public boolean hasInfinite(ItemStack stack) {
        return VCEnchant.getLevel(VCEnchant.Infinite, stack) > 0;
    }
}

