/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.FireJet;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class FireJetEffect
extends JetEffect {
    public FireJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.FIRE;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return WorldUtils.isAirBlock(provider, pos.func_177984_a()) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        boolean isSolid;
        float spawnHeight;
        int blockCount;
        if (!state.func_204520_s().func_206888_e()) {
            blockCount = FireJetEffect.countVerticalBlocks(provider, pos, LAVA_PREDICATE, -1);
            spawnHeight = (float)pos.func_177956_o() + state.func_204520_s().func_223408_f() + 0.1f;
            isSolid = false;
        } else {
            VoxelShape shape = state.func_196954_c(provider, pos);
            if (shape.func_197766_b()) {
                return;
            }
            double blockHeight = shape.func_197752_a().field_72337_e;
            spawnHeight = (float)((double)pos.func_177956_o() + blockHeight);
            isSolid = true;
            blockCount = state.func_200132_m() ? 2 : 1;
        }
        if (blockCount > 0) {
            FireJet effect = new FireJet(blockCount, provider, (double)pos.func_177958_n() + 0.5, spawnHeight, (double)pos.func_177952_p() + 0.5, isSolid);
            this.addEffect(effect);
        }
    }
}

