/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.StringListListEntry;
import me.shedaniel.clothconfig2.forge.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.IntSliderBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.StringListBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.SubCategoryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.config.ConfigProperty;

@OnlyIn(value=Dist.CLIENT)
public abstract class ClothAPIFactory
implements BiFunction<Minecraft, Screen, Screen> {
    private final ITextComponent title;
    private final Runnable save;
    private final ResourceLocation background;

    public ClothAPIFactory(@Nonnull ITextComponent title, @Nonnull Runnable save) {
        this(title, save, null);
    }

    public ClothAPIFactory(@Nonnull ITextComponent title, @Nonnull Runnable save, @Nullable ResourceLocation background) {
        this.title = title;
        this.save = save;
        this.background = background;
    }

    @Override
    public Screen apply(@Nonnull Minecraft minecraft, @Nonnull Screen screen) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle(this.title).setSavingRunnable(this.save);
        if (this.background != null) {
            builder.setDefaultBackgroundTexture(this.background);
        }
        this.generate(builder);
        return builder.build();
    }

    protected abstract void generate(@Nonnull ConfigBuilder var1);

    public static ConfigCategory createRootCategory(@Nonnull ConfigBuilder builder) {
        return ClothAPIFactory.createCategory(builder, "dontcare");
    }

    public static ConfigCategory createCategory(@Nonnull ConfigBuilder builder, @Nonnull String translationKey) {
        return builder.getOrCreateCategory(ClothAPIFactory.transformText(translationKey, TextFormatting.GOLD));
    }

    public static SubCategoryBuilder createSubCategory(@Nonnull ConfigEntryBuilder entryBuilder, @Nonnull String translationKey, boolean expanded) {
        return ClothAPIFactory.createSubCategory(entryBuilder, translationKey, null, expanded);
    }

    public static SubCategoryBuilder createSubCategory(@Nonnull ConfigEntryBuilder entryBuilder, @Nonnull String translationKey, @Nullable TextFormatting color, boolean expanded) {
        ITextComponent label = ClothAPIFactory.transformText(translationKey, color);
        ArrayList<Object> toolTip = new ArrayList<Object>();
        toolTip.add(label);
        List lines = GameUtils.getMC().field_71466_p.func_238420_b_().func_238362_b_((ITextProperties)new TranslationTextComponent(translationKey + ".tooltip"), 300, Style.field_240709_b_);
        for (ITextProperties l : lines) {
            toolTip.add(new StringTextComponent(l.getString()));
        }
        return entryBuilder.startSubCategory(label).setTooltip(toolTip.toArray(new ITextComponent[0])).setExpanded(expanded);
    }

    public static StringListEntry createString(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.ConfigValue<String> value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        IFormattableTextComponent name = property.getConfigName();
        StringFieldBuilder result = builder.entryBuilder().startStrField((ITextComponent)name, (String)value.get()).setTooltip(property.getTooltip()).setDefaultValue((String)value.get()).setSaveConsumer(arg_0 -> value.set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static BooleanListEntry createBoolean(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.BooleanValue value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        IFormattableTextComponent name = property.getConfigName();
        BooleanToggleBuilder result = builder.entryBuilder().startBooleanToggle((ITextComponent)name, ((Boolean)value.get()).booleanValue()).setTooltip(property.getTooltip()).setDefaultValue(((Boolean)value.get()).booleanValue()).setYesNoTextSupplier(DialogTexts::func_240638_a_).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)value).set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static IntegerListEntry createInteger(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.IntValue value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        IFormattableTextComponent name = property.getConfigName();
        int min = (Integer)property.getMinValue();
        int max = (Integer)property.getMaxValue();
        IntFieldBuilder result = builder.entryBuilder().startIntField((ITextComponent)name, ((Integer)value.get()).intValue()).setTooltip(property.getTooltip()).setDefaultValue(((Integer)value.get()).intValue()).setMin(min).setMax(max).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)value).set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static StringListListEntry createStringList(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.ConfigValue<List<? extends String>> value, @Nullable Function<String, Optional<ITextComponent>> validator) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        IFormattableTextComponent name = property.getConfigName();
        List list = ((List)value.get()).stream().map(Object::toString).collect(Collectors.toList());
        ArrayList defaults = new ArrayList(list);
        StringListBuilder result = builder.entryBuilder().startStrList((ITextComponent)name, list).setTooltip(property.getTooltip()).setDefaultValue(defaults).setSaveConsumer(arg_0 -> value.set(arg_0));
        if (validator != null) {
            result.setCellErrorSupplier(validator);
        }
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static <T extends Enum<T>> EnumListEntry<T> createEnumList(@Nonnull ConfigBuilder builder, @Nonnull Class<T> clazz, @Nonnull ForgeConfigSpec.EnumValue<T> value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        IFormattableTextComponent name = property.getConfigName();
        EnumSelectorBuilder result = builder.entryBuilder().startEnumSelector((ITextComponent)name, clazz, (Enum)value.get()).setTooltip(property.getTooltip()).setDefaultValue((Enum)value.get()).setSaveConsumer(arg_0 -> value.set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static IntegerSliderEntry createIntegerSlider(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.IntValue value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        IFormattableTextComponent name = property.getConfigName();
        int min = (Integer)property.getMinValue();
        int max = (Integer)property.getMaxValue();
        IntSliderBuilder result = builder.entryBuilder().startIntSlider((ITextComponent)name, ((Integer)value.get()).intValue(), min, max).setTooltip(property.getTooltip()).setDefaultValue(((Integer)value.get()).intValue()).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)value).set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    private static ITextComponent transformText(@Nonnull String key, @Nullable TextFormatting color) {
        TranslationTextComponent result = new TranslationTextComponent(key);
        if (color != null) {
            String text = color + new TranslationTextComponent(key).getString();
            result = new StringTextComponent(text);
        }
        return result;
    }
}

