/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.resource;

import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.orecruncher.lib.resource.ResourceAccessorBase;

@OnlyIn(value=Dist.CLIENT)
final class ResourceAccessorJar
extends ResourceAccessorBase {
    final String asset;

    public ResourceAccessorJar(@Nonnull String rootContainer, @Nonnull ResourceLocation location) {
        this(location, String.format("/assets/%s/%s/%s", rootContainer, location.func_110624_b(), location.func_110623_a()));
    }

    public ResourceAccessorJar(@Nonnull ResourceLocation location, @Nonnull String asset) {
        super(location);
        this.asset = asset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getAsset() {
        try (InputStream stream = ResourceAccessorJar.class.getResourceAsStream(this.asset);){
            if (stream == null) return null;
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        catch (Throwable t) {
            this.logError(t);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", super.toString(), this.asset);
    }
}

