/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.NPCRendererHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.CustomEntities;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiButtonYesNo;
import noppes.npcs.shared.client.gui.components.GuiCustomScroll;
import noppes.npcs.shared.client.gui.components.GuiLabel;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiCreationEntities
extends GuiCreationScreenInterface
implements ICustomScrollListener {
    private List<EntityType<? extends Entity>> types;
    private GuiCustomScroll scroll;
    private boolean resetToSelected = true;

    public GuiCreationEntities(EntityNPCInterface npc) {
        super(npc);
        this.types = GuiCreationEntities.getAllEntities(npc.field_70170_p);
        Collections.sort(this.types, Comparator.comparing(t -> t.func_210760_d().toLowerCase()));
        this.active = 1;
        this.xOffset = 60;
    }

    private static List<EntityType<? extends Entity>> getAllEntities(World level) {
        ArrayList<EntityType<? extends Entity>> data = new ArrayList<EntityType<? extends Entity>>();
        for (EntityType ent : ForgeRegistries.ENTITIES.getValues()) {
            try {
                Entity e = ent.func_200721_a(level);
                if (e == null) continue;
                if (LivingEntity.class.isAssignableFrom(e.getClass())) {
                    data.add((EntityType<? extends Entity>)ent);
                }
                e.func_70106_y();
                e.field_70128_L = true;
            }
            catch (Exception exception) {}
        }
        return data;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addButton(new GuiButtonNop((IGuiInterface)this, 10, this.guiLeft, this.guiTop + 46, 120, 20, "Reset To NPC", button -> {
            this.playerdata.setEntity((String)null);
            this.npc.display.setSkinTexture("customnpcs:textures/entity/humanmale/steve.png");
            this.resetToSelected = true;
            this.func_231160_c_();
        }));
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setUnsortedList(this.types.stream().map(EntityType::func_210760_d).collect(Collectors.toList()));
        }
        this.scroll.guiLeft = this.guiLeft;
        this.scroll.guiTop = this.guiTop + 68;
        this.scroll.func_231149_a_(120, this.imageHeight - 96);
        int index = -1;
        EntityType<? extends CreatureEntity> selectedType = CustomEntities.entityCustomNpc;
        if (this.entity != null) {
            for (int i = 0; i < this.types.size(); ++i) {
                EntityType<? extends Entity> type = this.types.get(i);
                if (type != this.entity.func_200600_R()) continue;
                index = i;
                selectedType = type;
                break;
            }
        }
        if (index >= 0) {
            this.scroll.setSelectedIndex(index);
        } else {
            this.scroll.setSelected("entity.customnpcs.customnpc");
        }
        if (this.resetToSelected) {
            this.scroll.scrollTo(this.scroll.getSelected());
            this.resetToSelected = false;
        }
        this.addScroll(this.scroll);
        this.addLabel(new GuiLabel(110, "gui.simpleRenderer", this.guiLeft + 124, this.guiTop + 5, 0xFF0000));
        this.addButton(new GuiButtonYesNo((IGuiInterface)this, 110, this.guiLeft + 260, this.guiTop, this.playerdata.simpleRender, b -> {
            this.playerdata.simpleRender = ((GuiButtonYesNo)b).getBoolean();
        }));
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        String selected = scroll.getSelected();
        if (selected.equals("entity.customnpcs.customnpc")) {
            this.playerdata.setEntity((String)null);
        } else {
            this.playerdata.setEntity(this.types.get(scroll.getSelectedIndex()).getRegistryName());
        }
        LivingEntity entity = this.playerdata.getEntity(this.npc);
        if (entity != null) {
            EntityRenderer render = this.field_230706_i_.func_175598_ae().func_78713_a((Entity)entity);
            if (render instanceof LivingRenderer && !NPCRendererHelper.getTexture(render, (Entity)entity).equals("minecraft:missingno")) {
                this.npc.display.setSkinTexture(NPCRendererHelper.getTexture(render, (Entity)entity));
            }
        } else {
            this.npc.display.setSkinTexture("customnpcs:textures/entity/humanmale/steve.png");
        }
        this.func_231160_c_();
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }
}

