/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.AnimationDataReader;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightMod;

public class AnimationManager
extends ReloadListener<Map<Integer, Map<Integer, StaticAnimation>>> {
    private final Map<Integer, Map<Integer, StaticAnimation>> animationById = Maps.newHashMap();
    private final Map<ResourceLocation, StaticAnimation> animationByName = Maps.newHashMap();
    private String modid;
    private int namespaceHash;
    private int counter = 0;

    public StaticAnimation findAnimationById(int namespaceId, int animationId) {
        Map<Integer, StaticAnimation> map;
        if (this.animationById.containsKey(namespaceId) && (map = this.animationById.get(namespaceId)).containsKey(animationId)) {
            return map.get(animationId);
        }
        throw new IllegalArgumentException("Unable to find animation. id: " + animationId + ", namespcae hash: " + namespaceId);
    }

    public StaticAnimation findAnimationByPath(String resourceLocation) {
        ResourceLocation rl = new ResourceLocation(resourceLocation);
        if (this.animationByName.containsKey(rl)) {
            return this.animationByName.get(rl);
        }
        throw new IllegalArgumentException("Unable to find animation: " + rl);
    }

    public void registerAnimations() {
        HashMap registryMap = Maps.newHashMap();
        ModLoader.get().postEvent((Event)new AnimationRegistryEvent(registryMap));
        registryMap.entrySet().forEach(entry -> {
            this.modid = (String)entry.getKey();
            this.namespaceHash = this.modid.hashCode();
            this.animationById.put(this.namespaceHash, Maps.newHashMap());
            this.counter = 0;
            ((Runnable)entry.getValue()).run();
        });
    }

    public void loadAnimationsInit(IResourceManager resourceManager) {
        this.animationById.values().forEach(map -> map.values().forEach(animation -> {
            animation.loadAnimation(resourceManager);
            this.setAnimationProperties(resourceManager, (StaticAnimation)animation);
        }));
    }

    protected Map<Integer, Map<Integer, StaticAnimation>> prepare(IResourceManager resourceManager, IProfiler profilerIn) {
        if (EpicFightMod.isPhysicalClient()) {
            this.animationById.values().forEach(map -> map.values().forEach(animation -> this.setAnimationProperties(resourceManager, (StaticAnimation)animation)));
        }
        Animations.buildClient();
        return this.animationById;
    }

    protected void apply(Map<Integer, Map<Integer, StaticAnimation>> objectIn, IResourceManager resourceManager, IProfiler profilerIn) {
        objectIn.values().forEach(map -> map.values().forEach(animation -> animation.loadAnimation(resourceManager)));
    }

    private void setAnimationProperties(IResourceManager resourceManager, StaticAnimation animation) {
        ResourceLocation dataLocation;
        if (resourceManager == null) {
            return;
        }
        ResourceLocation location = animation.getLocation();
        String path = location.func_110623_a();
        int last = location.func_110623_a().lastIndexOf(47);
        if (last > 0 && resourceManager.func_219533_b(dataLocation = new ResourceLocation(location.func_110624_b(), String.format("%s/data%s.json", path.substring(0, last), path.substring(last))))) {
            try {
                AnimationDataReader.readAndApply(animation, resourceManager.func_199002_a(dataLocation));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getModid() {
        return this.modid;
    }

    public int getNamespaceHash() {
        return this.namespaceHash;
    }

    public int getIdCounter() {
        return this.counter++;
    }

    public Map<Integer, StaticAnimation> getIdMap() {
        return this.animationById.get(this.namespaceHash);
    }

    public Map<ResourceLocation, StaticAnimation> getNameMap() {
        return this.animationByName;
    }
}

