/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.server.ServerWorld;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.ValueCorrector;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AirSlashAnimation
extends AttackAnimation {
    public AirSlashAnimation(float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, String index, String path, Model model) {
        this(convertTime, antic, antic, contact, recovery, true, collider, index, path, model);
    }

    public AirSlashAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, boolean directional, @Nullable Collider collider, String index, String path, Model model) {
        super(convertTime, antic, preDelay, contact, recovery, collider, index, path, model);
        if (directional) {
            this.addProperty(AnimationProperty.AttackAnimationProperty.ROTATE_X, Boolean.valueOf(true));
        }
        this.addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE, ValueCorrector.multiplier(1.5f));
        this.addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, Float.valueOf(0.5f));
        this.addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, Boolean.valueOf(false));
        this.addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, Boolean.valueOf(true));
        this.stateSpectrumBlueprint.addStateRemoveOld(EntityState.TURNING_LOCKED, true);
    }

    @Override
    protected void spawnHitParticle(ServerWorld world, LivingEntityPatch<?> attackerpatch, Entity hit, AttackAnimation.Phase phase) {
        super.spawnHitParticle(world, attackerpatch, hit, phase);
        world.func_195598_a((IParticleData)ParticleTypes.field_197614_g, hit.func_226277_ct_(), hit.func_226278_cu_(), hit.func_226281_cx_(), 15, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public boolean isBasicAttackAnimation() {
        return true;
    }
}

