/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fml.RegistryObject;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.ExtraDamageType;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.AttackEndEvent;
import yesman.epicfight.world.entity.eventlistener.DealtDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class AttackAnimation
extends ActionAnimation {
    protected static final AnimationProperty.ActionAnimationCoordSetter COMMON_COORD_SETTER = (self, entitypatch, transformSheet) -> {
        LivingEntity attackTarget = entitypatch.getTarget();
        if (!self.getRealAnimation().getProperty(AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
            TransformSheet transform = self.getTransfroms().get("Root").copyAll();
            Keyframe[] keyframes = transform.getKeyframes();
            int startFrame = 0;
            int endFrame = transform.getKeyframes().length - 1;
            Vec3f keyLast = keyframes[endFrame].transform().translation();
            Vector3d pos = ((LivingEntity)entitypatch.getOriginal()).func_174824_e(1.0f);
            Vector3d targetpos = attackTarget.func_213303_ch();
            float horizontalDistance = Math.max((float)MathUtils.horizontalDistance(targetpos.func_178788_d(pos)) - (attackTarget.func_213311_cf() + ((LivingEntity)entitypatch.getOriginal()).func_213311_cf()) * 0.75f, 0.0f);
            Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
            float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
            for (int i = startFrame; i <= endFrame; ++i) {
                Vec3f translation = keyframes[i].transform().translation();
                translation.z *= scale;
            }
            transformSheet.readFrom(transform);
        } else {
            transformSheet.readFrom(self.getTransfroms().get("Root"));
        }
    };
    public final Phase[] phases;

    public AttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, String index, String path, Model model) {
        this(convertTime, path, model, new Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, index, collider));
    }

    public AttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, Hand hand, @Nullable Collider collider, String index, String path, Model model) {
        this(convertTime, path, model, new Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, hand, index, collider));
    }

    public AttackAnimation(float convertTime, String path, Model model, Phase ... phases) {
        super(convertTime, path, model);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, COMMON_COORD_SETTER);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, COMMON_COORD_SETTER);
        this.addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, Boolean.valueOf(true));
        this.phases = phases;
        this.stateSpectrumBlueprint.clear();
        for (Phase phase : phases) {
            float preDelay = phase.preDelay;
            if (preDelay == 0.0f) {
                preDelay += 0.01f;
            }
            this.stateSpectrumBlueprint.newTimePair(phase.start, preDelay).addState(EntityState.PHASE_LEVEL, 1).newTimePair(phase.start, phase.contact + 0.01f).addState(EntityState.CAN_SKILL_EXECUTION, false).newTimePair(phase.start, phase.recovery).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.CAN_BASIC_ATTACK, false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, true).newTimePair(phase.antic, phase.recovery).addState(EntityState.TURNING_LOCKED, true).newTimePair(preDelay, phase.contact + 0.01f).addState(EntityState.ATTACKING, true).addState(EntityState.PHASE_LEVEL, 2).newTimePair(phase.contact + 0.01f, phase.end).addState(EntityState.PHASE_LEVEL, 3);
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (!entitypatch.isLogicalClient()) {
            AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this);
            float elapsedTime = player.getElapsedTime();
            float prevElapsedTime = player.getPrevElapsedTime();
            EntityState state = this.getState(elapsedTime);
            EntityState prevState = this.getState(prevElapsedTime);
            Phase phase = this.getPhaseByTime(elapsedTime);
            if (state.getLevel() == 1 && !state.turningLocked()) {
                if (entitypatch instanceof MobPatch) {
                    ((MobEntity)entitypatch.getOriginal()).func_70661_as().func_75499_g();
                    ((LivingEntity)entitypatch.getOriginal()).field_70733_aJ = 2.0f;
                    LivingEntity target = entitypatch.getTarget();
                    if (target != null) {
                        entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
                    }
                }
            } else if (prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) {
                if (!prevState.attacking()) {
                    entitypatch.playSound(this.getSwingSound(entitypatch, phase), 0.0f, 0.0f);
                    entitypatch.currentlyAttackedEntity.clear();
                }
                this.hurtCollidingEntities(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
            }
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, boolean isEnd) {
        MobEntity entity;
        super.end(entitypatch, isEnd);
        if (entitypatch instanceof ServerPlayerPatch && isEnd) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)entitypatch;
            playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, new AttackEndEvent(playerpatch, entitypatch.currentlyAttackedEntity, this.getId()));
        }
        entitypatch.currentlyAttackedEntity.clear();
        if (entitypatch instanceof HumanoidMobPatch && entitypatch.isLogicalClient() && (entity = (MobEntity)entitypatch.getOriginal()).func_70638_az() != null && !entity.func_70638_az().func_70089_S()) {
            entity.func_70624_b((LivingEntity)null);
        }
    }

    public void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, Phase phase) {
        Collider collider = this.getCollider(entitypatch, elapsedTime);
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature().initializeTransform();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List<Entity> list = collider.updateAndSelectCollideEntity(entitypatch, this, prevPoseTime, poseTime, phase.getColliderJointName(), this.getPlaySpeed(entitypatch));
        if (list.size() > 0) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            boolean flag1 = true;
            int maxStrikes = this.getMaxStrikes(entitypatch, phase);
            while (entitypatch.currentlyAttackedEntity.size() < maxStrikes && hitEntities.next()) {
                Entity e = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(e);
                if (entitypatch.currentlyAttackedEntity.contains(trueEntity) || entitypatch.isTeammate(e) || !(e instanceof LivingEntity) && !(e instanceof PartEntity) || !entity.func_70685_l(e)) continue;
                ExtendedDamageSource source = this.getExtendedDamageSource(entitypatch, e, phase);
                AttackResult attackResult = entitypatch.tryHarm(e, source, this.getDamageTo(entitypatch, trueEntity, phase, source));
                boolean count = attackResult.resultType.count();
                if (attackResult.resultType.dealtDamage()) {
                    int temp = e.field_70172_ad;
                    trueEntity.field_70172_ad = 0;
                    boolean attackSuccess = e.func_70097_a((DamageSource)source, attackResult.damage);
                    trueEntity.field_70172_ad = temp;
                    count = attackSuccess || trueEntity.func_184583_d((DamageSource)source);
                    entitypatch.onHurtSomeone(e, phase.hand, source, attackResult.damage, attackSuccess);
                    if (attackSuccess) {
                        if (entitypatch instanceof ServerPlayerPatch) {
                            ServerPlayerPatch playerpatch = (ServerPlayerPatch)entitypatch;
                            playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, new DealtDamageEvent<ServerPlayerPatch>(playerpatch, trueEntity, source, attackResult.damage));
                        }
                        if (flag1 && entitypatch instanceof PlayerPatch) {
                            entity.func_184586_b(phase.hand).func_77961_a(trueEntity, (PlayerEntity)entity);
                            flag1 = false;
                        }
                        e.field_70170_p.func_184148_a(null, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), this.getHitSound(entitypatch, phase), e.func_184176_by(), 1.0f, 1.0f);
                        this.spawnHitParticle((ServerWorld)e.field_70170_p, entitypatch, e, phase);
                    }
                }
                if (!count) continue;
                entitypatch.currentlyAttackedEntity.add(trueEntity);
            }
        }
    }

    @Override
    protected void onLoaded() {
        if (!this.getProperty(AnimationProperty.AttackAnimationProperty.LOCK_ROTATION).orElse(false).booleanValue()) {
            this.stateSpectrumBlueprint.newTimePair(0.0f, Float.MAX_VALUE).addStateRemoveOld(EntityState.TURNING_LOCKED, false);
        }
        super.onLoaded();
    }

    public Collider getCollider(LivingEntityPatch<?> entitypatch, float elapsedTime) {
        Phase phase = this.getPhaseByTime(elapsedTime);
        return phase.collider != null ? phase.collider : entitypatch.getColliderMatching(phase.hand);
    }

    public LivingEntity getTrueEntity(Entity entity) {
        Entity parentEntity;
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        if (entity instanceof PartEntity && (parentEntity = ((PartEntity)entity).getParent()) instanceof LivingEntity) {
            return (LivingEntity)parentEntity;
        }
        return null;
    }

    protected int getMaxStrikes(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES).map(valueCorrector -> Float.valueOf(valueCorrector.getTotalValue(entitypatch.getMaxStrikes(phase.hand)))).orElse(Float.valueOf(entitypatch.getMaxStrikes(phase.hand))).intValue();
    }

    protected float getDamageTo(LivingEntityPatch<?> entitypatch, LivingEntity target, Phase phase, ExtendedDamageSource source) {
        float totalDamage = phase.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE).map(valueCorrector -> Float.valueOf(valueCorrector.getTotalValue(entitypatch.getDamageTo((Entity)target, source, phase.hand)))).orElse(Float.valueOf(entitypatch.getDamageTo((Entity)target, source, phase.hand))).floatValue();
        ExtraDamageType extraCalculator = phase.getProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE).orElse(null);
        if (extraCalculator != null) {
            totalDamage += extraCalculator.get((LivingEntity)entitypatch.getOriginal(), target);
        }
        return totalDamage;
    }

    protected SoundEvent getSwingSound(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND).orElse(entitypatch.getSwingSound(phase.hand));
    }

    protected SoundEvent getHitSound(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND).orElse(entitypatch.getWeaponHitSound(phase.hand));
    }

    protected ExtendedDamageSource getExtendedDamageSource(LivingEntityPatch<?> entitypatch, Entity target, Phase phase) {
        ExtendedDamageSource.StunType stunType = phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).orElse(ExtendedDamageSource.StunType.SHORT);
        ExtendedDamageSource extendedSource = entitypatch.getDamageSource(stunType, this, phase.hand);
        phase.getProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION).ifPresent(opt -> extendedSource.setArmorNegation(opt.getTotalValue(extendedSource.getArmorNegation())));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.IMPACT).ifPresent(opt -> extendedSource.setImpact(opt.getTotalValue(extendedSource.getImpact())));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.FINISHER).ifPresent(opt -> extendedSource.setFinisher((boolean)opt));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_LOCATION_PROVIDER).ifPresent(opt -> extendedSource.setInitialPosition((Vector3d)opt.apply(entitypatch)));
        return extendedSource;
    }

    protected void spawnHitParticle(ServerWorld world, LivingEntityPatch<?> attacker, Entity hit, Phase phase) {
        Optional<RegistryObject<HitParticleType>> particleOptional = phase.getProperty(AnimationProperty.AttackPhaseProperty.PARTICLE);
        HitParticleType particle = particleOptional.isPresent() ? (HitParticleType)particleOptional.get().get() : attacker.getWeaponHitParticle(phase.hand);
        particle.spawnParticleWithArgument(world, null, null, hit, (Entity)attacker.getOriginal());
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = super.getPoseByTime(entitypatch, time, partialTicks);
        this.getProperty(AnimationProperty.AttackAnimationProperty.ROTATE_X).ifPresent(flag -> {
            if (flag.booleanValue()) {
                float pitch = entitypatch.getAttackDirectionPitch();
                JointTransform chest = pose.getOrDefaultTransform("Chest");
                chest.frontResult(JointTransform.getRotation(MathUtils.quaternionFromDegree(Vector3f.field_229179_b_, -pitch)), OpenMatrix4f::mulAsOriginFront);
                if (entitypatch instanceof PlayerPatch) {
                    JointTransform head = pose.getOrDefaultTransform("Head");
                    MathUtils.mulQuaternion(MathUtils.quaternionFromDegree(Vector3f.field_229179_b_, pitch), head.rotation(), head.rotation());
                }
            }
        });
        return pose;
    }

    @Override
    public float getPlaySpeed(LivingEntityPatch<?> entitypatch) {
        if (this.getProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED).isPresent()) {
            return super.getPlaySpeed(entitypatch);
        }
        if (entitypatch instanceof PlayerPatch) {
            Phase phase = this.getPhaseByTime(((Animator)entitypatch.getAnimator()).getPlayerFor(this).getElapsedTime());
            float speedFactor = this.getProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR).orElse(Float.valueOf(1.0f)).floatValue();
            Optional<Float> property = this.getProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED);
            float correctedSpeed = property.map(value -> Float.valueOf(((PlayerPatch)entitypatch).getAttackSpeed(phase.hand) / value.floatValue())).orElse(Float.valueOf(this.totalTime * ((PlayerPatch)entitypatch).getAttackSpeed(phase.hand))).floatValue();
            correctedSpeed = (float)Math.round(correctedSpeed * 1000.0f) / 1000.0f;
            return 1.0f + (correctedSpeed - 1.0f) * speedFactor;
        }
        return 1.0f;
    }

    public <V> AttackAnimation addProperty(AnimationProperty.AttackAnimationProperty<V> propertyType, V value) {
        this.properties.put(propertyType, value);
        return this;
    }

    public <V> AttackAnimation addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value) {
        return this.addProperty(propertyType, value, 0);
    }

    public <V> AttackAnimation addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value, int index) {
        this.phases[index].addProperty(propertyType, value);
        return this;
    }

    public String getPathIndexByTime(float elapsedTime) {
        return this.getPhaseByTime((float)elapsedTime).jointName;
    }

    public Phase getPhaseByTime(float elapsedTime) {
        Phase currentPhase = null;
        Phase[] phaseArray = this.phases;
        int n = phaseArray.length;
        for (int i = 0; i < n; ++i) {
            Phase phase;
            currentPhase = phase = phaseArray[i];
            if (phase.end > elapsedTime) break;
        }
        return currentPhase;
    }

    @Deprecated
    public void changeCollider(Collider newCollider, int index) {
        this.phases[index].collider = newCollider;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(MatrixStack poseStack, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, float playTime, float partialTicks) {
        AnimationPlayer animPlayer = ((Animator)entitypatch.getAnimator()).getPlayerFor(this);
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        this.getCollider(entitypatch, elapsedTime).draw(poseStack, buffer, entitypatch, this, prevElapsedTime, elapsedTime, partialTicks, this.getPlaySpeed(entitypatch));
    }

    public static class Phase {
        protected final Map<AnimationProperty.AttackPhaseProperty<?>, Object> properties = Maps.newHashMap();
        protected final float start;
        protected final float antic;
        protected final float preDelay;
        protected final float contact;
        protected final float recovery;
        protected final float end;
        protected final String jointName;
        protected final Hand hand;
        protected Collider collider;

        public Phase(float start, float antic, float contact, float recovery, float end, String jointName, Collider collider) {
            this(start, antic, contact, recovery, end, Hand.MAIN_HAND, jointName, collider);
        }

        public Phase(float start, float antic, float contact, float recovery, float end, Hand hand, String jointName, Collider collider) {
            this(start, antic, antic, contact, recovery, end, hand, jointName, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, String jointName, Collider collider) {
            this(start, antic, preDelay, contact, recovery, end, Hand.MAIN_HAND, jointName, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, Hand hand, String jointName, Collider collider) {
            this.start = start;
            this.antic = antic;
            this.preDelay = preDelay;
            this.contact = contact;
            this.recovery = recovery;
            this.end = end;
            this.collider = collider;
            this.jointName = jointName;
            this.hand = hand;
        }

        public <V> Phase addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value) {
            this.properties.put(propertyType, value);
            return this;
        }

        public void addProperties(Set<Map.Entry<AnimationProperty.AttackPhaseProperty<?>, Object>> set) {
            for (Map.Entry<AnimationProperty.AttackPhaseProperty<?>, Object> entry : set) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }

        protected <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyType) {
            return Optional.ofNullable(this.properties.get(propertyType));
        }

        public String getColliderJointName() {
            return this.jointName;
        }

        public Hand getHand() {
            return this.hand;
        }
    }
}

