/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.EntityDamageSource;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPRotatePlayerYaw;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class DodgeAnimation
extends ActionAnimation {
    private final EntitySize size;

    public DodgeAnimation(float convertTime, String path, float width, float height, Model model) {
        this(convertTime, 0.0f, path, width, height, model);
    }

    public DodgeAnimation(float convertTime, float delayTime, String path, float width, float height, Model model) {
        super(convertTime, delayTime, path, model);
        this.size = width > 0.0f || height > 0.0f ? EntitySize.func_220314_b((float)width, (float)height) : null;
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, 10.0f).addState(EntityState.TURNING_LOCKED, true).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.CAN_BASIC_ATTACK, false).addState(EntityState.CAN_SKILL_EXECUTION, false).addState(EntityState.INACTION, true).newTimePair(delayTime, Float.MAX_VALUE).addState(EntityState.INVULNERABILITY_PREDICATE, damagesource -> {
            if (damagesource instanceof EntityDamageSource && !damagesource.func_94541_c() && !damagesource.func_82725_o() && !damagesource.func_76357_e()) {
                return true;
            }
            return false;
        });
        this.addProperty(AnimationProperty.ActionAnimationProperty.AFFECT_SPEED, Boolean.valueOf(true));
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (this.size != null) {
            entitypatch.resetSize(this.size);
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, boolean isEnd) {
        super.end(entitypatch, isEnd);
        if (this.size != null) {
            ((LivingEntity)entitypatch.getOriginal()).func_213323_x_();
        }
        if (entitypatch.isLogicalClient() && entitypatch instanceof LocalPlayerPatch) {
            ((LocalPlayerPatch)entitypatch).changeYaw(0.0f);
            EpicFightNetworkManager.sendToServer(new CPRotatePlayerYaw(0.0f));
        }
    }
}

