/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import net.minecraft.entity.LivingEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MirrorAnimation
extends StaticAnimation {
    public StaticAnimation original;
    public StaticAnimation mirror;

    public MirrorAnimation(float convertTime, boolean repeatPlay, String path1, String path2, Model model) {
        super(0.0f, false, path1, model);
        this.original = new StaticAnimation(convertTime, repeatPlay, path1, model, true);
        this.mirror = new StaticAnimation(convertTime, repeatPlay, path2, model, true);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        StaticAnimation animation = this.checkHandAndReturnAnimation(((LivingEntity)entitypatch.getOriginal()).func_184600_cs());
        entitypatch.getClientAnimator().playAnimation(animation, 0.0f);
    }

    @Override
    public void loadAnimation(IResourceManager resourceManager) {
        MirrorAnimation.load(resourceManager, this.original);
        MirrorAnimation.load(resourceManager, this.mirror);
    }

    @Override
    public boolean isMetaAnimation() {
        return true;
    }

    @Override
    public <V> StaticAnimation addProperty(AnimationProperty.StaticAnimationProperty<V> propertyType, V value) {
        this.original.properties.put(propertyType, value);
        this.mirror.properties.put(propertyType, value);
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.original.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.LOWEST);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.LayerType getLayerType() {
        return this.original.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER);
    }

    private StaticAnimation checkHandAndReturnAnimation(Hand hand) {
        if (hand == Hand.OFF_HAND) {
            return this.mirror;
        }
        return this.original;
    }
}

