/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.DamageSource;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.utils.TypeFlexibleHashMap;

public class StateSpectrum {
    private final Set<StatesInTime> timePairs = Sets.newHashSet();

    void readFrom(Blueprint blueprint) {
        this.timePairs.clear();
        this.timePairs.addAll(blueprint.timePairs);
    }

    public EntityState bindStates(float time) {
        TypeFlexibleHashMap<EntityState.StateFactor<?>> stateMap = this.getStateMap(time);
        boolean turningLocked = stateMap.getOrDefault(EntityState.TURNING_LOCKED, EntityState.TURNING_LOCKED.getDefaultVal());
        boolean movementLocked = stateMap.getOrDefault(EntityState.MOVEMENT_LOCKED, EntityState.MOVEMENT_LOCKED.getDefaultVal());
        boolean attacking = stateMap.getOrDefault(EntityState.ATTACKING, EntityState.ATTACKING.getDefaultVal());
        boolean canBasicAttack = stateMap.getOrDefault(EntityState.CAN_BASIC_ATTACK, EntityState.CAN_BASIC_ATTACK.getDefaultVal());
        boolean canSkillExecution = stateMap.getOrDefault(EntityState.CAN_SKILL_EXECUTION, EntityState.CAN_SKILL_EXECUTION.getDefaultVal());
        boolean inaction = stateMap.getOrDefault(EntityState.INACTION, EntityState.INACTION.getDefaultVal());
        boolean hurt = stateMap.getOrDefault(EntityState.HURT, EntityState.HURT.getDefaultVal());
        boolean knockdown = stateMap.getOrDefault(EntityState.KNOCKDOWN, EntityState.KNOCKDOWN.getDefaultVal());
        boolean counterAttackable = stateMap.getOrDefault(EntityState.COUNTER_ATTACKABLE, EntityState.COUNTER_ATTACKABLE.getDefaultVal());
        int phaseLevel = stateMap.getOrDefault(EntityState.PHASE_LEVEL, EntityState.PHASE_LEVEL.getDefaultVal());
        Function<DamageSource, Boolean> invulnerabilityPredicate = stateMap.getOrDefault(EntityState.INVULNERABILITY_PREDICATE, EntityState.INVULNERABILITY_PREDICATE.getDefaultVal());
        return new EntityState(turningLocked, movementLocked, attacking, canBasicAttack, canSkillExecution, inaction, hurt, knockdown, counterAttackable, phaseLevel, invulnerabilityPredicate);
    }

    private TypeFlexibleHashMap<EntityState.StateFactor<?>> getStateMap(float time) {
        TypeFlexibleHashMap stateMap = new TypeFlexibleHashMap();
        for (StatesInTime state : this.timePairs) {
            if (!(state.start <= time) || !(state.end > time)) continue;
            for (Pair<EntityState.StateFactor<?>, ?> timePair : state.states) {
                stateMap.put(timePair.getFirst(), timePair.getSecond());
            }
        }
        return stateMap;
    }

    static class Blueprint {
        StatesInTime currentState;
        Set<StatesInTime> timePairs = Sets.newHashSet();

        Blueprint() {
        }

        public Blueprint newTimePair(float start, float end) {
            this.currentState = new StatesInTime(start, end);
            this.timePairs.add(this.currentState);
            return this;
        }

        public <T> Blueprint addState(EntityState.StateFactor<T> factor, T val) {
            this.currentState.states.add(Pair.of(factor, val));
            return this;
        }

        public <T> Blueprint addStateRemoveOld(EntityState.StateFactor<T> factor, T val) {
            for (StatesInTime timePair : this.timePairs) {
                timePair.states.removeIf(pair -> ((EntityState.StateFactor)pair.getFirst()).equals(factor));
            }
            return this.addState(factor, val);
        }

        public Blueprint clear() {
            this.currentState = null;
            this.timePairs.clear();
            return this;
        }
    }

    static class StatesInTime {
        float start;
        float end;
        Set<Pair<EntityState.StateFactor<?>, ?>> states;

        public StatesInTime(float start, float end) {
            this.start = start;
            this.end = end;
            this.states = Sets.newHashSet();
        }

        public <T> StatesInTime addState(EntityState.StateFactor<T> factor, T val) {
            this.states.add(Pair.of(factor, val));
            return this;
        }
    }
}

