/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.procedural;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.procedural.IKInfo;
import yesman.epicfight.api.animation.types.procedural.ProceduralAnimation;
import yesman.epicfight.api.animation.types.procedural.TipPointAnimation;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.RenderingTool;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;

public class EnderDragonDynamicActionAnimation
extends ActionAnimation
implements ProceduralAnimation {
    private final IKInfo[] ikInfos;
    private Map<String, TransformSheet> tipPointTransform;

    public EnderDragonDynamicActionAnimation(float convertTime, String path, Model model, IKInfo[] ikInfos) {
        super(convertTime, path, model);
        this.ikInfos = ikInfos;
    }

    @Override
    public void loadAnimation(IResourceManager resourceManager) {
        EnderDragonDynamicActionAnimation.loadBothSide(resourceManager, this);
        this.tipPointTransform = Maps.newHashMap();
        this.setIKInfo(this.ikInfos, this.getTransfroms(), this.tipPointTransform, this.getModel().getArmature(), true, true);
        this.onLoaded();
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = super.getPoseByTime(entitypatch, time, partialTicks);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            float x = (float)((LivingEntity)entitypatch.getOriginal()).func_226277_ct_();
            float y = (float)((LivingEntity)entitypatch.getOriginal()).func_226278_cu_();
            float z = (float)((LivingEntity)entitypatch.getOriginal()).func_226281_cx_();
            float xo = (float)((LivingEntity)entitypatch.getOriginal()).field_70169_q;
            float yo = (float)((LivingEntity)entitypatch.getOriginal()).field_70167_r;
            float zo = (float)((LivingEntity)entitypatch.getOriginal()).field_70166_s;
            OpenMatrix4f toModelPos = OpenMatrix4f.mul(OpenMatrix4f.translate(new Vec3f(xo + (x - xo) * partialTicks, yo + (y - yo) * partialTicks, zo + (z - zo) * partialTicks), new OpenMatrix4f(), null), entitypatch.getModelMatrix(partialTicks), null).invert();
            this.correctRootRotation(pose.getJointTransformData().get("Root"), enderdragonpatch, partialTicks);
            for (IKInfo ikInfo : this.ikInfos) {
                TipPointAnimation tipAnim = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint);
                JointTransform jt = tipAnim.getTipTransform(partialTicks);
                Vec3f jointModelpos = OpenMatrix4f.transform3v(toModelPos, jt.translation(), null);
                this.applyFabrikToJoint(jointModelpos.multiply(-1.0f, 1.0f, -1.0f), pose, this.getModel().getArmature(), ikInfo.startJoint, ikInfo.endJoint, jt.rotation());
            }
        }
        return pose;
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            Vector3d entitypos = ((EnderDragonEntity)enderdragonpatch.getOriginal()).func_213303_ch();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.field_72450_a, (float)entitypos.field_72448_b, (float)entitypos.field_72449_c), enderdragonpatch.getModelMatrix(1.0f), null);
            TransformSheet movementAnimation = ((Animator)enderdragonpatch.getAnimator()).getPlayerFor(this).getActionAnimationCoord();
            for (IKInfo ikInfo : this.ikInfos) {
                TransformSheet tipAnim = this.clipAnimation(this.tipPointTransform.get(ikInfo.endJoint), ikInfo);
                Keyframe[] keyframes = tipAnim.getKeyframes();
                Vec3f startpos = movementAnimation.getInterpolatedTranslation(0.0f);
                for (int i = 0; i < keyframes.length; ++i) {
                    Vec3f finalTargetpos;
                    Keyframe kf = keyframes[i];
                    Vec3f dynamicpos = movementAnimation.getInterpolatedTranslation(kf.time()).sub(startpos);
                    OpenMatrix4f.transform3v(OpenMatrix4f.createRotatorDeg(-90.0f, Vec3f.X_AXIS), dynamicpos, dynamicpos).multiply(-1.0f, 1.0f, -1.0f);
                    if (!ikInfo.clipAnimation || ikInfo.touchingGround[i]) {
                        Vec3f clipStart = kf.transform().translation().copy().multiply(-1.0f, 1.0f, -1.0f).add(dynamicpos).add(0.0f, 2.5f, 0.0f);
                        finalTargetpos = this.getRayCastedTipPosition(clipStart, toWorld, enderdragonpatch, 2.5f, ikInfo.rayLeastHeight);
                    } else {
                        Vec3f start = kf.transform().translation().copy().multiply(-1.0f, 1.0f, -1.0f).add(dynamicpos);
                        finalTargetpos = OpenMatrix4f.transform3v(toWorld, start, null);
                    }
                    kf.transform().translation().set(finalTargetpos);
                }
                enderdragonpatch.addTipPointAnimation(ikInfo.endJoint, keyframes[0].transform().translation(), tipAnim, ikInfo);
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            float elapsedTime = ((Animator)entitypatch.getAnimator()).getPlayerFor(this).getElapsedTime();
            for (IKInfo ikSetter : this.ikInfos) {
                TipPointAnimation tipAnim;
                if (!ikSetter.clipAnimation) continue;
                Keyframe[] keyframes = this.getTransfroms().get(ikSetter.endJoint).getKeyframes();
                float startTime = keyframes[ikSetter.startFrame].time();
                float endTime = keyframes[ikSetter.endFrame - 1].time();
                if (!(startTime <= elapsedTime) || !(elapsedTime < endTime) || (tipAnim = enderdragonpatch.getTipPointAnimation(ikSetter.endJoint)).isOnWorking()) continue;
                this.startSimple(ikSetter, tipAnim);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(MatrixStack poseStack, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, float playTime, float partialTicks) {
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            OpenMatrix4f modelmat = enderdragonpatch.getModelMatrix(partialTicks);
            LivingEntity originalEntity = (LivingEntity)entitypatch.getOriginal();
            Vector3d entitypos = originalEntity.func_213303_ch();
            float x = (float)entitypos.field_72450_a;
            float y = (float)entitypos.field_72448_b;
            float z = (float)entitypos.field_72449_c;
            float xo = (float)originalEntity.field_70169_q;
            float yo = (float)originalEntity.field_70167_r;
            float zo = (float)originalEntity.field_70166_s;
            OpenMatrix4f toModelPos = OpenMatrix4f.mul(OpenMatrix4f.createTranslation(xo + (x - xo) * partialTicks, yo + (y - yo) * partialTicks, zo + (z - zo) * partialTicks), modelmat, null).invert();
            for (IKInfo ikInfo : this.ikInfos) {
                IVertexBuilder vertexBuilder = buffer.getBuffer(EpicFightRenderTypes.debugQuads());
                Vec3f worldtargetpos = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint).getTargetPosition();
                Vec3f modeltargetpos = OpenMatrix4f.transform3v(toModelPos, worldtargetpos, null).multiply(-1.0f, 1.0f, -1.0f);
                RenderingTool.drawQuad(poseStack, vertexBuilder, modeltargetpos, 0.5f, 1.0f, 0.0f, 0.0f);
                Vec3f jointWorldPos = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint).getTipPosition(partialTicks);
                Vec3f jointModelpos = OpenMatrix4f.transform3v(toModelPos, jointWorldPos, null);
                RenderingTool.drawQuad(poseStack, vertexBuilder, jointModelpos.multiply(-1.0f, 1.0f, -1.0f), 0.4f, 0.0f, 0.0f, 1.0f);
                Pose pose = new Pose();
                for (String jointName : this.jointTransforms.keySet()) {
                    pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(playTime));
                }
            }
        }
    }
}

