/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.procedural;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.procedural.IKInfo;
import yesman.epicfight.api.animation.types.procedural.ProceduralAnimation;
import yesman.epicfight.api.animation.types.procedural.TipPointAnimation;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.FABRIK;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.RenderingTool;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.EnderDragonPatch;

public class EnderDraonWalkAnimation
extends StaticAnimation
implements ProceduralAnimation {
    private final IKInfo[] ikInfos;
    private Map<String, TransformSheet> tipPointTransform;

    public EnderDraonWalkAnimation(float convertTime, String path, Model model, IKInfo[] ikInfos) {
        super(convertTime, true, path, model);
        this.ikInfos = ikInfos;
    }

    @Override
    public void loadAnimation(IResourceManager resourceManager) {
        EnderDraonWalkAnimation.loadBothSide(resourceManager, this);
        this.tipPointTransform = Maps.newHashMap();
        this.setIKInfo(this.ikInfos, this.getTransfroms(), this.tipPointTransform, this.getModel().getArmature(), false, false);
        this.onLoaded();
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose pose = super.getPoseByTime(entitypatch, time, partialTicks);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            float x = (float)((LivingEntity)entitypatch.getOriginal()).func_226277_ct_();
            float y = (float)((LivingEntity)entitypatch.getOriginal()).func_226278_cu_();
            float z = (float)((LivingEntity)entitypatch.getOriginal()).func_226281_cx_();
            float xo = (float)((LivingEntity)entitypatch.getOriginal()).field_70169_q;
            float yo = (float)((LivingEntity)entitypatch.getOriginal()).field_70167_r;
            float zo = (float)((LivingEntity)entitypatch.getOriginal()).field_70166_s;
            OpenMatrix4f toModelPos = OpenMatrix4f.mul(OpenMatrix4f.translate(new Vec3f(xo + (x - xo) * partialTicks, yo + (y - yo) * partialTicks, zo + (z - zo) * partialTicks), new OpenMatrix4f(), null), entitypatch.getModelMatrix(partialTicks), null).invert();
            this.correctRootRotation(pose.getJointTransformData().get("Root"), enderdragonpatch, partialTicks);
            for (IKInfo ikInfo : this.ikInfos) {
                for (String jointName : ikInfo.pathToEndJoint) {
                    pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getKeyframes()[ikInfo.ikPose].transform().copy());
                }
                TipPointAnimation tipAnim = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint);
                JointTransform jt = tipAnim.getTipTransform(partialTicks);
                Vec3f jointModelpos = OpenMatrix4f.transform3v(toModelPos, jt.translation(), null);
                this.applyFabrikToJoint(jointModelpos.multiply(-1.0f, 1.0f, -1.0f), pose, this.getModel().getArmature(), ikInfo.startJoint, ikInfo.endJoint, jt.rotation());
            }
        }
        return pose;
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            Vector3d entitypos = ((EnderDragonEntity)enderdragonpatch.getOriginal()).func_213303_ch();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.field_72450_a, (float)entitypos.field_72448_b, (float)entitypos.field_72449_c), enderdragonpatch.getModelMatrix(1.0f), null);
            for (IKInfo ikInfo : this.ikInfos) {
                TransformSheet tipAnim = this.getFirstPart(this.tipPointTransform.get(ikInfo.endJoint));
                Keyframe[] keyframes = tipAnim.getKeyframes();
                JointTransform firstposeTransform = keyframes[0].transform();
                firstposeTransform.translation().multiply(-1.0f, 1.0f, -1.0f);
                if (!ikInfo.clipAnimation || ikInfo.touchingGround[0]) {
                    Vec3f rayResultPosition = this.getRayCastedTipPosition(firstposeTransform.translation().add(0.0f, 2.5f, 0.0f), toWorld, enderdragonpatch, 8.0f, ikInfo.rayLeastHeight);
                    firstposeTransform.translation().set(rayResultPosition);
                } else {
                    firstposeTransform.translation().set(OpenMatrix4f.transform3v(toWorld, firstposeTransform.translation(), null));
                }
                for (Keyframe keyframe : keyframes) {
                    keyframe.transform().translation().set(firstposeTransform.translation());
                }
                enderdragonpatch.addTipPointAnimation(ikInfo.endJoint, firstposeTransform.translation(), tipAnim, ikInfo);
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            if (((Animator)enderdragonpatch.getAnimator()).getPlayerFor(null).getAnimation() != this) {
                return;
            }
            Vector3d entitypos = ((EnderDragonEntity)enderdragonpatch.getOriginal()).func_213303_ch();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.field_72450_a, (float)entitypos.field_72448_b, (float)entitypos.field_72449_c), enderdragonpatch.getModelMatrix(1.0f), null);
            for (IKInfo ikInfo : this.ikInfos) {
                Vec3f footpos;
                TipPointAnimation tipAnim = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint);
                Vec3f clipStart = ikInfo.endpos.copy().add(0.0f, 2.5f, 0.0f).multiply(-1.0f, 1.0f, -1.0f);
                Vec3f finalTargetpos = this.getRayCastedTipPosition(clipStart, toWorld, enderdragonpatch, 8.0f, ikInfo.rayLeastHeight);
                TipPointAnimation opponentTipAnim = enderdragonpatch.getTipPointAnimation(ikInfo.opponentJoint);
                if (tipAnim.isOnWorking()) {
                    tipAnim.newTargetPosition(finalTargetpos);
                    continue;
                }
                if (opponentTipAnim.isOnWorking() || !((double)(footpos = tipAnim.getTipPosition(1.0f)).distanceSqr(finalTargetpos) > 15.0)) continue;
                this.startPartAnimation(ikInfo, tipAnim, this.clipAnimation(this.tipPointTransform.get(ikInfo.endJoint), ikInfo), finalTargetpos);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(MatrixStack poseStack, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, float playTime, float partialTicks) {
        if (entitypatch instanceof EnderDragonPatch) {
            EnderDragonPatch enderdragonpatch = (EnderDragonPatch)entitypatch;
            OpenMatrix4f modelmat = enderdragonpatch.getModelMatrix(partialTicks);
            LivingEntity originalEntity = (LivingEntity)entitypatch.getOriginal();
            Vector3d entitypos = originalEntity.func_213303_ch();
            float x = (float)entitypos.field_72450_a;
            float y = (float)entitypos.field_72448_b;
            float z = (float)entitypos.field_72449_c;
            float xo = (float)originalEntity.field_70169_q;
            float yo = (float)originalEntity.field_70167_r;
            float zo = (float)originalEntity.field_70166_s;
            OpenMatrix4f toModelPos = OpenMatrix4f.mul(OpenMatrix4f.createTranslation(xo + (x - xo) * partialTicks, yo + (y - yo) * partialTicks, zo + (z - zo) * partialTicks), modelmat, null).invert();
            for (IKInfo ikInfo : this.ikInfos) {
                IVertexBuilder vertexBuilder = buffer.getBuffer(EpicFightRenderTypes.debugQuads());
                Vec3f worldtargetpos = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint).getTargetPosition();
                Vec3f modeltargetpos = OpenMatrix4f.transform3v(toModelPos, worldtargetpos, null).multiply(-1.0f, 1.0f, -1.0f);
                RenderingTool.drawQuad(poseStack, vertexBuilder, modeltargetpos, 0.5f, 1.0f, 0.0f, 0.0f);
                Vec3f jointWorldPos = enderdragonpatch.getTipPointAnimation(ikInfo.endJoint).getTipPosition(partialTicks);
                Vec3f jointModelpos = OpenMatrix4f.transform3v(toModelPos, jointWorldPos, null).multiply(-1.0f, 1.0f, -1.0f);
                RenderingTool.drawQuad(poseStack, vertexBuilder, jointModelpos, 0.4f, 0.0f, 0.0f, 1.0f);
                Pose pose = new Pose();
                for (String jointName : this.jointTransforms.keySet()) {
                    pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(playTime));
                }
                for (String jointName : ikInfo.pathToEndJoint) {
                    pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getKeyframes()[ikInfo.ikPose].transform().copy());
                }
                FABRIK fabrik = new FABRIK(pose, this.getModel().getArmature(), ikInfo.startJoint, ikInfo.endJoint);
                fabrik.run(jointModelpos, 10);
                for (Vec3f vec : fabrik.getChainingPosition()) {
                    RenderingTool.drawCube(poseStack, vertexBuilder, vec, 0.3f, 0.0f, 1.0f, 0.0f);
                }
            }
        }
    }
}

