/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.VertexIndicator;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientModel
extends Model {
    protected Mesh mesh;
    protected RenderProperties properties;

    public ClientModel(ResourceLocation location) {
        this(location, null);
    }

    public ClientModel(ResourceLocation location, Mesh mesh) {
        super(location);
        this.mesh = mesh;
        this.properties = RenderProperties.DEFAULT;
    }

    public boolean loadMeshAndProperties(IResourceManager resourceManager) {
        JsonModelLoader loader = new JsonModelLoader(resourceManager, this.getLocation());
        if (loader.isValidSource()) {
            ResourceLocation parent = loader.getParent();
            if (parent == null) {
                this.mesh = loader.getMesh();
            } else {
                ClientModel model = (ClientModel)ClientModels.LOGICAL_CLIENT.get(parent);
                if (model == null) {
                    throw new IllegalStateException("the parent location " + parent + " not exists!");
                }
                this.mesh = ((ClientModel)ClientModels.LOGICAL_CLIENT.get(parent)).getMesh();
            }
            this.properties = loader.getRenderProperties();
            return true;
        }
        return false;
    }

    public RenderProperties getProperties() {
        return this.properties;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void drawRawModel(MatrixStack posetStack, IVertexBuilder builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord) {
        Matrix4f matrix4f = posetStack.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = posetStack.func_227866_c_().func_227872_b_();
        Mesh mesh = this.getMesh();
        for (VertexIndicator vi : mesh.vertexIndicators) {
            int pos = vi.position * 3;
            int norm = vi.normal * 3;
            int uv = vi.uv * 2;
            Vector4f posVec = new Vector4f(mesh.positions[pos], mesh.positions[pos + 1], mesh.positions[pos + 2], 1.0f);
            Vector3f normVec = new Vector3f(mesh.noramls[norm], mesh.noramls[norm + 1], mesh.noramls[norm + 2]);
            posVec.func_229372_a_(matrix4f);
            normVec.func_229188_a_(matrix3f);
            builder.func_225588_a_(posVec.func_195910_a(), posVec.func_195913_b(), posVec.func_195914_c(), r, g, b, a, mesh.uvs[uv], mesh.uvs[uv + 1], overlayCoord, packedLightIn, normVec.func_195899_a(), normVec.func_195900_b(), normVec.func_195902_c());
        }
    }

    public void drawAnimatedModel(MatrixStack posetStack, IVertexBuilder builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = posetStack.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = posetStack.func_227866_c_().func_227872_b_();
        OpenMatrix4f[] posesNoTranslation = new OpenMatrix4f[poses.length];
        Mesh mesh = this.getMesh();
        for (int i = 0; i < poses.length; ++i) {
            posesNoTranslation[i] = poses[i].removeTranslation();
        }
        for (VertexIndicator vi : mesh.vertexIndicators) {
            int pos = vi.position * 3;
            int norm = vi.normal * 3;
            int uv = vi.uv * 2;
            Vec4f position = new Vec4f(mesh.positions[pos], mesh.positions[pos + 1], mesh.positions[pos + 2], 1.0f);
            Vec4f normal = new Vec4f(mesh.noramls[norm], mesh.noramls[norm + 1], mesh.noramls[norm + 2], 1.0f);
            Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            Vec4f totalNorm = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            for (int i = 0; i < vi.joint.size(); ++i) {
                int jointIndex = vi.joint.get(i);
                int weightIndex = vi.weight.get(i);
                float weight = mesh.weights[weightIndex];
                Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], position, null).scale(weight), totalPos, totalPos);
                Vec4f.add(OpenMatrix4f.transform(posesNoTranslation[jointIndex], normal, null).scale(weight), totalNorm, totalNorm);
            }
            Vector4f posVec = new Vector4f(totalPos.x, totalPos.y, totalPos.z, 1.0f);
            Vector3f normVec = new Vector3f(totalNorm.x, totalNorm.y, totalNorm.z);
            posVec.func_229372_a_(matrix4f);
            normVec.func_229188_a_(matrix3f);
            builder.func_225588_a_(posVec.func_195910_a(), posVec.func_195913_b(), posVec.func_195914_c(), r, g, b, a, mesh.uvs[uv], mesh.uvs[uv + 1], overlayCoord, packedLightIn, normVec.func_195899_a(), normVec.func_195900_b(), normVec.func_195902_c());
        }
    }

    public void drawAnimatedModelNoTexture(MatrixStack posetStack, IVertexBuilder builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord, OpenMatrix4f[] poses) {
        Matrix4f matrix4f = posetStack.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = posetStack.func_227866_c_().func_227872_b_();
        OpenMatrix4f[] posesNoTranslation = new OpenMatrix4f[poses.length];
        Mesh mesh = this.getMesh();
        for (int i = 0; i < poses.length; ++i) {
            posesNoTranslation[i] = poses[i].removeTranslation();
        }
        for (VertexIndicator vi : mesh.vertexIndicators) {
            int pos = vi.position * 3;
            int norm = vi.normal * 3;
            Vec4f position = new Vec4f(mesh.positions[pos], mesh.positions[pos + 1], mesh.positions[pos + 2], 1.0f);
            Vec4f normal = new Vec4f(mesh.noramls[norm], mesh.noramls[norm + 1], mesh.noramls[norm + 2], 1.0f);
            Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            Vec4f totalNorm = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            for (int i = 0; i < vi.joint.size(); ++i) {
                int jointIndex = vi.joint.get(i);
                int weightIndex = vi.weight.get(i);
                float weight = mesh.weights[weightIndex];
                Vec4f.add(OpenMatrix4f.transform(poses[jointIndex], position, null).scale(weight), totalPos, totalPos);
                Vec4f.add(OpenMatrix4f.transform(posesNoTranslation[jointIndex], normal, null).scale(weight), totalNorm, totalNorm);
            }
            Vector4f posVec = new Vector4f(totalPos.x, totalPos.y, totalPos.z, 1.0f);
            Vector3f normVec = new Vector3f(totalNorm.x, totalNorm.y, totalNorm.z);
            posVec.func_229372_a_(matrix4f);
            normVec.func_229188_a_(matrix3f);
            builder.func_225582_a_((double)posVec.func_195910_a(), (double)posVec.func_195913_b(), (double)posVec.func_195914_c());
            builder.func_227885_a_(r, g, b, a);
            builder.func_227886_a_(packedLightIn);
            builder.func_181675_d();
        }
    }

    public static class RenderProperties {
        public static final RenderProperties DEFAULT = RenderProperties.builder().build();
        boolean isTransparent;

        public RenderProperties(Builder builder) {
            this.isTransparent = builder.isTransparent;
        }

        public boolean isTransparent() {
            return this.isTransparent;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            boolean isTransparent = false;

            public Builder transparency(boolean isTransparent) {
                this.isTransparent = isTransparent;
                return this;
            }

            public RenderProperties build() {
                return new RenderProperties(this);
            }
        }
    }
}

