/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import yesman.epicfight.api.client.model.ClientModel;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.client.model.CustomArmorVertex;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
public class CustomModelBakery {
    static int indexCount = 0;
    static final Map<ResourceLocation, ClientModel> BAKED_MODELS = Maps.newHashMap();
    static final ModelBaker HEAD = new SimpleBaker(9);
    static final ModelBaker LEFT_FEET = new SimpleBaker(5);
    static final ModelBaker RIGHT_FEET = new SimpleBaker(2);
    static final ModelBaker LEFT_ARM = new Limb(16, 17, 19, 19.0f, false);
    static final ModelBaker LEFT_ARM_CHILD = new SimpleSeparateBaker(16, 17, 19.0f);
    static final ModelBaker RIGHT_ARM = new Limb(11, 12, 14, 19.0f, false);
    static final ModelBaker RIGHT_ARM_CHILD = new SimpleSeparateBaker(11, 12, 19.0f);
    static final ModelBaker LEFT_LEG = new Limb(4, 5, 6, 6.0f, true);
    static final ModelBaker LEFT_LEG_CHILD = new SimpleSeparateBaker(4, 5, 6.0f);
    static final ModelBaker RIGHT_LEG = new Limb(1, 2, 3, 6.0f, true);
    static final ModelBaker RIGHT_LEG_CHILD = new SimpleSeparateBaker(1, 2, 6.0f);
    static final ModelBaker CHEST = new Chest();
    static final ModelBaker CHEST_CHILD = new SimpleSeparateBaker(8, 7, 18.0f);

    public static void exportModels(File resourcePackDirectory) throws IOException {
        File zipFile = new File(resourcePackDirectory, "epicfight_custom_armors.zip");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        for (Map.Entry<ResourceLocation, ClientModel> entry : BAKED_MODELS.entrySet()) {
            ZipEntry zipEntry = new ZipEntry(String.format("assets/%s/%s", entry.getValue().getLocation().func_110624_b(), entry.getValue().getLocation().func_110623_a()));
            Gson gson = new GsonBuilder().create();
            out.putNextEntry(zipEntry);
            out.write(gson.toJson((JsonElement)entry.getValue().getMesh().toJsonObject()).getBytes());
            out.closeEntry();
            EpicFightMod.LOGGER.info("Exported custom armor model : " + entry.getKey());
        }
        ZipEntry zipEntry = new ZipEntry("pack.mcmeta");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "epicfight_custom_armor_models");
        pack.addProperty("pack_format", (Number)Minecraft.func_71410_x().func_213229_ar().getVersion().getPackVersion());
        root.add("pack", (JsonElement)pack);
        out.putNextEntry(zipEntry);
        out.write(gson.toJson((JsonElement)root).getBytes());
        out.closeEntry();
        out.close();
    }

    static void resetRotation(ModelRenderer modelRenderer) {
        modelRenderer.field_78795_f = 0.0f;
        modelRenderer.field_78796_g = 0.0f;
        modelRenderer.field_78808_h = 0.0f;
    }

    public static ClientModel bakeBipedCustomArmorModel(BipedModel<?> model, ArmorItem armorItem, EquipmentSlotType slot, boolean debuggingMode) {
        ArrayList boxes = Lists.newArrayList();
        CustomModelBakery.resetRotation(model.field_78116_c);
        CustomModelBakery.resetRotation(model.field_178720_f);
        CustomModelBakery.resetRotation(model.field_78115_e);
        CustomModelBakery.resetRotation(model.field_178723_h);
        CustomModelBakery.resetRotation(model.field_178724_i);
        CustomModelBakery.resetRotation(model.field_178721_j);
        CustomModelBakery.resetRotation(model.field_178722_k);
        switch (slot) {
            case HEAD: {
                boxes.add(new ModelPartition(HEAD, HEAD, model.field_78116_c));
                boxes.add(new ModelPartition(HEAD, HEAD, model.field_178720_f));
                break;
            }
            case CHEST: {
                boxes.add(new ModelPartition(CHEST, CHEST_CHILD, model.field_78115_e));
                boxes.add(new ModelPartition(RIGHT_ARM, RIGHT_ARM_CHILD, model.field_178723_h));
                boxes.add(new ModelPartition(LEFT_ARM, LEFT_ARM_CHILD, model.field_178724_i));
                break;
            }
            case LEGS: {
                boxes.add(new ModelPartition(CHEST, CHEST_CHILD, model.field_78115_e));
                boxes.add(new ModelPartition(LEFT_LEG, LEFT_LEG_CHILD, model.field_178722_k));
                boxes.add(new ModelPartition(RIGHT_LEG, RIGHT_LEG_CHILD, model.field_178721_j));
                break;
            }
            case FEET: {
                boxes.add(new ModelPartition(LEFT_FEET, LEFT_FEET, model.field_178722_k));
                boxes.add(new ModelPartition(RIGHT_FEET, RIGHT_FEET, model.field_178721_j));
                break;
            }
            default: {
                return null;
            }
        }
        ResourceLocation rl = new ResourceLocation(armorItem.getRegistryName().func_110624_b(), "armor/" + armorItem.getRegistryName().func_110623_a());
        ClientModel customModel = new ClientModel(rl, CustomModelBakery.bakeMeshFromCubes(boxes, debuggingMode));
        ClientModels.LOGICAL_CLIENT.register(rl, customModel);
        BAKED_MODELS.put(armorItem.getRegistryName(), customModel);
        return customModel;
    }

    private static Mesh bakeMeshFromCubes(List<ModelPartition> partitions, boolean debuggingMode) {
        ArrayList vertices = Lists.newArrayList();
        ArrayList indices = Lists.newArrayList();
        MatrixStack poseStack = new MatrixStack();
        indexCount = 0;
        poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        poseStack.func_227861_a_(0.0, -24.0, 0.0);
        for (ModelPartition modelpartition : partitions) {
            CustomModelBakery.bake(poseStack, modelpartition, modelpartition.part, modelpartition.partBaker, vertices, indices, debuggingMode);
        }
        return CustomArmorVertex.loadVertexInformation(vertices, ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0])));
    }

    private static void bake(MatrixStack poseStack, ModelPartition modelpartition, ModelRenderer part, ModelBaker partBaker, List<CustomArmorVertex> vertices, List<Integer> indices, boolean debuggingMode) {
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)part.field_78800_c, (double)part.field_78797_d, (double)part.field_78798_e);
        if (part.field_78808_h != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(part.field_78808_h));
        }
        if (part.field_78796_g != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(part.field_78796_g));
        }
        if (part.field_78795_f != 0.0f) {
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(part.field_78795_f));
        }
        for (ModelRenderer.ModelBox cube : part.field_78804_l) {
            partBaker.bakeCube(poseStack, cube, vertices, indices);
        }
        for (ModelRenderer childParts : part.field_78805_m) {
            CustomModelBakery.bake(poseStack, modelpartition, childParts, modelpartition.childBaker, vertices, indices, debuggingMode);
        }
        poseStack.func_227865_b_();
    }

    static void putIndexCount(List<Integer> indices, int value) {
        for (int i = 0; i < 3; ++i) {
            indices.add(value);
        }
    }

    static Direction getDirectionFromVector(Vector3f directionVec) {
        for (Direction direction : Direction.values()) {
            Vector3f direcVec = new Vector3f(Float.compare(directionVec.func_195899_a(), -0.0f) == 0 ? 0.0f : directionVec.func_195899_a(), directionVec.func_195900_b(), directionVec.func_195902_c());
            if (!direcVec.equals((Object)direction.func_229386_k_())) continue;
            return direction;
        }
        return null;
    }

    static ModelRenderer.PositionTextureVertex getTranslatedVertex(ModelRenderer.PositionTextureVertex original, Matrix4f matrix) {
        Vector4f translatedPosition = new Vector4f(original.field_78243_a);
        translatedPosition.func_229372_a_(matrix);
        return new ModelRenderer.PositionTextureVertex(translatedPosition.func_195910_a(), translatedPosition.func_195913_b(), translatedPosition.func_195914_c(), original.field_78241_b, original.field_78242_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedPolygon {
        public final AnimatedVertex[] animatedVertexPositions;
        public final Vector3f normal;

        public AnimatedPolygon(AnimatedVertex[] positionsIn, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            this.normal = directionIn.func_229386_k_();
        }

        public AnimatedPolygon(AnimatedVertex[] positionsIn, float cor, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            positionsIn[0] = new AnimatedVertex(positionsIn[0], positionsIn[0].field_78241_b, positionsIn[0].field_78242_c + cor, positionsIn[0].jointId, positionsIn[0].weight);
            positionsIn[1] = new AnimatedVertex(positionsIn[1], positionsIn[1].field_78241_b, positionsIn[1].field_78242_c + cor, positionsIn[1].jointId, positionsIn[1].weight);
            positionsIn[2] = new AnimatedVertex(positionsIn[2], positionsIn[2].field_78241_b, positionsIn[2].field_78242_c - cor, positionsIn[2].jointId, positionsIn[2].weight);
            positionsIn[3] = new AnimatedVertex(positionsIn[3], positionsIn[3].field_78241_b, positionsIn[3].field_78242_c - cor, positionsIn[3].jointId, positionsIn[3].weight);
            this.normal = directionIn.func_229386_k_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedVertex
    extends ModelRenderer.PositionTextureVertex {
        final Vector3i jointId;
        final Vec3f weight;

        public AnimatedVertex(ModelRenderer.PositionTextureVertex posTexVertx, int jointId) {
            this(posTexVertx, jointId, 0, 0, 1.0f, 0.0f, 0.0f);
        }

        public AnimatedVertex(ModelRenderer.PositionTextureVertex posTexVertx, int jointId1, int jointId2, int jointId3, float weight1, float weight2, float weight3) {
            this(posTexVertx, new Vector3i(jointId1, jointId2, jointId3), new Vec3f(weight1, weight2, weight3));
        }

        public AnimatedVertex(ModelRenderer.PositionTextureVertex posTexVertx, Vector3i ids, Vec3f weights) {
            this(posTexVertx, posTexVertx.field_78241_b, posTexVertx.field_78242_c, ids, weights);
        }

        public AnimatedVertex(ModelRenderer.PositionTextureVertex posTexVertx, float u, float v, Vector3i ids, Vec3f weights) {
            super(posTexVertx.field_78243_a.func_195899_a(), posTexVertx.field_78243_a.func_195900_b(), posTexVertx.field_78243_a.func_195902_c(), u, v);
            this.jointId = ids;
            this.weight = weights;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Limb
    extends ModelBaker {
        final int upperJoint;
        final int lowerJoint;
        final int middleJoint;
        final float yClipCoord;
        final boolean bendInFront;

        public Limb(int upperJoint, int lowerJoint, int middleJoint, float yClipCoord, boolean bendInFront) {
            this.upperJoint = upperJoint;
            this.lowerJoint = lowerJoint;
            this.middleJoint = middleJoint;
            this.yClipCoord = yClipCoord;
            this.bendInFront = bendInFront;
        }

        @Override
        public void bakeCube(MatrixStack poseStack, ModelRenderer.ModelBox cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            ArrayList polygons = Lists.newArrayList();
            for (ModelRenderer.TexturedQuad quad : cube.field_78254_i) {
                Matrix4f matrix = poseStack.func_227866_c_().func_227870_a_();
                ModelRenderer.PositionTextureVertex pos0 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[0], matrix);
                ModelRenderer.PositionTextureVertex pos1 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[1], matrix);
                ModelRenderer.PositionTextureVertex pos2 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[2], matrix);
                ModelRenderer.PositionTextureVertex pos3 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[3], matrix);
                Direction direction = CustomModelBakery.getDirectionFromVector(quad.field_228312_b_);
                if (pos1.field_78243_a.func_195900_b() > this.yClipCoord != pos2.field_78243_a.func_195900_b() > this.yClipCoord) {
                    boolean isFront;
                    boolean hasSameZ;
                    int lowerId;
                    int upperId;
                    float distance = pos2.field_78243_a.func_195900_b() - pos1.field_78243_a.func_195900_b();
                    float textureV = pos1.field_78242_c + (pos2.field_78242_c - pos1.field_78242_c) * ((this.yClipCoord - pos1.field_78243_a.func_195900_b()) / distance);
                    ModelRenderer.PositionTextureVertex pos4 = new ModelRenderer.PositionTextureVertex(pos0.field_78243_a.func_195899_a(), this.yClipCoord, pos0.field_78243_a.func_195902_c(), pos0.field_78241_b, textureV);
                    ModelRenderer.PositionTextureVertex pos5 = new ModelRenderer.PositionTextureVertex(pos1.field_78243_a.func_195899_a(), this.yClipCoord, pos1.field_78243_a.func_195902_c(), pos1.field_78241_b, textureV);
                    if (distance > 0.0f) {
                        upperId = this.lowerJoint;
                        lowerId = this.upperJoint;
                    } else {
                        upperId = this.upperJoint;
                        lowerId = this.lowerJoint;
                    }
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, upperId), new AnimatedVertex(pos1, upperId), new AnimatedVertex(pos5, upperId), new AnimatedVertex(pos4, upperId)}, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, lowerId), new AnimatedVertex(pos5, lowerId), new AnimatedVertex(pos2, lowerId), new AnimatedVertex(pos3, lowerId)}, direction));
                    boolean bl = hasSameZ = pos4.field_78243_a.func_195902_c() < 0.0f == pos5.field_78243_a.func_195902_c() < 0.0f;
                    boolean bl2 = hasSameZ && pos4.field_78243_a.func_195902_c() < 0.0f == this.bendInFront ? true : (isFront = false);
                    if (isFront) {
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.middleJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos5, this.upperJoint), new AnimatedVertex(pos4, this.upperJoint)}, 0.001f, direction));
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.lowerJoint), new AnimatedVertex(pos5, this.lowerJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos4, this.middleJoint)}, 0.001f, direction));
                        continue;
                    }
                    if (hasSameZ) continue;
                    boolean startFront = pos4.field_78243_a.func_195902_c() > 0.0f;
                    int firstJoint = this.lowerJoint;
                    int secondJoint = this.lowerJoint;
                    int thirdJoint = startFront ? this.upperJoint : this.middleJoint;
                    int fourthJoint = startFront ? this.middleJoint : this.upperJoint;
                    int fifthJoint = this.upperJoint;
                    int sixthJoint = this.upperJoint;
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, firstJoint), new AnimatedVertex(pos5, secondJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos4, fourthJoint)}, 0.001f, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, fourthJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos5, fifthJoint), new AnimatedVertex(pos4, sixthJoint)}, 0.001f, direction));
                    continue;
                }
                int jointId = pos0.field_78243_a.func_195900_b() > this.yClipCoord ? this.upperJoint : this.lowerJoint;
                polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, jointId), new AnimatedVertex(pos1, jointId), new AnimatedVertex(pos2, jointId), new AnimatedVertex(pos3, jointId)}, direction));
            }
            for (AnimatedPolygon quad : polygons) {
                Vector3f norm = quad.normal.func_229195_e_();
                norm.func_229188_a_(poseStack.func_227866_c_().func_227872_b_());
                for (AnimatedVertex vertex : quad.animatedVertexPositions) {
                    Vector4f pos = new Vector4f(vertex.field_78243_a);
                    vertices.add(new CustomArmorVertex().setPosition(new Vec3f(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c()).scale(0.0625f)).setNormal(new Vec3f(norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c())).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(vertex.jointId.func_177958_n(), 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                CustomModelBakery.putIndexCount(indices, indexCount);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Chest
    extends ModelBaker {
        static final float X_PLANE = 0.0f;
        static final VertexWeight[] WEIGHT_ALONG_Y = new VertexWeight[]{new VertexWeight(13.6666f, 0.23f, 0.77f), new VertexWeight(15.8333f, 0.254f, 0.746f), new VertexWeight(18.0f, 0.5f, 0.5f), new VertexWeight(20.1666f, 0.744f, 0.256f), new VertexWeight(22.3333f, 0.77f, 0.23f)};

        Chest() {
        }

        @Override
        public void bakeCube(MatrixStack poseStack, ModelRenderer.ModelBox cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            ArrayList xClipPolygons = Lists.newArrayList();
            ArrayList xyClipPolygons = Lists.newArrayList();
            for (ModelRenderer.TexturedQuad polygon : cube.field_78254_i) {
                Matrix4f matrix = poseStack.func_227866_c_().func_227870_a_();
                ModelRenderer.PositionTextureVertex pos0 = CustomModelBakery.getTranslatedVertex(polygon.field_78239_a[0], matrix);
                ModelRenderer.PositionTextureVertex pos1 = CustomModelBakery.getTranslatedVertex(polygon.field_78239_a[1], matrix);
                ModelRenderer.PositionTextureVertex pos2 = CustomModelBakery.getTranslatedVertex(polygon.field_78239_a[2], matrix);
                ModelRenderer.PositionTextureVertex pos3 = CustomModelBakery.getTranslatedVertex(polygon.field_78239_a[3], matrix);
                Direction direction = CustomModelBakery.getDirectionFromVector(polygon.field_228312_b_);
                VertexWeight pos0Weight = Chest.getYClipWeight(pos0.field_78243_a.func_195900_b());
                VertexWeight pos1Weight = Chest.getYClipWeight(pos1.field_78243_a.func_195900_b());
                VertexWeight pos2Weight = Chest.getYClipWeight(pos2.field_78243_a.func_195900_b());
                VertexWeight pos3Weight = Chest.getYClipWeight(pos3.field_78243_a.func_195900_b());
                if (pos1.field_78243_a.func_195899_a() > 0.0f != pos2.field_78243_a.func_195899_a() > 0.0f) {
                    float distance = pos2.field_78243_a.func_195899_a() - pos1.field_78243_a.func_195899_a();
                    float textureU = pos1.field_78241_b + (pos2.field_78241_b - pos1.field_78241_b) * ((0.0f - pos1.field_78243_a.func_195899_a()) / distance);
                    ModelRenderer.PositionTextureVertex pos4 = new ModelRenderer.PositionTextureVertex(0.0f, pos0.field_78243_a.func_195900_b(), pos0.field_78243_a.func_195902_c(), textureU, pos0.field_78242_c);
                    ModelRenderer.PositionTextureVertex pos5 = new ModelRenderer.PositionTextureVertex(0.0f, pos1.field_78243_a.func_195900_b(), pos1.field_78243_a.func_195902_c(), textureU, pos1.field_78242_c);
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f)}, direction));
                    continue;
                }
                xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
            }
            for (AnimatedPolygon polygon : xClipPolygons) {
                boolean upsideDown = polygon.animatedVertexPositions[1].field_78243_a.func_195900_b() > polygon.animatedVertexPositions[2].field_78243_a.func_195900_b();
                AnimatedVertex pos0 = upsideDown ? polygon.animatedVertexPositions[2] : polygon.animatedVertexPositions[0];
                AnimatedVertex pos1 = upsideDown ? polygon.animatedVertexPositions[3] : polygon.animatedVertexPositions[1];
                AnimatedVertex pos2 = upsideDown ? polygon.animatedVertexPositions[0] : polygon.animatedVertexPositions[2];
                AnimatedVertex pos3 = upsideDown ? polygon.animatedVertexPositions[1] : polygon.animatedVertexPositions[3];
                Direction direction = CustomModelBakery.getDirectionFromVector(polygon.normal);
                List<VertexWeight> vertexWeights = Chest.getMiddleYClipWeights(pos1.field_78243_a.func_195900_b(), pos2.field_78243_a.func_195900_b());
                ArrayList animatedVertices = Lists.newArrayList();
                animatedVertices.add(pos0);
                animatedVertices.add(pos1);
                if (vertexWeights.size() > 0) {
                    for (VertexWeight vertexWeight : vertexWeights) {
                        float distance = pos2.field_78243_a.func_195900_b() - pos1.field_78243_a.func_195900_b();
                        float textureV = pos1.field_78242_c + (pos2.field_78242_c - pos1.field_78242_c) * ((vertexWeight.yClipCoord - pos1.field_78243_a.func_195900_b()) / distance);
                        ModelRenderer.PositionTextureVertex pos4 = new ModelRenderer.PositionTextureVertex(pos0.field_78243_a.func_195899_a(), vertexWeight.yClipCoord, pos0.field_78243_a.func_195902_c(), pos0.field_78241_b, textureV);
                        ModelRenderer.PositionTextureVertex pos5 = new ModelRenderer.PositionTextureVertex(pos1.field_78243_a.func_195899_a(), vertexWeight.yClipCoord, pos1.field_78243_a.func_195902_c(), pos1.field_78241_b, textureV);
                        animatedVertices.add(new AnimatedVertex(pos4, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                        animatedVertices.add(new AnimatedVertex(pos5, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                    }
                }
                animatedVertices.add(pos3);
                animatedVertices.add(pos2);
                for (int i = 0; i < (animatedVertices.size() - 2) / 2; ++i) {
                    int start = i * 2;
                    AnimatedVertex p0 = (AnimatedVertex)((Object)animatedVertices.get(start));
                    AnimatedVertex p1 = (AnimatedVertex)((Object)animatedVertices.get(start + 1));
                    AnimatedVertex p2 = (AnimatedVertex)((Object)animatedVertices.get(start + 3));
                    AnimatedVertex p3 = (AnimatedVertex)((Object)animatedVertices.get(start + 2));
                    xyClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(p0, 8, 7, 0, p0.weight.x, p0.weight.y, 0.0f), new AnimatedVertex(p1, 8, 7, 0, p1.weight.x, p1.weight.y, 0.0f), new AnimatedVertex(p2, 8, 7, 0, p2.weight.x, p2.weight.y, 0.0f), new AnimatedVertex(p3, 8, 7, 0, p3.weight.x, p3.weight.y, 0.0f)}, direction));
                }
            }
            for (AnimatedPolygon polygon : xyClipPolygons) {
                Vector3f norm = polygon.normal.func_229195_e_();
                norm.func_229188_a_(poseStack.func_227866_c_().func_227872_b_());
                for (AnimatedVertex vertex : polygon.animatedVertexPositions) {
                    int count;
                    Vector4f pos = new Vector4f(vertex.field_78243_a);
                    float weight1 = vertex.weight.x;
                    float weight2 = vertex.weight.y;
                    int joint1 = vertex.jointId.func_177958_n();
                    int joint2 = vertex.jointId.func_177956_o();
                    int n = count = weight1 > 0.0f && weight2 > 0.0f ? 2 : 1;
                    if (weight1 <= 0.0f) {
                        joint1 = joint2;
                        weight1 = weight2;
                    }
                    vertices.add(new CustomArmorVertex().setPosition(new Vec3f(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c()).scale(0.0625f)).setNormal(new Vec3f(norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c())).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(joint1, joint2, 0.0f)).setEffectiveJointWeights(new Vec3f(weight1, weight2, 0.0f)).setEffectiveJointNumber(count));
                }
                CustomModelBakery.putIndexCount(indices, indexCount);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 2);
                indexCount += 4;
            }
        }

        static VertexWeight getYClipWeight(float y) {
            if (y < Chest.WEIGHT_ALONG_Y[0].yClipCoord) {
                return new VertexWeight(y, 0.0f, 1.0f);
            }
            int index = -1;
            for (int i = 0; i < WEIGHT_ALONG_Y.length; ++i) {
            }
            if (index > 0) {
                VertexWeight pair = WEIGHT_ALONG_Y[index];
                return new VertexWeight(y, pair.chestWeight, pair.torsoWeight);
            }
            return new VertexWeight(y, 1.0f, 0.0f);
        }

        static List<VertexWeight> getMiddleYClipWeights(float minY, float maxY) {
            ArrayList cutYs = Lists.newArrayList();
            for (VertexWeight vertexWeight : WEIGHT_ALONG_Y) {
                if (!(vertexWeight.yClipCoord > minY) || !(maxY >= vertexWeight.yClipCoord)) continue;
                cutYs.add(vertexWeight);
            }
            return cutYs;
        }

        static class VertexWeight {
            final float yClipCoord;
            final float chestWeight;
            final float torsoWeight;

            public VertexWeight(float yClipCoord, float chestWeight, float torsoWeight) {
                this.yClipCoord = yClipCoord;
                this.chestWeight = chestWeight;
                this.torsoWeight = torsoWeight;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimpleSeparateBaker
    extends ModelBaker {
        final SimpleBaker upperBaker;
        final SimpleBaker lowerBaker;
        final float yClipCoord;

        public SimpleSeparateBaker(int upperJoint, int lowerJoint, float yClipCoord) {
            this.upperBaker = new SimpleBaker(upperJoint);
            this.lowerBaker = new SimpleBaker(lowerJoint);
            this.yClipCoord = yClipCoord;
        }

        @Override
        public void bakeCube(MatrixStack poseStack, ModelRenderer.ModelBox cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            Vector4f cubeCenter = new Vector4f(cube.field_78252_a + (cube.field_78248_d - cube.field_78252_a) * 0.5f, cube.field_78250_b + (cube.field_78249_e - cube.field_78250_b) * 0.5f, cube.field_78251_c + (cube.field_78246_f - cube.field_78251_c) * 0.5f, 1.0f);
            cubeCenter.func_229372_a_(poseStack.func_227866_c_().func_227870_a_());
            if (cubeCenter.func_195913_b() > this.yClipCoord) {
                this.upperBaker.bakeCube(poseStack, cube, vertices, indices);
            } else {
                this.lowerBaker.bakeCube(poseStack, cube, vertices, indices);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimpleBaker
    extends ModelBaker {
        final int jointId;

        public SimpleBaker(int jointId) {
            this.jointId = jointId;
        }

        @Override
        public void bakeCube(MatrixStack poseStack, ModelRenderer.ModelBox cube, List<CustomArmorVertex> vertices, List<Integer> indices) {
            for (ModelRenderer.TexturedQuad quad : cube.field_78254_i) {
                Vector3f norm = quad.field_228312_b_.func_229195_e_();
                norm.func_229188_a_(poseStack.func_227866_c_().func_227872_b_());
                for (ModelRenderer.PositionTextureVertex vertex : quad.field_78239_a) {
                    Vector4f pos = new Vector4f(vertex.field_78243_a);
                    pos.func_229372_a_(poseStack.func_227866_c_().func_227870_a_());
                    vertices.add(new CustomArmorVertex().setPosition(new Vec3f(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c()).scale(0.0625f)).setNormal(new Vec3f(norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c())).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(this.jointId, 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                CustomModelBakery.putIndexCount(indices, indexCount);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 3);
                CustomModelBakery.putIndexCount(indices, indexCount + 1);
                CustomModelBakery.putIndexCount(indices, indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class ModelBaker {
        ModelBaker() {
        }

        public abstract void bakeCube(MatrixStack var1, ModelRenderer.ModelBox var2, List<CustomArmorVertex> var3, List<Integer> var4);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModelPartition {
        final ModelBaker partBaker;
        final ModelBaker childBaker;
        final ModelRenderer part;

        private ModelPartition(ModelBaker partedBaker, ModelBaker childBaker, ModelRenderer modelRenderer) {
            this.partBaker = partedBaker;
            this.childBaker = childBaker;
            this.part = modelRenderer;
        }
    }
}

