/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class Collider {
    protected final Vector3d modelCenter;
    protected final AxisAlignedBB outerAABB;
    protected Vector3d worldCenter;

    public Collider(Vector3d center, @Nullable AxisAlignedBB outerAABB) {
        this.modelCenter = center;
        this.outerAABB = outerAABB;
        this.worldCenter = new Vector3d(0.0, 0.0, 0.0);
    }

    protected void transform(OpenMatrix4f mat) {
        this.worldCenter = OpenMatrix4f.transform(mat, this.modelCenter);
    }

    public List<Entity> updateAndSelectCollideEntity(LivingEntityPatch<?> entitypatch, AttackAnimation attackAnimation, float prevElapsedTime, float elapsedTime, String jointName, float attackSpeed) {
        Armature armature = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature();
        int pathIndex = armature.searchPathIndex(jointName);
        OpenMatrix4f transformMatrix = pathIndex == -1 ? new OpenMatrix4f() : Animator.getBindedJointTransformByIndex(attackAnimation.getPoseByTime(entitypatch, elapsedTime, 1.0f), armature, pathIndex);
        OpenMatrix4f toWorldCoord = OpenMatrix4f.createTranslation(-((float)((LivingEntity)entitypatch.getOriginal()).func_226277_ct_()), (float)((LivingEntity)entitypatch.getOriginal()).func_226278_cu_(), -((float)((LivingEntity)entitypatch.getOriginal()).func_226281_cx_()));
        transformMatrix.mulFront(toWorldCoord.mulBack(entitypatch.getModelMatrix(1.0f)));
        this.transform(transformMatrix);
        return this.getCollideEntities((Entity)entitypatch.getOriginal());
    }

    public List<Entity> getCollideEntities(Entity entity) {
        List list = entity.field_70170_p.func_175674_a(entity, this.getHitboxAABB(), e -> {
            if (e instanceof PartEntity && ((PartEntity)e).getParent().func_70028_i(entity)) {
                return false;
            }
            return this.isCollide((Entity)e);
        });
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawInternal(MatrixStack var1, IRenderTypeBuffer var2, OpenMatrix4f var3, boolean var4);

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        Armature armature = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature();
        int pathIndex = armature.searchPathIndex(animation.getPathIndexByTime(elapsedTime));
        boolean flag3 = entitypatch.getEntityState().attacking();
        OpenMatrix4f mat = null;
        mat = pathIndex == -1 ? new OpenMatrix4f() : Animator.getBindedJointTransformByIndex(animation.getPoseByTime(entitypatch, elapsedTime, 0.0f), armature, pathIndex);
        this.drawInternal(matrixStackIn, buffer, mat, flag3);
    }

    protected abstract boolean isCollide(Entity var1);

    protected AxisAlignedBB getHitboxAABB() {
        return this.outerAABB.func_72317_d(-this.worldCenter.field_72450_a, this.worldCenter.field_72448_b, -this.worldCenter.field_72449_c);
    }

    public String toString() {
        return "[ColliderInfo] type: " + this.getClass() + " center: " + this.modelCenter;
    }
}

