/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.entity.PartEntity;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class MultiCollider<T extends Collider>
extends Collider {
    protected T bigCollider;
    protected int numberOfColliders;

    public MultiCollider(int arrayLength, double posX, double posY, double posZ, AxisAlignedBB outerAxisAlignedBB) {
        super(new Vector3d(posX, posY, posZ), outerAxisAlignedBB);
        this.numberOfColliders = arrayLength;
    }

    protected abstract T createCollider();

    @Override
    public List<Entity> updateAndSelectCollideEntity(LivingEntityPatch<?> entitypatch, AttackAnimation attackAnimation, float prevElapsedTime, float elapsedTime, String jointName, float attackSpeed) {
        int numberOf = Math.max(Math.round((float)(this.numberOfColliders + attackAnimation.getProperty(AnimationProperty.AttackAnimationProperty.COLLIDER_ADDER).orElse(0)) * attackSpeed), 1);
        float partialScale = 1.0f / (float)(numberOf - 1);
        float interpolation = 0.0f;
        ArrayList colliders = Lists.newArrayList();
        Object original = entitypatch.getOriginal();
        for (int i = 0; i < numberOf; ++i) {
            colliders.add(this.createCollider());
        }
        AxisAlignedBB outerBox = null;
        for (Collider collider : colliders) {
            OpenMatrix4f transformMatrix;
            Armature armature = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature();
            int pathIndex = armature.searchPathIndex(jointName);
            if (pathIndex == -1) {
                transformMatrix = new OpenMatrix4f();
            } else {
                float interpolateTime = prevElapsedTime + (elapsedTime - prevElapsedTime) * interpolation;
                transformMatrix = Animator.getBindedJointTransformByIndex(attackAnimation.getPoseByTime(entitypatch, interpolateTime, 1.0f), armature, pathIndex);
            }
            double x = ((Entity)original).field_70142_S + (original.func_226277_ct_() - ((Entity)original).field_70142_S) * (double)interpolation;
            double y = ((Entity)original).field_70137_T + (original.func_226278_cu_() - ((Entity)original).field_70137_T) * (double)interpolation;
            double z = ((Entity)original).field_70136_U + (original.func_226281_cx_() - ((Entity)original).field_70136_U) * (double)interpolation;
            OpenMatrix4f mvMatrix = OpenMatrix4f.createTranslation(-((float)x), (float)y, -((float)z));
            transformMatrix.mulFront(mvMatrix.mulBack(entitypatch.getModelMatrix(interpolation)));
            collider.transform(transformMatrix);
            interpolation += partialScale;
            if (interpolation >= 1.0f) {
                this.transform(transformMatrix);
            }
            if (outerBox == null) {
                outerBox = collider.getHitboxAABB();
                continue;
            }
            outerBox.func_111270_a(collider.getHitboxAABB());
        }
        List entities = ((LivingEntity)entitypatch.getOriginal()).field_70170_p.func_175674_a(entitypatch.getOriginal(), outerBox, entity -> {
            if (entity instanceof PartEntity && ((PartEntity)entity).getParent().func_70028_i(entitypatch.getOriginal())) {
                return false;
            }
            for (Collider collider : colliders) {
                if (!collider.isCollide((Entity)entity)) continue;
                return true;
            }
            return false;
        });
        return entities;
    }

    @Override
    public void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, OpenMatrix4f pose, boolean red) {
    }

    @Override
    protected AxisAlignedBB getHitboxAABB() {
        return null;
    }

    @Override
    protected boolean isCollide(Entity opponent) {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " collider count: " + this.numberOfColliders + " real collider" + ((Collider)this.bigCollider).toString();
    }
}

