/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.collider.MultiCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MultiOBBCollider
extends MultiCollider<OBBCollider> {
    public MultiOBBCollider(int arrayLength, double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        super(arrayLength, vecX, vecY, vecZ, OBBCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ));
        this.bigCollider = new OBBCollider(this.outerAABB, posX, posY, posZ, vecX, vecY, vecZ);
    }

    @Override
    public OBBCollider createCollider() {
        return new OBBCollider(this.outerAABB, ((OBBCollider)this.bigCollider).modelVertex[1].field_72450_a, ((OBBCollider)this.bigCollider).modelVertex[1].field_72448_b, ((OBBCollider)this.bigCollider).modelVertex[1].field_72449_c, this.modelCenter.field_72450_a, this.modelCenter.field_72448_b, this.modelCenter.field_72449_c);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        int numberOf = Math.max(Math.round((float)(this.numberOfColliders + animation.getProperty(AnimationProperty.AttackAnimationProperty.COLLIDER_ADDER).orElse(0)) * attackSpeed), 1);
        float partialScale = 1.0f / (float)(numberOf - 1);
        float interpolation = 0.0f;
        Armature armature = entitypatch.getEntityModel(Models.LOGICAL_SERVER).getArmature();
        int pathIndex = armature.searchPathIndex(animation.getPathIndexByTime(elapsedTime));
        boolean red = entitypatch.getEntityState().attacking();
        ArrayList colliders = Lists.newArrayList();
        for (int i = 0; i < numberOf; ++i) {
            colliders.add(this.createCollider());
        }
        for (OBBCollider obbCollider : colliders) {
            matrixStackIn.func_227860_a_();
            OpenMatrix4f mat = null;
            armature.initializeTransform();
            mat = pathIndex == -1 ? new OpenMatrix4f() : Animator.getBindedJointTransformByIndex(((Animator)entitypatch.getAnimator()).getPose(interpolation), armature, pathIndex);
            obbCollider.drawInternal(matrixStackIn, buffer, mat, red);
            obbCollider.transform(mat);
            interpolation += partialScale;
            matrixStackIn.func_227865_b_();
        }
    }
}

