/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;

public class OBBCollider
extends Collider {
    protected final Vector3d[] modelVertex;
    protected final Vector3d[] modelNormal;
    protected Vector3d[] rotatedVertex;
    protected Vector3d[] rotatedNormal;
    protected Vec3f scale;

    public OBBCollider(double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        this(OBBCollider.getInitialAABB(posX, posY, posZ, center_x, center_y, center_z), posX, posY, posZ, center_x, center_y, center_z);
    }

    public OBBCollider(AxisAlignedBB outerAABB, double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        super(new Vector3d(center_x, center_y, center_z), outerAABB);
        this.modelVertex = new Vector3d[4];
        this.modelNormal = new Vector3d[3];
        this.rotatedVertex = new Vector3d[4];
        this.rotatedNormal = new Vector3d[3];
        this.modelVertex[0] = new Vector3d(posX, posY, -posZ);
        this.modelVertex[1] = new Vector3d(posX, posY, posZ);
        this.modelVertex[2] = new Vector3d(-posX, posY, posZ);
        this.modelVertex[3] = new Vector3d(-posX, posY, -posZ);
        this.modelNormal[0] = new Vector3d(1.0, 0.0, 0.0);
        this.modelNormal[1] = new Vector3d(0.0, 1.0, 0.0);
        this.modelNormal[2] = new Vector3d(0.0, 0.0, -1.0);
        this.rotatedVertex[0] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedVertex[1] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedVertex[2] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedVertex[3] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedNormal[0] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedNormal[1] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedNormal[2] = new Vector3d(0.0, 0.0, 0.0);
    }

    static AxisAlignedBB getInitialAABB(double posX, double posY, double posZ, double center_x, double center_y, double center_z) {
        double xLength = Math.abs(posX) + Math.abs(center_x);
        double yLength = Math.abs(posY) + Math.abs(center_y);
        double zLength = Math.abs(posZ) + Math.abs(center_z);
        double maxLength = Math.max(xLength, Math.max(yLength, zLength));
        return new AxisAlignedBB(maxLength, maxLength, maxLength, -maxLength, -maxLength, -maxLength);
    }

    public OBBCollider(AxisAlignedBB entityCallAABB, double pos1_x, double pos1_y, double pos1_z, double pos2_x, double pos2_y, double pos2_z, double norm1_x, double norm1_y, double norm1_z, double norm2_x, double norm2_y, double norm2_z, double center_x, double center_y, double center_z) {
        super(new Vector3d(center_x, center_y, center_z), entityCallAABB);
        this.modelVertex = new Vector3d[2];
        this.modelNormal = new Vector3d[2];
        this.rotatedVertex = new Vector3d[2];
        this.rotatedNormal = new Vector3d[2];
        this.modelVertex[0] = new Vector3d(pos1_x, pos1_y, pos1_z);
        this.modelVertex[1] = new Vector3d(pos2_x, pos2_y, pos2_z);
        this.modelNormal[0] = new Vector3d(norm1_x, norm1_y, norm1_z);
        this.modelNormal[1] = new Vector3d(norm2_x, norm2_y, norm2_z);
        this.rotatedVertex[0] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedVertex[1] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedNormal[0] = new Vector3d(0.0, 0.0, 0.0);
        this.rotatedNormal[1] = new Vector3d(0.0, 0.0, 0.0);
    }

    public OBBCollider(AxisAlignedBB aabbCopy) {
        super(null, null);
        this.modelVertex = null;
        this.modelNormal = null;
        double xSize = (aabbCopy.field_72336_d - aabbCopy.field_72340_a) / 2.0;
        double ySize = (aabbCopy.field_72337_e - aabbCopy.field_72338_b) / 2.0;
        double zSize = (aabbCopy.field_72334_f - aabbCopy.field_72339_c) / 2.0;
        this.worldCenter = new Vector3d(-((double)((float)aabbCopy.field_72340_a) + xSize), (double)((float)aabbCopy.field_72338_b) + ySize, -((double)((float)aabbCopy.field_72339_c) + zSize));
        this.rotatedVertex = new Vector3d[4];
        this.rotatedNormal = new Vector3d[3];
        this.rotatedVertex[0] = new Vector3d(-xSize, ySize, -zSize);
        this.rotatedVertex[1] = new Vector3d(-xSize, ySize, zSize);
        this.rotatedVertex[2] = new Vector3d(xSize, ySize, zSize);
        this.rotatedVertex[3] = new Vector3d(xSize, ySize, -zSize);
        this.rotatedNormal[0] = new Vector3d(1.0, 0.0, 0.0);
        this.rotatedNormal[1] = new Vector3d(0.0, 1.0, 0.0);
        this.rotatedNormal[2] = new Vector3d(0.0, 0.0, 1.0);
    }

    @Override
    public void transform(OpenMatrix4f modelMatrix) {
        int i;
        OpenMatrix4f noTranslation = modelMatrix.removeTranslation();
        for (i = 0; i < this.modelVertex.length; ++i) {
            this.rotatedVertex[i] = OpenMatrix4f.transform(noTranslation, this.modelVertex[i]);
        }
        for (i = 0; i < this.modelNormal.length; ++i) {
            this.rotatedNormal[i] = OpenMatrix4f.transform(noTranslation, this.modelNormal[i]);
        }
        this.scale = noTranslation.toScaleVector();
        super.transform(modelMatrix);
    }

    @Override
    protected AxisAlignedBB getHitboxAABB() {
        return this.outerAABB.func_72314_b((this.outerAABB.field_72336_d - this.outerAABB.field_72340_a) * (double)this.scale.x, (this.outerAABB.field_72337_e - this.outerAABB.field_72338_b) * (double)this.scale.y, (this.outerAABB.field_72334_f - this.outerAABB.field_72339_c) * (double)this.scale.z).func_72317_d(-this.worldCenter.field_72450_a, this.worldCenter.field_72448_b, -this.worldCenter.field_72449_c);
    }

    public boolean isCollide(OBBCollider opponent) {
        Vector3d toOpponent = opponent.worldCenter.func_178788_d(this.worldCenter);
        for (Vector3d seperateAxis : this.rotatedNormal) {
            if (OBBCollider.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        for (Vector3d seperateAxis : opponent.rotatedNormal) {
            if (OBBCollider.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCollide(Entity entity) {
        OBBCollider obb = new OBBCollider(entity.func_174813_aQ());
        return this.isCollide(obb);
    }

    private static boolean collisionDetection(Vector3d seperateAxis, Vector3d toOpponent, OBBCollider box1, OBBCollider box2) {
        double dot;
        Vector3d temp;
        Vector3d maxProj1 = null;
        Vector3d maxProj2 = null;
        double maxDot1 = -1.0;
        double maxDot2 = -1.0;
        Vector3d distance = seperateAxis.func_72430_b(toOpponent) > 0.0 ? toOpponent : toOpponent.func_186678_a(-1.0);
        for (Vector3d vertexVector : box1.rotatedVertex) {
            temp = seperateAxis.func_72430_b(vertexVector) > 0.0 ? vertexVector : vertexVector.func_186678_a(-1.0);
            dot = seperateAxis.func_72430_b(temp);
            if (!(dot > maxDot1)) continue;
            maxDot1 = dot;
            maxProj1 = temp;
        }
        for (Vector3d vertexVector : box2.rotatedVertex) {
            temp = seperateAxis.func_72430_b(vertexVector) > 0.0 ? vertexVector : vertexVector.func_186678_a(-1.0);
            dot = seperateAxis.func_72430_b(temp);
            if (!(dot > maxDot2)) continue;
            maxDot2 = dot;
            maxProj2 = temp;
        }
        return !(MathUtils.projectVector(distance, seperateAxis).func_72433_c() > MathUtils.projectVector(maxProj1, seperateAxis).func_72433_c() + MathUtils.projectVector(maxProj2, seperateAxis).func_72433_c());
    }

    @Override
    public String toString() {
        return super.toString() + " direction : " + this.worldCenter;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, OpenMatrix4f pose, boolean red) {
        IVertexBuilder vertexBuilder = buffer.getBuffer(EpicFightRenderTypes.debugCollider());
        OpenMatrix4f transpose = new OpenMatrix4f();
        OpenMatrix4f.transpose(pose, transpose);
        matrixStackIn.func_227860_a_();
        MathUtils.translateStack(matrixStackIn, pose);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
        Vector3d vec = this.modelVertex[1];
        float maxX = (float)(this.modelCenter.field_72450_a + vec.field_72450_a);
        float maxY = (float)(this.modelCenter.field_72448_b + vec.field_72448_b);
        float maxZ = (float)(this.modelCenter.field_72449_c + vec.field_72449_c);
        float minX = (float)(this.modelCenter.field_72450_a - vec.field_72450_a);
        float minY = (float)(this.modelCenter.field_72448_b - vec.field_72448_b);
        float minZ = (float)(this.modelCenter.field_72449_c - vec.field_72449_c);
        float color = red ? 0.0f : 1.0f;
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        matrixStackIn.func_227865_b_();
    }
}

