/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.data.reloader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.world.capabilities.item.ArmorCapability;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.TagBasedSeparativeCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCapabilityPresets;
import yesman.epicfight.world.capabilities.provider.ProviderItem;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class ItemCapabilityReloadListener
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<Item, CompoundNBT> CAPABILITY_ARMOR_DATA_MAP = Maps.newHashMap();
    private static final Map<Item, CompoundNBT> CAPABILITY_WEAPON_DATA_MAP = Maps.newHashMap();
    private static boolean armorReceived = false;
    private static boolean weaponReceived = false;

    public ItemCapabilityReloadListener() {
        super(GSON, "capabilities");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            CapabilityItem capability;
            ResourceLocation rl = entry.getKey();
            String path = rl.func_110623_a();
            if (!path.contains("/")) continue;
            String[] str = path.split("/", 2);
            ResourceLocation registryName = new ResourceLocation(rl.func_110624_b(), str[1]);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
            if (item == null) {
                EpicFightMod.LOGGER.warn("Tried to add a capabiltiy for item " + registryName + ", but it's not exist!");
                return;
            }
            CompoundNBT nbt = null;
            try {
                nbt = JsonToNBT.func_180713_a((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            if (str[0].equals("armors")) {
                capability = ItemCapabilityReloadListener.deserializeArmor(item, nbt);
                ProviderItem.put(item, capability);
                CAPABILITY_ARMOR_DATA_MAP.put(item, nbt);
                continue;
            }
            if (!str[0].equals("weapons")) continue;
            capability = ItemCapabilityReloadListener.deserializeWeapon(item, nbt, null);
            ProviderItem.put(item, capability);
            CAPABILITY_WEAPON_DATA_MAP.put(item, nbt);
        }
        ProviderItem.addDefaultItems();
    }

    public static CapabilityItem deserializeArmor(Item item, CompoundNBT tag) {
        ArmorCapability.Builder builder = ArmorCapability.builder();
        if (tag.func_74764_b("attributes")) {
            CompoundNBT attributes = tag.func_74775_l("attributes");
            builder.weight(attributes.func_74769_h("weight")).stunArmor(attributes.func_74769_h("stun_armor"));
        }
        builder.item(item);
        return builder.build();
    }

    public static CapabilityItem deserializeWeapon(Item item, CompoundNBT tag, CapabilityItem.Builder defaultCapability) {
        CapabilityItem capability;
        if (tag.func_74764_b("variations")) {
            ListNBT jsonArray = tag.func_150295_c("variations", 10);
            ArrayList list = Lists.newArrayList();
            CapabilityItem.Builder innerDefaultCapabilityBuilder = tag.func_74764_b("type") ? WeaponCapabilityPresets.get(tag.func_74779_i("type")).apply(item) : CapabilityItem.builder();
            for (Object jsonElement : jsonArray) {
                CompoundNBT innerTag = (CompoundNBT)jsonElement;
                String nbtKey = innerTag.func_74779_i("nbt_key");
                String nbtValue = innerTag.func_74779_i("nbt_value");
                Predicate<ItemStack> predicate = itemstack -> {
                    CompoundNBT compound = itemstack.func_77978_p();
                    if (compound == null) {
                        return false;
                    }
                    return compound.func_74764_b(nbtKey) ? compound.func_74779_i(nbtKey).equals(nbtValue) : false;
                };
                list.add(Pair.of(predicate, (Object)ItemCapabilityReloadListener.deserializeWeapon(item, innerTag, innerDefaultCapabilityBuilder)));
            }
            if (tag.func_74764_b("attributes")) {
                CompoundNBT attributes = tag.func_74775_l("attributes");
                for (String key : attributes.func_150296_c()) {
                    Map<Attribute, AttributeModifier> attributeEntry = ItemCapabilityReloadListener.deserializeAttributes(attributes.func_74775_l(key));
                    for (Map.Entry<Attribute, AttributeModifier> attribute : attributeEntry.entrySet()) {
                        innerDefaultCapabilityBuilder.addStyleAttibutes(Style.ENUM_MANAGER.get(key), (Pair<Attribute, AttributeModifier>)Pair.of((Object)attribute.getKey(), (Object)attribute.getValue()));
                    }
                }
            }
            capability = new TagBasedSeparativeCapability(list, innerDefaultCapabilityBuilder.build());
        } else {
            CapabilityItem.Builder builder;
            CapabilityItem.Builder builder2 = builder = tag.func_74764_b("type") ? WeaponCapabilityPresets.get(tag.func_74779_i("type")).apply(item) : CapabilityItem.builder();
            if (tag.func_74764_b("attributes")) {
                CompoundNBT attributes = tag.func_74775_l("attributes");
                for (String key : attributes.func_150296_c()) {
                    Map<Attribute, AttributeModifier> attributeEntry = ItemCapabilityReloadListener.deserializeAttributes(attributes.func_74775_l(key));
                    for (Map.Entry<Attribute, AttributeModifier> attribute : attributeEntry.entrySet()) {
                        builder.addStyleAttibutes(Style.ENUM_MANAGER.get(key), (Pair<Attribute, AttributeModifier>)Pair.of((Object)attribute.getKey(), (Object)attribute.getValue()));
                    }
                }
            }
            if (tag.func_74764_b("collider") && builder instanceof WeaponCapability.Builder) {
                CompoundNBT colliderTag = tag.func_74775_l("collider");
                Collider collider = ItemCapabilityReloadListener.deserializeCollider(item, colliderTag);
                ((WeaponCapability.Builder)builder).collider(collider);
            }
            capability = builder.build();
        }
        return capability;
    }

    private static Map<Attribute, AttributeModifier> deserializeAttributes(CompoundNBT tag) {
        HashMap modifierMap = Maps.newHashMap();
        if (tag.func_74764_b("armor_negation")) {
            modifierMap.put(EpicFightAttributes.ARMOR_NEGATION.get(), EpicFightAttributes.getArmorNegationModifier(tag.func_74769_h("armor_negation")));
        }
        if (tag.func_74764_b("impact")) {
            modifierMap.put(EpicFightAttributes.IMPACT.get(), EpicFightAttributes.getImpactModifier(tag.func_74769_h("impact")));
        }
        if (tag.func_74764_b("max_strikes")) {
            modifierMap.put(EpicFightAttributes.MAX_STRIKES.get(), EpicFightAttributes.getMaxStrikesModifier(tag.func_74762_e("max_strikes")));
        }
        if (tag.func_74764_b("damage_bonus")) {
            modifierMap.put(Attributes.field_233823_f_, EpicFightAttributes.getDamageBonusModifier(tag.func_74769_h("damage_bonus")));
        }
        if (tag.func_74764_b("speed_bonus")) {
            modifierMap.put(Attributes.field_233825_h_, EpicFightAttributes.getSpeedBonusModifier(tag.func_74769_h("speed_bonus")));
        }
        return modifierMap;
    }

    private static Collider deserializeCollider(Item item, CompoundNBT tag) {
        int number = tag.func_74762_e("number");
        if (number < 1) {
            EpicFightMod.LOGGER.warn("Datapack deserialization error: the number of colliders must bigger than 0! " + item);
            return null;
        }
        ListNBT sizeVector = tag.func_150295_c("size", 6);
        ListNBT centerVector = tag.func_150295_c("center", 6);
        double sizeX = sizeVector.func_150309_d(0);
        double sizeY = sizeVector.func_150309_d(1);
        double sizeZ = sizeVector.func_150309_d(2);
        double centerX = centerVector.func_150309_d(0);
        double centerY = centerVector.func_150309_d(1);
        double centerZ = centerVector.func_150309_d(2);
        if (sizeX < 0.0 || sizeY < 0.0 || sizeZ < 0.0) {
            EpicFightMod.LOGGER.warn("Datapack deserialization error: the size of the collider must be non-negative! " + item);
            return null;
        }
        if (number == 1) {
            return new OBBCollider(sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
        }
        return new MultiOBBCollider(number, sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
    }

    public static Stream<CompoundNBT> getArmorDataStream() {
        Stream<CompoundNBT> tagStream = CAPABILITY_ARMOR_DATA_MAP.entrySet().stream().map(entry -> {
            ((CompoundNBT)entry.getValue()).func_74768_a("id", Item.func_150891_b((Item)((Item)entry.getKey())));
            return (CompoundNBT)entry.getValue();
        });
        return tagStream;
    }

    public static Stream<CompoundNBT> getWeaponDataStream() {
        Stream<CompoundNBT> tagStream = CAPABILITY_WEAPON_DATA_MAP.entrySet().stream().map(entry -> {
            ((CompoundNBT)entry.getValue()).func_74768_a("id", Item.func_150891_b((Item)((Item)entry.getKey())));
            return (CompoundNBT)entry.getValue();
        });
        return tagStream;
    }

    public static int armorCount() {
        return CAPABILITY_ARMOR_DATA_MAP.size();
    }

    public static int weaponCount() {
        return CAPABILITY_WEAPON_DATA_MAP.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void reset() {
        armorReceived = false;
        weaponReceived = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        switch (packet.getType()) {
            case ARMOR: {
                for (CompoundNBT tag2 : packet.getTags()) {
                    Item item2 = Item.func_150899_d((int)tag2.func_74762_e("id"));
                    CAPABILITY_ARMOR_DATA_MAP.put(item2, tag2);
                }
                armorReceived = true;
                break;
            }
            case WEAPON: {
                for (CompoundNBT tag3 : packet.getTags()) {
                    Item item3 = Item.func_150899_d((int)tag3.func_74762_e("id"));
                    CAPABILITY_WEAPON_DATA_MAP.put(item3, tag3);
                }
                weaponReceived = true;
                break;
            }
        }
        if (armorReceived && weaponReceived) {
            CAPABILITY_ARMOR_DATA_MAP.forEach((item, tag) -> ProviderItem.put(item, ItemCapabilityReloadListener.deserializeArmor(item, tag)));
            CAPABILITY_WEAPON_DATA_MAP.forEach((item, tag) -> ProviderItem.put(item, ItemCapabilityReloadListener.deserializeWeapon(item, tag, null)));
            ProviderItem.addDefaultItems();
        }
    }
}

