/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.data.reloader;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.data.reloader.EpicFightPredicates;
import yesman.epicfight.api.utils.ExtendedDamageSource;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.server.SPDatapackSync;
import yesman.epicfight.world.capabilities.entitypatch.CustomHumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.CustomMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.provider.ProviderEntity;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class MobPatchReloadListener
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<EntityType<?>, CompoundNBT> TAGMAP = Maps.newHashMap();
    private static final Map<EntityType<?>, AbstractMobPatchProvider> MOB_PATCH_PROVIDERS = Maps.newHashMap();

    public MobPatchReloadListener() {
        super(GSON, "epicfight_mobpatch");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String pathString = rl.func_110623_a();
            ResourceLocation registryName = new ResourceLocation(rl.func_110624_b(), pathString);
            if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
                EpicFightMod.LOGGER.warn("[Custom Entity] Entity named " + registryName + " does not exist");
                continue;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(registryName);
            CompoundNBT tag = null;
            try {
                tag = JsonToNBT.func_180713_a((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            MOB_PATCH_PROVIDERS.put(entityType, MobPatchReloadListener.deserialize(tag, false));
            ProviderEntity.putCustomEntityPatch(entityType, entity -> () -> MOB_PATCH_PROVIDERS.get(entity.func_200600_R()).get((Entity)entity));
            TAGMAP.put(entityType, MobPatchReloadListener.filterClientData(tag));
            if (!EpicFightMod.isPhysicalClient()) continue;
            ClientEngine.instance.renderEngine.registerCustomEntityRenderer(entityType, tag.func_74764_b("preset") ? tag.func_74779_i("preset") : tag.func_74779_i("renderer"));
        }
    }

    public static AbstractMobPatchProvider deserialize(CompoundNBT tag, boolean clientSide) {
        AbstractMobPatchProvider provider = null;
        int i = 0;
        boolean hasBranch = tag.func_74764_b(String.format("branch_%d", i));
        if (hasBranch) {
            provider = new BranchProvider();
            provider.defaultProvider = MobPatchReloadListener.deserializeMobPatchProvider(tag, clientSide);
        } else {
            provider = MobPatchReloadListener.deserializeMobPatchProvider(tag, clientSide);
        }
        while (hasBranch) {
            CompoundNBT branchTag = tag.func_74775_l(String.format("branch_%d", i));
            provider.providers.add((Pair<EpicFightPredicates<Entity>, AbstractMobPatchProvider>)Pair.of(MobPatchReloadListener.deserializePredicate(branchTag.func_74775_l("condition")), (Object)MobPatchReloadListener.deserialize(branchTag, clientSide)));
            hasBranch = tag.func_74764_b(String.format("branch_%d", ++i));
        }
        return provider;
    }

    public static EpicFightPredicates<Entity> deserializePredicate(CompoundNBT tag) {
        String predicateType = tag.func_74779_i("predicate");
        EpicFightPredicates.HasTag predicate = null;
        ArrayList loggerNote = Lists.newArrayList();
        switch (predicateType) {
            case "has_tags": {
                if (!tag.func_150297_b("tags", 9)) {
                    loggerNote.add(new String[]{"has_tags", "tags", "string list"});
                }
                predicate = new EpicFightPredicates.HasTag(tag.func_150295_c("tags", 8));
            }
        }
        for (String[] formatArgs : loggerNote) {
            EpicFightMod.LOGGER.info(String.format("[Custom Entity Error] can't find a proper argument for %s. [name: %s, type: %s]", formatArgs));
        }
        if (predicate == null) {
            throw new IllegalArgumentException("[Custom Entity Error] No predicate type: " + predicateType);
        }
        return predicate;
    }

    public static AbstractMobPatchProvider deserializeMobPatchProvider(CompoundNBT tag, boolean clientSide) {
        boolean disabled;
        boolean bl = disabled = tag.func_74764_b("disabled") ? tag.func_74767_n("disabled") : false;
        if (disabled) {
            return new NullPatchProvider();
        }
        if (tag.func_74764_b("preset")) {
            Function<Entity, Supplier<EntityPatch<?>>> preset = ProviderEntity.get(tag.func_74779_i("preset"));
            MobPatchPresetProvider provider = new MobPatchPresetProvider();
            provider.presetProvider = preset;
            return provider;
        }
        boolean humanoid = tag.func_74767_n("isHumanoid") ? tag.func_74767_n("isHumanoid") : false;
        CustomMobPatchProvider provider = humanoid ? new CustomHumanoidMobPatchProvider() : new CustomMobPatchProvider();
        provider.attributeValues = MobPatchReloadListener.deserializeAttributes(tag.func_74775_l("attributes"));
        provider.modelLocation = new ResourceLocation(tag.func_74779_i("model"));
        provider.defaultAnimations = MobPatchReloadListener.deserializeDefaultAnimations(tag.func_74775_l("default_livingmotions"));
        provider.faction = Faction.valueOf(tag.func_74779_i("faction").toUpperCase(Locale.ROOT));
        float f = provider.scale = tag.func_74775_l("attributes").func_74764_b("scale") ? (float)tag.func_74775_l("attributes").func_74769_h("scale") : 1.0f;
        if (!clientSide) {
            provider.stunAnimations = MobPatchReloadListener.deserializeStunAnimations(tag.func_74775_l("stun_animations"));
            provider.chasingSpeed = tag.func_74775_l("attributes").func_74769_h("chasing_speed");
            if (humanoid) {
                CustomMobPatchProvider humanoidProvider = provider;
                humanoidProvider.humanoidCombatBehaviors = MobPatchReloadListener.deserializeHumanoidCombatBehaviors(tag.func_150295_c("combat_behavior", 10));
                humanoidProvider.humanoidWeaponMotions = MobPatchReloadListener.deserializeHumanoidWeaponMotions(tag.func_150295_c("humanoid_weapon_motions", 10));
            } else {
                provider.combatBehaviorsBuilder = MobPatchReloadListener.deserializeCombatBehaviorsBuilder(tag.func_150295_c("combat_behavior", 10));
            }
        }
        return provider;
    }

    public static Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> deserializeHumanoidCombatBehaviors(ListNBT tag) {
        HashMap combatBehaviorsMapBuilder = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundNBT combatBehavior = tag.func_150305_b(i);
            ListNBT categories = combatBehavior.func_150295_c("weapon_categories", 8);
            Style style = Style.ENUM_MANAGER.get(combatBehavior.func_74779_i("style"));
            CombatBehaviors.Builder builder = MobPatchReloadListener.deserializeCombatBehaviorsBuilder(combatBehavior.func_150295_c("behavior_series", 10));
            for (int j = 0; j < categories.size(); ++j) {
                WeaponCategory category = WeaponCategory.ENUM_MANAGER.get(categories.func_150307_f(j));
                combatBehaviorsMapBuilder.computeIfAbsent(category, key -> Maps.newHashMap());
                ((Map)combatBehaviorsMapBuilder.get(category)).put(style, builder);
            }
        }
        return combatBehaviorsMapBuilder;
    }

    public static List<Pair<LivingMotion, StaticAnimation>> deserializeDefaultAnimations(CompoundNBT defaultLivingmotions) {
        ArrayList defaultAnimations = Lists.newArrayList();
        for (String key : defaultLivingmotions.func_150296_c()) {
            String animation = defaultLivingmotions.func_74779_i(key);
            defaultAnimations.add(Pair.of((Object)LivingMotion.ENUM_MANAGER.get(key), (Object)EpicFightMod.getInstance().animationManager.findAnimationByPath(animation)));
        }
        return defaultAnimations;
    }

    public static Map<ExtendedDamageSource.StunType, StaticAnimation> deserializeStunAnimations(CompoundNBT tag) {
        HashMap stunAnimations = Maps.newHashMap();
        stunAnimations.put(ExtendedDamageSource.StunType.SHORT, EpicFightMod.getInstance().animationManager.findAnimationByPath(tag.func_74779_i("short")));
        stunAnimations.put(ExtendedDamageSource.StunType.LONG, EpicFightMod.getInstance().animationManager.findAnimationByPath(tag.func_74779_i("long")));
        stunAnimations.put(ExtendedDamageSource.StunType.FALL, EpicFightMod.getInstance().animationManager.findAnimationByPath(tag.func_74779_i("fall")));
        stunAnimations.put(ExtendedDamageSource.StunType.KNOCKDOWN, EpicFightMod.getInstance().animationManager.findAnimationByPath(tag.func_74779_i("knockdown")));
        stunAnimations.put(ExtendedDamageSource.StunType.HOLD, EpicFightMod.getInstance().animationManager.findAnimationByPath(tag.func_74779_i("short")));
        return stunAnimations;
    }

    public static Map<Attribute, Double> deserializeAttributes(CompoundNBT tag) {
        HashMap attributes = Maps.newHashMap();
        attributes.put(EpicFightAttributes.IMPACT.get(), tag.func_150297_b("impact", 6) ? tag.func_74769_h("impact") : 0.5);
        attributes.put(EpicFightAttributes.ARMOR_NEGATION.get(), tag.func_150297_b("armor_negation", 6) ? tag.func_74769_h("armor_negation") : 0.0);
        attributes.put(EpicFightAttributes.MAX_STRIKES.get(), Double.valueOf(tag.func_150297_b("max_strikes", 3) ? tag.func_74762_e("max_strikes") : 1));
        if (tag.func_150297_b("attack_damage", 6)) {
            attributes.put(Attributes.field_233823_f_, tag.func_74769_h("attack_damage"));
        }
        return attributes;
    }

    public static Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> deserializeHumanoidWeaponMotions(ListNBT tag) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            ImmutableSet.Builder motions = ImmutableSet.builder();
            CompoundNBT weaponMotionTag = tag.func_150305_b(i);
            Style style = Style.ENUM_MANAGER.get(weaponMotionTag.func_74779_i("style"));
            CompoundNBT motionsTag = weaponMotionTag.func_74775_l("livingmotions");
            for (String key : motionsTag.func_150296_c()) {
                motions.add((Object)Pair.of((Object)LivingMotion.ENUM_MANAGER.get(key), (Object)EpicFightMod.getInstance().animationManager.findAnimationByPath(motionsTag.func_74779_i(key))));
            }
            INBT weponTypeTag = weaponMotionTag.func_74781_a("weapon_categories");
            if (weponTypeTag instanceof StringNBT) {
                WeaponCategory weaponCategory = WeaponCategory.ENUM_MANAGER.get(weponTypeTag.func_150285_a_());
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, motions.build());
                continue;
            }
            if (!(weponTypeTag instanceof ListNBT)) continue;
            ListNBT weponTypesTag = (ListNBT)weponTypeTag;
            for (int j = 0; j < weponTypesTag.size(); ++j) {
                WeaponCategory weaponCategory = WeaponCategory.ENUM_MANAGER.get(weponTypesTag.func_150307_f(j));
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, motions.build());
            }
        }
        return map;
    }

    public static <T extends MobPatch<?>> CombatBehaviors.Builder<T> deserializeCombatBehaviorsBuilder(ListNBT tag) {
        CombatBehaviors.Builder builder = CombatBehaviors.builder();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundNBT behaviorSeries = tag.func_150305_b(i);
            float weight = (float)behaviorSeries.func_74769_h("weight");
            int cooldown = behaviorSeries.func_74764_b("cooldown") ? behaviorSeries.func_74762_e("cooldown") : 0;
            boolean canBeInterrupted = behaviorSeries.func_74764_b("canBeInterrupted") ? behaviorSeries.func_74767_n("canBeInterrupted") : false;
            boolean looping = behaviorSeries.func_74764_b("looping") ? behaviorSeries.func_74767_n("looping") : false;
            ListNBT behaviorList = behaviorSeries.func_150295_c("behaviors", 10);
            CombatBehaviors.BehaviorSeries.Builder behaviorSeriesBuilder = CombatBehaviors.BehaviorSeries.builder();
            behaviorSeriesBuilder.weight(weight).cooldown(cooldown).canBeInterrupted(canBeInterrupted).looping(looping);
            for (int j = 0; j < behaviorList.size(); ++j) {
                CombatBehaviors.Behavior.Builder<T> behaviorBuilder = CombatBehaviors.Behavior.builder();
                CompoundNBT behavior = behaviorList.func_150305_b(j);
                StaticAnimation animation = EpicFightMod.getInstance().animationManager.findAnimationByPath(behavior.func_74779_i("animation"));
                ListNBT conditionList = behavior.func_150295_c("conditions", 10);
                behaviorBuilder.animationBehavior(animation);
                for (int k = 0; k < conditionList.size(); ++k) {
                    CompoundNBT condition = conditionList.func_150305_b(k);
                    CombatBehaviors.BehaviorPredicate<T> predicate = MobPatchReloadListener.deserializeBehaviorPredicate(condition.func_74779_i("predicate"), condition);
                    behaviorBuilder.predicate(predicate);
                }
                behaviorSeriesBuilder.nextBehavior(behaviorBuilder);
            }
            builder.newBehaviorSeries(behaviorSeriesBuilder);
        }
        return builder;
    }

    public static <T extends MobPatch<?>> CombatBehaviors.BehaviorPredicate<T> deserializeBehaviorPredicate(String type, CompoundNBT args) {
        CombatBehaviors.BehaviorPredicate predicate = null;
        ArrayList loggerNote = Lists.newArrayList();
        switch (type) {
            case "random_chance": {
                if (!args.func_150297_b("chance", 6)) {
                    loggerNote.add(new String[]{"random_chance", "chance", "double", "0.0"});
                }
                predicate = new CombatBehaviors.RandomChance((float)args.func_74769_h("chance"));
                break;
            }
            case "within_eye_height": {
                predicate = new CombatBehaviors.TargetWithinEyeHeight();
                break;
            }
            case "within_distance": {
                if (!args.func_150297_b("min", 6)) {
                    loggerNote.add(new String[]{"within_distance", "min", "double", "0.0"});
                }
                if (!args.func_150297_b("max", 6)) {
                    loggerNote.add(new String[]{"within_distance", "max", "double", "0.0"});
                }
                predicate = new CombatBehaviors.TargetWithinDistance(args.func_74769_h("min"), args.func_74769_h("max"));
                break;
            }
            case "within_angle": {
                if (!args.func_150297_b("min", 6)) {
                    loggerNote.add(new String[]{"within_angle", "within_distance", "min", "double", "0.0F"});
                }
                if (!args.func_150297_b("max", 6)) {
                    loggerNote.add(new String[]{"within_angle", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle(args.func_74769_h("min"), args.func_74769_h("max"));
                break;
            }
            case "within_angle_horizontal": {
                if (!args.func_150297_b("min", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "min", "double", "0.0F"});
                }
                if (!args.func_150297_b("max", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle.Horizontal(args.func_74769_h("min"), args.func_74769_h("max"));
                break;
            }
            case "health": {
                if (!args.func_150297_b("health", 6)) {
                    loggerNote.add(new String[]{"health", "health", "double", "0.0F"});
                }
                if (!args.func_150297_b("comparator", 8)) {
                    loggerNote.add(new String[]{"health", "comparator", "string", ""});
                }
                predicate = new CombatBehaviors.Health((float)args.func_74769_h("health"), CombatBehaviors.Health.Comparator.valueOf(args.func_74779_i("comparator").toUpperCase(Locale.ROOT)));
            }
        }
        for (String[] formatArgs : loggerNote) {
            EpicFightMod.LOGGER.info(String.format("[Custom Entity Error] can't find a proper argument for %s. [name: %s, type: %s, default: %s]", formatArgs));
        }
        if (predicate == null) {
            throw new IllegalArgumentException("[Custom Entity Error] No predicate type: " + type);
        }
        return predicate;
    }

    public static CompoundNBT filterClientData(CompoundNBT tag) {
        CompoundNBT clientTag = new CompoundNBT();
        int i = 0;
        boolean hasBranch = tag.func_74764_b(String.format("branch_%d", i));
        while (hasBranch) {
            CompoundNBT branchTag = tag.func_74775_l(String.format("branch_%d", i));
            CompoundNBT copiedTag = new CompoundNBT();
            MobPatchReloadListener.extractBranch(copiedTag, branchTag);
            clientTag.func_218657_a(String.format("branch_%d", i), (INBT)copiedTag);
            hasBranch = tag.func_74764_b(String.format("branch_%d", ++i));
        }
        MobPatchReloadListener.extractBranch(clientTag, tag);
        return clientTag;
    }

    public static CompoundNBT extractBranch(CompoundNBT extract, CompoundNBT original) {
        if (original.func_74764_b("disabled") && original.func_74767_n("disabled")) {
            extract.func_218657_a("disabled", original.func_74781_a("disabled"));
        } else if (original.func_74764_b("preset")) {
            extract.func_218657_a("preset", original.func_74781_a("preset"));
        } else {
            extract.func_218657_a("model", original.func_74781_a("model"));
            extract.func_74757_a("isHumanoid", original.func_74764_b("isHumanoid") ? original.func_74767_n("isHumanoid") : false);
            extract.func_218657_a("renderer", original.func_74781_a("renderer"));
            extract.func_218657_a("faction", original.func_74781_a("faction"));
            extract.func_218657_a("default_livingmotions", original.func_74781_a("default_livingmotions"));
            extract.func_218657_a("attributes", original.func_74781_a("attributes"));
        }
        return extract;
    }

    public static Stream<CompoundNBT> getDataStream() {
        Stream<CompoundNBT> tagStream = TAGMAP.entrySet().stream().map(entry -> {
            ((CompoundNBT)entry.getValue()).func_74778_a("id", ((EntityType)entry.getKey()).getRegistryName().toString());
            return (CompoundNBT)entry.getValue();
        });
        return tagStream;
    }

    public static int getTagSize() {
        return TAGMAP.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        for (CompoundNBT tag : packet.getTags()) {
            boolean disabled = false;
            if (tag.func_74764_b("disabled")) {
                disabled = tag.func_74767_n("disabled");
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.func_74779_i("id")));
            MOB_PATCH_PROVIDERS.put(entityType, MobPatchReloadListener.deserialize(tag, true));
            ProviderEntity.putCustomEntityPatch(entityType, entity -> () -> MOB_PATCH_PROVIDERS.get(entity.func_200600_R()).get((Entity)entity));
            if (disabled) continue;
            ClientEngine.instance.renderEngine.registerCustomEntityRenderer(entityType, tag.func_74764_b("preset") ? tag.func_74779_i("preset") : tag.func_74779_i("renderer"));
        }
    }

    public static class CustomMobPatchProvider
    extends AbstractMobPatchProvider {
        protected ResourceLocation modelLocation;
        protected CombatBehaviors.Builder<?> combatBehaviorsBuilder;
        protected List<Pair<LivingMotion, StaticAnimation>> defaultAnimations;
        protected Map<ExtendedDamageSource.StunType, StaticAnimation> stunAnimations;
        protected Map<Attribute, Double> attributeValues;
        protected Faction faction;
        protected double chasingSpeed;
        protected float scale;

        @Override
        public EntityPatch<?> get(Entity entity) {
            return new CustomMobPatch(this.faction, this);
        }

        public ResourceLocation getModelLocation() {
            return this.modelLocation;
        }

        public CombatBehaviors.Builder<?> getCombatBehaviorsBuilder() {
            return this.combatBehaviorsBuilder;
        }

        public List<Pair<LivingMotion, StaticAnimation>> getDefaultAnimations() {
            return this.defaultAnimations;
        }

        public Map<ExtendedDamageSource.StunType, StaticAnimation> getStunAnimations() {
            return this.stunAnimations;
        }

        public Map<Attribute, Double> getAttributeValues() {
            return this.attributeValues;
        }

        public double getChasingSpeed() {
            return this.chasingSpeed;
        }

        public float getScale() {
            return this.scale;
        }
    }

    public static class CustomHumanoidMobPatchProvider
    extends CustomMobPatchProvider {
        protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> humanoidCombatBehaviors;
        protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> humanoidWeaponMotions;

        @Override
        public EntityPatch<?> get(Entity entity) {
            return new CustomHumanoidMobPatch(this.faction, this);
        }

        public Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> getHumanoidWeaponMotions() {
            return this.humanoidWeaponMotions;
        }

        public Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> getHumanoidCombatBehaviors() {
            return this.humanoidCombatBehaviors;
        }
    }

    public static class MobPatchPresetProvider
    extends AbstractMobPatchProvider {
        protected Function<Entity, Supplier<EntityPatch<?>>> presetProvider;

        @Override
        public EntityPatch<?> get(Entity entity) {
            return this.presetProvider.apply(entity).get();
        }
    }

    public static class BranchProvider
    extends AbstractMobPatchProvider {
        protected List<Pair<EpicFightPredicates<Entity>, AbstractMobPatchProvider>> providers = Lists.newArrayList();
        protected AbstractMobPatchProvider defaultProvider;

        @Override
        public EntityPatch<?> get(Entity entity) {
            for (Pair<EpicFightPredicates<Entity>, AbstractMobPatchProvider> provider : this.providers) {
                if (!((EpicFightPredicates)provider.getFirst()).test(entity)) continue;
                return ((AbstractMobPatchProvider)provider.getSecond()).get(entity);
            }
            return this.defaultProvider.get(entity);
        }
    }

    public static class NullPatchProvider
    extends AbstractMobPatchProvider {
        @Override
        public EntityPatch<?> get(Entity entity) {
            return null;
        }
    }

    public static abstract class AbstractMobPatchProvider {
        public abstract EntityPatch<?> get(Entity var1);
    }
}

